/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.pattern;

import com.thaiopensource.relaxng.pattern.AttributePattern;
import com.thaiopensource.relaxng.pattern.DataExceptPattern;
import com.thaiopensource.relaxng.pattern.DataPattern;
import com.thaiopensource.relaxng.pattern.ElementPattern;
import com.thaiopensource.relaxng.pattern.ErrorPattern;
import com.thaiopensource.relaxng.pattern.ListPattern;
import com.thaiopensource.relaxng.pattern.NameClass;
import com.thaiopensource.relaxng.pattern.Pattern;
import com.thaiopensource.relaxng.pattern.PatternBuilder;
import com.thaiopensource.relaxng.pattern.PatternInterner;
import com.thaiopensource.relaxng.pattern.TextPattern;
import com.thaiopensource.relaxng.pattern.UnexpandedNotAllowedPattern;
import com.thaiopensource.relaxng.pattern.ValuePattern;
import com.thaiopensource.xml.util.Name;
import java.util.List;
import org.relaxng.datatype.Datatype;
import org.xml.sax.Locator;

public class SchemaPatternBuilder
extends PatternBuilder {
    private boolean idTypes;
    private final UnexpandedNotAllowedPattern unexpandedNotAllowed = new UnexpandedNotAllowedPattern();
    private final TextPattern text = new TextPattern();
    private final PatternInterner schemaInterner = new PatternInterner();

    public boolean hasIdTypes() {
        return this.idTypes;
    }

    Pattern makeElement(NameClass nameClass, Pattern content, Locator loc) {
        ElementPattern p = new ElementPattern(nameClass, content, loc);
        return this.schemaInterner.intern(p);
    }

    Pattern makeAttribute(NameClass nameClass, Pattern value, Locator loc) {
        return this.makeAttribute(nameClass, value, loc, null);
    }

    Pattern makeAttribute(NameClass nameClass, Pattern value, Locator loc, String defaultValue) {
        if (value == this.notAllowed) {
            return value;
        }
        AttributePattern p = new AttributePattern(nameClass, value, loc, defaultValue);
        return this.schemaInterner.intern(p);
    }

    Pattern makeData(Datatype dt, Name dtName, List<String> params) {
        this.noteDatatype(dt);
        DataPattern p = new DataPattern(dt, dtName, params);
        return this.schemaInterner.intern(p);
    }

    Pattern makeDataExcept(Datatype dt, Name dtName, List<String> params, Pattern except, Locator loc) {
        this.noteDatatype(dt);
        DataExceptPattern p = new DataExceptPattern(dt, dtName, params, except, loc);
        return this.schemaInterner.intern(p);
    }

    Pattern makeValue(Datatype dt, Name dtName, Object value, String stringValue) {
        this.noteDatatype(dt);
        ValuePattern p = new ValuePattern(dt, dtName, value, stringValue);
        return this.schemaInterner.intern(p);
    }

    Pattern makeText() {
        return this.text;
    }

    @Override
    public Pattern makeOneOrMore(Pattern p) {
        if (p == this.text) {
            return p;
        }
        return super.makeOneOrMore(p);
    }

    Pattern makeUnexpandedNotAllowed() {
        return this.unexpandedNotAllowed;
    }

    Pattern makeError() {
        ErrorPattern p = new ErrorPattern();
        return this.schemaInterner.intern(p);
    }

    @Override
    public Pattern makeChoice(Pattern p1, Pattern p2) {
        if (p1 == this.notAllowed || p1 == p2) {
            return p2;
        }
        if (p2 == this.notAllowed) {
            return p1;
        }
        return super.makeChoice(p1, p2);
    }

    Pattern makeList(Pattern p, Locator loc) {
        if (p == this.notAllowed) {
            return p;
        }
        ListPattern p1 = new ListPattern(p, loc);
        return this.schemaInterner.intern(p1);
    }

    Pattern makeMixed(Pattern p) {
        return this.makeInterleave(this.text, p);
    }

    private void noteDatatype(Datatype dt) {
        if (dt.getIdType() != 0) {
            this.idTypes = true;
        }
    }
}

