/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.pattern;

import com.thaiopensource.relaxng.pattern.Pattern;
import com.thaiopensource.relaxng.pattern.PatternFunction;
import com.thaiopensource.relaxng.pattern.SchemaBuilderImpl;
import com.thaiopensource.relaxng.pattern.SchemaPatternBuilder;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class RefPattern
extends Pattern {
    private Pattern p;
    private Locator refLoc;
    private final String name;
    private int checkRecursionDepth = -1;
    private boolean combineImplicit = false;
    private byte combineType = 0;
    private byte replacementStatus = 0;
    private boolean expanded = false;
    static final byte REPLACEMENT_KEEP = 0;
    static final byte REPLACEMENT_REQUIRE = 1;
    static final byte REPLACEMENT_IGNORE = 2;
    static final byte COMBINE_NONE = 0;
    static final byte COMBINE_CHOICE = 1;
    static final byte COMBINE_INTERLEAVE = 2;

    RefPattern(String name) {
        this.name = name;
    }

    public Pattern getPattern() {
        return this.p;
    }

    void setPattern(Pattern p) {
        this.p = p;
    }

    Locator getRefLocator() {
        return this.refLoc;
    }

    void setRefLocator(Locator loc) {
        this.refLoc = loc;
    }

    @Override
    void checkRecursion(int depth) throws SAXException {
        if (this.checkRecursionDepth == -1) {
            this.checkRecursionDepth = depth;
            this.p.checkRecursion(depth);
            this.checkRecursionDepth = -2;
        } else if (depth == this.checkRecursionDepth) {
            throw new SAXParseException(SchemaBuilderImpl.localizer.message("recursive_reference", this.name), this.refLoc);
        }
    }

    @Override
    Pattern expand(SchemaPatternBuilder b) {
        if (!this.expanded) {
            this.p = this.p.expand(b);
            this.expanded = true;
        }
        return this.p;
    }

    @Override
    boolean samePattern(Pattern other) {
        return false;
    }

    @Override
    public <T> T apply(PatternFunction<T> f) {
        return f.caseRef(this);
    }

    byte getReplacementStatus() {
        return this.replacementStatus;
    }

    void setReplacementStatus(byte replacementStatus) {
        this.replacementStatus = replacementStatus;
    }

    boolean isCombineImplicit() {
        return this.combineImplicit;
    }

    void setCombineImplicit() {
        this.combineImplicit = true;
    }

    byte getCombineType() {
        return this.combineType;
    }

    void setCombineType(byte combineType) {
        this.combineType = combineType;
    }

    String getName() {
        return this.name;
    }
}

