/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.pattern;

import com.thaiopensource.datatype.Datatype2;
import com.thaiopensource.relaxng.match.MatchContext;
import com.thaiopensource.relaxng.match.Matcher;
import com.thaiopensource.relaxng.match.NameClass;
import com.thaiopensource.relaxng.pattern.DataDerivFailure;
import com.thaiopensource.relaxng.pattern.DataDerivFunction;
import com.thaiopensource.relaxng.pattern.FindElementFunction;
import com.thaiopensource.relaxng.pattern.NormalizedNameClass;
import com.thaiopensource.relaxng.pattern.Pattern;
import com.thaiopensource.relaxng.pattern.PatternMemo;
import com.thaiopensource.relaxng.pattern.SchemaBuilderImpl;
import com.thaiopensource.relaxng.pattern.ValidatorPatternBuilder;
import com.thaiopensource.util.Equal;
import com.thaiopensource.util.Localizer;
import com.thaiopensource.xml.util.Name;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.relaxng.datatype.Datatype;

public class PatternMatcher
implements Cloneable,
Matcher {
    private PatternMemo memo;
    private boolean textTyped;
    private boolean hadError;
    private boolean ignoreNextEndTagOrAttributeValue;
    private String errorMessage;
    private final Shared shared;
    private List<DataDerivFailure> dataDerivFailureList = new ArrayList<DataDerivFailure>();
    private String errorKey;
    private String[] errorArgs;
    private static final int UNDEFINED_TOKEN_INDEX = -3;
    private static final int INCONSISTENT_TOKEN_INDEX = -2;
    static final String[] GENERATED_PREFIXES = new String[]{"ns", "ns-", "ns_", "NS", "NS-", "NS_"};
    private static final int FORMAT_NAMES_ELEMENT = 0;
    private static final int FORMAT_NAMES_ATTRIBUTE = 1;
    private static final int FORMAT_NAMES_AND = 0;
    private static final int FORMAT_NAMES_OR = 2;

    public PatternMatcher(Pattern start, ValidatorPatternBuilder builder) {
        this.shared = new Shared(start, builder);
        this.memo = builder.getPatternMemo(start);
    }

    private PatternMatcher(PatternMemo memo, Shared shared) {
        this.memo = memo;
        this.shared = shared;
    }

    @Override
    public Matcher start() {
        return new PatternMatcher(this.shared.builder.getPatternMemo(this.shared.start), this.shared);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof PatternMatcher)) {
            return false;
        }
        PatternMatcher other = (PatternMatcher)obj;
        return this.memo == other.memo && this.hadError == other.hadError && Equal.equal(this.errorMessage, other.errorMessage) && this.ignoreNextEndTagOrAttributeValue == other.ignoreNextEndTagOrAttributeValue && this.textTyped == other.textTyped;
    }

    @Override
    public int hashCode() {
        return this.memo.hashCode();
    }

    public final Object clone() {
        try {
            PatternMatcher cloned = (PatternMatcher)super.clone();
            cloned.dataDerivFailureList = new ArrayList<DataDerivFailure>();
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new Error("unexpected CloneNotSupportedException");
        }
    }

    @Override
    public Matcher copy() {
        return (Matcher)this.clone();
    }

    @Override
    public boolean matchStartDocument() {
        if (this.memo.isNotAllowed()) {
            return this.error("schema_allows_nothing");
        }
        return true;
    }

    @Override
    public boolean matchEndDocument() {
        return true;
    }

    @Override
    public boolean matchStartTagOpen(Name name, String qName, MatchContext context) {
        if (this.setMemo(this.memo.startTagOpenDeriv(name))) {
            return true;
        }
        PatternMemo next = this.memo.startTagOpenRecoverDeriv(name);
        boolean ok = this.ignoreError();
        if (!next.isNotAllowed()) {
            if (!ok) {
                Set<Name> missing = this.requiredElementNames();
                if (!missing.isEmpty()) {
                    this.error(missing.size() == 1 ? "unexpected_element_required_element_missing" : "unexpected_element_required_elements_missing", this.errorArgQName(qName, name, context, false), PatternMatcher.formatNames(missing, 0, context));
                } else {
                    this.error("element_not_allowed_yet", this.errorArgQName(qName, name, context, false), this.expectedContent(context));
                }
            }
        } else {
            ValidatorPatternBuilder builder = this.shared.builder;
            next = builder.getPatternMemo(builder.makeAfter(this.shared.findElement(name), this.memo.getPattern()));
            if (!ok) {
                this.error(next.isNotAllowed() ? "unknown_element" : "out_of_context_element", this.errorArgQName(qName, name, context, false), this.expectedContent(context));
            }
        }
        this.memo = next;
        return ok;
    }

    @Override
    public boolean matchAttributeName(Name name, String qName, MatchContext context) {
        if (this.setMemo(this.memo.startAttributeDeriv(name))) {
            return true;
        }
        this.ignoreNextEndTagOrAttributeValue = true;
        boolean ok = this.ignoreError();
        if (ok) {
            return true;
        }
        qName = this.errorArgQName(qName, name, context, true);
        NormalizedNameClass nnc = this.memo.possibleAttributeNames();
        if (nnc.isEmpty()) {
            this.error("no_attributes_allowed", qName);
        } else {
            this.error("invalid_attribute_name", qName, this.expectedAttributes(context));
        }
        return false;
    }

    @Override
    public boolean matchAttributeValue(String value, Name name, String qName, MatchContext context) {
        if (this.ignoreNextEndTagOrAttributeValue) {
            this.ignoreNextEndTagOrAttributeValue = false;
            return true;
        }
        this.dataDerivFailureList.clear();
        if (this.setMemo(this.memo.dataDeriv(value, context, this.dataDerivFailureList))) {
            return true;
        }
        boolean ok = this.error("invalid_attribute_value", this.errorArgQName(qName, name, context, true), this.formatDataDerivFailures(value, context));
        this.memo = this.memo.recoverAfter();
        return ok;
    }

    @Override
    public boolean matchStartTagClose(Name name, String qName, MatchContext context) {
        boolean ok;
        if (this.setMemo(this.memo.endAttributes())) {
            ok = true;
        } else {
            ok = this.ignoreError();
            if (!ok) {
                Set<Name> missing = this.requiredAttributeNames();
                if (missing.isEmpty()) {
                    this.error("required_attributes_missing_expected", this.errorArgQName(qName, name, context, false), this.expectedAttributes(context));
                } else {
                    this.error(missing.size() == 1 ? "required_attribute_missing" : "required_attributes_missing", this.errorArgQName(qName, name, context, false), PatternMatcher.formatNames(missing, 1, context));
                }
            }
            this.memo = this.memo.ignoreMissingAttributes();
        }
        this.textTyped = this.memo.getPattern().getContentType() == 3;
        return ok;
    }

    @Override
    public boolean matchTextBeforeEndTag(String string, Name name, String qName, MatchContext context) {
        if (this.textTyped) {
            this.ignoreNextEndTagOrAttributeValue = true;
            return this.setDataDeriv(string, name, qName, context);
        }
        return this.matchUntypedText(string, context);
    }

    @Override
    public boolean matchTextBeforeStartTag(String string, MatchContext context) {
        return this.matchUntypedText(string, context);
    }

    private boolean matchUntypedText(String string, MatchContext context) {
        if (DataDerivFunction.isBlank(string)) {
            return true;
        }
        return this.matchUntypedText(context);
    }

    @Override
    public boolean matchUntypedText(MatchContext context) {
        if (this.setMemo(this.memo.mixedTextDeriv())) {
            return true;
        }
        return this.error("text_not_allowed", this.expectedContent(context));
    }

    @Override
    public boolean isTextTyped() {
        return this.textTyped;
    }

    private boolean setDataDeriv(String string, Name name, String qName, MatchContext context) {
        this.textTyped = false;
        PatternMemo textOnlyMemo = this.memo.textOnly();
        this.dataDerivFailureList.clear();
        if (this.setMemo(textOnlyMemo.dataDeriv(string, context, this.dataDerivFailureList))) {
            return true;
        }
        PatternMemo next = this.memo.recoverAfter();
        boolean ok = this.ignoreError();
        if (!(ok || next.isNotAllowed() && !textOnlyMemo.emptyAfter().dataDeriv(string, context).isNotAllowed())) {
            NormalizedNameClass nnc = this.memo.possibleStartTagNames();
            if (!nnc.isEmpty() && DataDerivFunction.isBlank(string)) {
                this.error("blank_not_allowed", this.errorArgQName(qName, name, context, false), this.expectedContent(context));
            } else {
                this.error("invalid_element_value", this.errorArgQName(qName, name, context, false), this.formatDataDerivFailures(string, context));
            }
        }
        this.memo = next;
        return ok;
    }

    @Override
    public boolean matchEndTag(Name name, String qName, MatchContext context) {
        if (this.ignoreNextEndTagOrAttributeValue) {
            this.ignoreNextEndTagOrAttributeValue = false;
            return true;
        }
        if (this.textTyped) {
            return this.setDataDeriv("", name, qName, context);
        }
        if (this.setMemo(this.memo.endTagDeriv())) {
            return true;
        }
        boolean ok = this.ignoreError();
        PatternMemo next = this.memo.recoverAfter();
        if (!(ok || next.isNotAllowed() && !this.memo.emptyAfter().endTagDeriv().isNotAllowed())) {
            Set<Name> missing = this.requiredElementNames();
            if (!missing.isEmpty()) {
                this.error(missing.size() == 1 ? "incomplete_element_required_element_missing" : "incomplete_element_required_elements_missing", this.errorArgQName(qName, name, context, false), PatternMatcher.formatNames(missing, 0, context));
            } else {
                this.error("incomplete_element_required_elements_missing_expected", this.errorArgQName(qName, name, context, false), this.expectedContent(context));
            }
        }
        this.memo = next;
        return ok;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getErrorKey() {
        return this.errorKey;
    }

    public String[] getErrorArgs() {
        return this.errorArgs;
    }

    @Override
    public boolean isValidSoFar() {
        return !this.hadError;
    }

    @Override
    public NameClass possibleStartTagNames() {
        return this.memo.possibleStartTagNames();
    }

    @Override
    public NameClass possibleAttributeNames() {
        return this.memo.possibleAttributeNames();
    }

    @Override
    public Set<Name> requiredElementNames() {
        return this.memo.getPattern().apply(this.shared.builder.getRequiredElementsFunction());
    }

    @Override
    public Set<Name> requiredAttributeNames() {
        return this.memo.getPattern().apply(this.shared.builder.getRequiredAttributesFunction());
    }

    private boolean setMemo(PatternMemo m) {
        if (m.isNotAllowed()) {
            return false;
        }
        this.memo = m;
        return true;
    }

    private boolean ignoreError() {
        return this.hadError && this.memo.isNotAllowed();
    }

    private boolean error(String key) {
        return this.error(key, new String[0]);
    }

    private boolean error(String key, String arg) {
        return this.error(key, new String[]{arg});
    }

    private boolean error(String key, String arg1, String arg2) {
        return this.error(key, new String[]{arg1, arg2});
    }

    private boolean error(String key, String arg1, String arg2, String arg3) {
        return this.error(key, new String[]{arg1, arg2, arg3});
    }

    private boolean error(String key, String[] args) {
        if (this.ignoreError()) {
            return true;
        }
        this.hadError = true;
        this.errorMessage = PatternMatcher.localizer().message(key, args);
        this.errorKey = key;
        this.errorArgs = args;
        return false;
    }

    private String errorArgQName(String qName, Name name, MatchContext context, boolean isAttribute) {
        if (this.ignoreError()) {
            return null;
        }
        if (qName == null || ((String)qName).length() == 0) {
            String prefix;
            String ns = name.getNamespaceUri();
            String localName = name.getLocalName();
            qName = ns.length() == 0 || !isAttribute && ns.equals(context.resolveNamespacePrefix("")) ? localName : ((prefix = context.getPrefix(ns)) != null ? prefix + ":" + localName : "{" + ns + "}" + localName);
        }
        return PatternMatcher.quoteQName((String)qName);
    }

    private String formatDataDerivFailures(String str, MatchContext context) {
        if (this.ignoreError()) {
            return null;
        }
        if (this.dataDerivFailureList.size() == 0) {
            return "";
        }
        if (this.dataDerivFailureList.size() > 1) {
            HashSet<DataDerivFailure> failures = new HashSet<DataDerivFailure>();
            failures.addAll(this.dataDerivFailureList);
            this.dataDerivFailureList.clear();
            this.dataDerivFailureList.addAll(failures);
        }
        ArrayList<String> stringValues = new ArrayList<String>();
        HashSet<Name> names = new HashSet<Name>();
        ArrayList<String> messages = new ArrayList<String>();
        int tokenIndex = -3;
        int tokenStart = -1;
        int tokenEnd = -1;
        block4: for (DataDerivFailure fail : this.dataDerivFailureList) {
            Datatype dt = fail.getDatatype();
            String s = fail.getStringValue();
            if (s != null) {
                Object value = fail.getValue();
                if (value instanceof Name && dt instanceof Datatype2) {
                    names.add((Name)value);
                } else if (value instanceof String && dt instanceof Datatype2) {
                    stringValues.add((String)value);
                } else {
                    stringValues.add(s);
                }
            } else {
                String message = fail.getMessage();
                if (message != null) {
                    messages.add(message);
                } else {
                    if (fail.getExcept() != null) {
                        return "";
                    }
                    messages.add(PatternMatcher.localizer().message("require_datatype", fail.getDatatypeName().getLocalName()));
                }
            }
            switch (tokenIndex) {
                case -2: {
                    continue block4;
                }
                case -3: {
                    tokenIndex = fail.getTokenIndex();
                    tokenStart = fail.getTokenStart();
                    tokenEnd = fail.getTokenEnd();
                    continue block4;
                }
            }
            if (tokenIndex == fail.getTokenIndex()) continue;
            tokenIndex = -2;
        }
        if (stringValues.size() > 0) {
            Collections.sort(stringValues);
            for (int i = 0; i < stringValues.size(); ++i) {
                stringValues.set(i, this.quoteValue((String)stringValues.get(i)));
            }
            messages.add(PatternMatcher.localizer().message("require_values", PatternMatcher.formatList(stringValues, "or")));
        }
        if (names.size() > 0) {
            messages.add(PatternMatcher.localizer().message("require_qnames", PatternMatcher.formatNames(names, 2, context)));
        }
        if (messages.size() == 0) {
            return "";
        }
        String arg = PatternMatcher.formatList(messages, "or");
        if (tokenIndex >= 0 && tokenStart >= 0 && tokenEnd <= str.length()) {
            if (tokenStart == str.length()) {
                return PatternMatcher.localizer().message("missing_token", arg);
            }
            return PatternMatcher.localizer().message("token_failures", this.quoteValue(str.substring(tokenStart, tokenEnd)), arg);
        }
        return PatternMatcher.localizer().message("data_failures", arg);
    }

    private String quoteValue(String str) {
        StringBuilder buf = new StringBuilder();
        PatternMatcher.appendAttributeValue(buf, str);
        return buf.toString();
    }

    private String expectedAttributes(MatchContext context) {
        if (this.ignoreError()) {
            return null;
        }
        NormalizedNameClass nnc = this.memo.possibleAttributeNames();
        if (nnc.isEmpty()) {
            return "";
        }
        Set<Name> expectedNames = nnc.getIncludedNames();
        if (!expectedNames.isEmpty()) {
            return PatternMatcher.localizer().message(nnc.isAnyNameIncluded() || !nnc.getIncludedNamespaces().isEmpty() ? "expected_attribute_or_other_ns" : "expected_attribute", PatternMatcher.formatNames(expectedNames, 3, context));
        }
        return "";
    }

    private String expectedContent(MatchContext context) {
        if (this.ignoreError()) {
            return null;
        }
        ArrayList<String> expected = new ArrayList<String>();
        if (!this.memo.endTagDeriv().isNotAllowed()) {
            expected.add(PatternMatcher.localizer().message("element_end_tag"));
        }
        switch (this.memo.emptyAfter().getPattern().getContentType()) {
            case 2: {
                if (this.memo.mixedTextDeriv().isNotAllowed()) break;
                expected.add(PatternMatcher.localizer().message("text"));
                break;
            }
            case 3: {
                expected.add(PatternMatcher.localizer().message("data"));
            }
        }
        NormalizedNameClass nnc = this.memo.possibleStartTagNames();
        Set<Name> expectedNames = nnc.getIncludedNames();
        if (!expectedNames.isEmpty()) {
            expected.add(PatternMatcher.localizer().message("element_list", PatternMatcher.formatNames(expectedNames, 2, context)));
            if (nnc.isAnyNameIncluded() || !nnc.getIncludedNamespaces().isEmpty()) {
                expected.add(PatternMatcher.localizer().message("element_other_ns"));
            }
        }
        if (expected.isEmpty()) {
            return "";
        }
        return PatternMatcher.localizer().message("expected", PatternMatcher.formatList(expected, "or"));
    }

    private static String formatNames(Set<Name> names, int flags, MatchContext context) {
        if (names.isEmpty()) {
            return "";
        }
        HashMap<String, String> nsDecls = new HashMap<String, String>();
        List<String> qNames = PatternMatcher.generateQNames(names, flags, context, nsDecls);
        Collections.sort(qNames);
        int len = qNames.size();
        for (int i = 0; i < len; ++i) {
            qNames.set(i, PatternMatcher.quoteQName(qNames.get(i)));
        }
        String result = PatternMatcher.formatList(qNames, (flags & 2) != 0 ? "or" : "and");
        if (nsDecls.size() != 0) {
            result = PatternMatcher.localizer().message("qnames_nsdecls", result, PatternMatcher.formatNamespaceDecls(nsDecls));
        }
        return result;
    }

    private static List<String> generateQNames(Set<Name> names, int flags, MatchContext context, Map<String, String> nsDecls) {
        String defaultNamespace;
        if ((flags & 1) != 0) {
            defaultNamespace = "";
        } else {
            defaultNamespace = context.resolveNamespacePrefix("");
            for (Name name : names) {
                if (name.getNamespaceUri().length() != 0) continue;
                if (defaultNamespace != null) {
                    nsDecls.put("", "");
                }
                defaultNamespace = "";
                break;
            }
        }
        ArrayList<String> qNames = new ArrayList<String>();
        HashSet<String> undeclaredNamespaces = new HashSet<String>();
        ArrayList<Name> namesWithUndeclaredNamespaces = new ArrayList<Name>();
        for (Name name : names) {
            String prefix;
            String ns = name.getNamespaceUri();
            if (ns.equals(defaultNamespace)) {
                prefix = "";
            } else {
                prefix = context.getPrefix(ns);
                if ((flags & 1) != 0 && "".equals(prefix) && !"".equals(ns)) {
                    prefix = null;
                }
            }
            if (prefix == null) {
                undeclaredNamespaces.add(ns);
                namesWithUndeclaredNamespaces.add(name);
                continue;
            }
            qNames.add(PatternMatcher.makeQName(prefix, name.getLocalName()));
        }
        if (namesWithUndeclaredNamespaces.isEmpty()) {
            return qNames;
        }
        if (undeclaredNamespaces.size() == 1 && defaultNamespace == null) {
            nsDecls.put((String)undeclaredNamespaces.iterator().next(), "");
        } else {
            PatternMatcher.choosePrefixes(undeclaredNamespaces, context, nsDecls);
        }
        for (Name name : namesWithUndeclaredNamespaces) {
            qNames.add(PatternMatcher.makeQName(nsDecls.get(name.getNamespaceUri()), name.getLocalName()));
        }
        return qNames;
    }

    private static void choosePrefixes(Set<String> nsSet, MatchContext context, Map<String, String> nsDecls) {
        int i;
        Object prefix;
        ArrayList<String> nsList = new ArrayList<String>(nsSet);
        Collections.sort(nsList);
        int len = nsList.size();
        int tryIndex = 0;
        do {
            if (tryIndex < GENERATED_PREFIXES.length) {
                prefix = GENERATED_PREFIXES[tryIndex];
            } else {
                prefix = "_" + GENERATED_PREFIXES[0];
                for (i = GENERATED_PREFIXES.length; i < tryIndex; ++i) {
                    prefix = (String)prefix + "_" + (String)prefix;
                }
            }
            for (i = 0; i < len; ++i) {
                if (context.resolveNamespacePrefix((String)(len == 1 ? prefix : (String)prefix + (i + 1))) == null) continue;
                prefix = null;
                break;
            }
            ++tryIndex;
        } while (prefix == null);
        for (i = 0; i < len; ++i) {
            String ns = (String)nsList.get(i);
            nsDecls.put(ns, (String)(len == 1 ? prefix : (String)prefix + (i + 1)));
        }
    }

    private static String formatList(List<String> list, String conjunction) {
        int len = list.size();
        switch (len) {
            case 0: {
                return "";
            }
            case 1: {
                return list.get(0);
            }
            case 2: {
                return PatternMatcher.localizer().message(conjunction + "_list_pair", list.get(0), list.get(1));
            }
        }
        String s = PatternMatcher.localizer().message(conjunction + "_list_many_first", list.get(0));
        for (int i = 1; i < len - 1; ++i) {
            s = PatternMatcher.localizer().message(conjunction + "_list_many_middle", s, list.get(i));
        }
        return PatternMatcher.localizer().message(conjunction + "_list_many_last", s, list.get(len - 1));
    }

    private static String formatNamespaceDecls(Map<String, String> nsDecls) {
        ArrayList<String> list = new ArrayList<String>();
        for (Map.Entry<String, String> entry : nsDecls.entrySet()) {
            StringBuilder buf = new StringBuilder();
            String prefix = entry.getValue();
            if (prefix.length() == 0) {
                buf.append("xmlns");
            } else {
                buf.append("xmlns:").append(prefix);
            }
            buf.append('=');
            PatternMatcher.appendAttributeValue(buf, entry.getKey());
            list.add(buf.toString());
        }
        Collections.sort(list);
        StringBuilder buf = new StringBuilder();
        for (String aList : list) {
            if (buf.length() != 0) {
                buf.append(" ");
            }
            buf.append(aList);
        }
        return buf.toString();
    }

    private static String quoteForAttributeValue(char c) {
        switch (c) {
            case '<': {
                return "&lt;";
            }
            case '\"': {
                return "&quot;";
            }
            case '&': {
                return "&amp;";
            }
            case '\n': {
                return "&#xA;";
            }
            case '\r': {
                return "&#xD;";
            }
            case '\t': {
                return "&#x9;";
            }
        }
        return null;
    }

    private static StringBuilder appendAttributeValue(StringBuilder buf, String value) {
        buf.append('\"');
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            String quoted = PatternMatcher.quoteForAttributeValue(c);
            if (quoted != null) {
                buf.append(quoted);
                continue;
            }
            buf.append(c);
        }
        buf.append('\"');
        return buf;
    }

    private static String makeQName(String prefix, String localName) {
        if (prefix.length() == 0) {
            return localName;
        }
        return prefix + ":" + localName;
    }

    private static String quoteQName(String qName) {
        return PatternMatcher.localizer().message("qname", qName);
    }

    private static Localizer localizer() {
        return SchemaBuilderImpl.localizer;
    }

    private static class Shared {
        private final Pattern start;
        private final ValidatorPatternBuilder builder;
        private Map<Name, Pattern> recoverPatternTable;

        Shared(Pattern start, ValidatorPatternBuilder builder) {
            this.start = start;
            this.builder = builder;
        }

        Pattern findElement(Name name) {
            Pattern p;
            if (this.recoverPatternTable == null) {
                this.recoverPatternTable = new HashMap<Name, Pattern>();
            }
            if ((p = this.recoverPatternTable.get(name)) == null) {
                p = FindElementFunction.findElement(this.builder, name, this.start);
                this.recoverPatternTable.put(name, p);
            }
            return p;
        }
    }
}

