/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.pattern;

import com.thaiopensource.relaxng.pattern.Alphabet;
import com.thaiopensource.relaxng.pattern.DuplicateAttributeDetector;
import com.thaiopensource.relaxng.pattern.NameClass;
import com.thaiopensource.relaxng.pattern.NullNameClass;
import com.thaiopensource.relaxng.pattern.Pattern;
import com.thaiopensource.relaxng.pattern.PatternFunction;
import com.thaiopensource.relaxng.pattern.RestrictionViolationException;
import com.thaiopensource.relaxng.pattern.SchemaPatternBuilder;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class ElementPattern
extends Pattern {
    private Pattern p;
    private final NameClass origNameClass;
    private NameClass nameClass;
    private boolean expanded = false;
    private boolean checkedRestrictions = false;
    private final Locator loc;

    ElementPattern(NameClass nameClass, Pattern p, Locator loc) {
        super(false, 1, ElementPattern.combineHashCode(23, nameClass.hashCode(), p.hashCode()));
        this.nameClass = nameClass;
        this.origNameClass = nameClass;
        this.p = p;
        this.loc = loc;
    }

    @Override
    void checkRestrictions(int context, DuplicateAttributeDetector dad, Alphabet alpha) throws RestrictionViolationException {
        if (alpha != null) {
            alpha.addElement(this.origNameClass);
        }
        if (this.checkedRestrictions) {
            return;
        }
        switch (context) {
            case 7: {
                throw new RestrictionViolationException("data_except_contains_element");
            }
            case 6: {
                throw new RestrictionViolationException("list_contains_element");
            }
            case 5: {
                throw new RestrictionViolationException("attribute_contains_element");
            }
        }
        this.checkedRestrictions = true;
        try {
            this.p.checkRestrictions(1, new DuplicateAttributeDetector(), null);
        }
        catch (RestrictionViolationException e) {
            this.checkedRestrictions = false;
            e.maybeSetLocator(this.loc);
            throw e;
        }
    }

    @Override
    Pattern expand(SchemaPatternBuilder b) {
        if (!this.expanded) {
            this.expanded = true;
            this.p = this.p.expand(b);
            if (this.p.isNotAllowed()) {
                this.nameClass = new NullNameClass();
            }
        }
        return this;
    }

    @Override
    boolean samePattern(Pattern other) {
        if (!(other instanceof ElementPattern)) {
            return false;
        }
        ElementPattern ep = (ElementPattern)other;
        return this.nameClass.equals(ep.nameClass) && this.p == ep.p;
    }

    @Override
    void checkRecursion(int depth) throws SAXException {
        this.p.checkRecursion(depth + 1);
    }

    @Override
    public <T> T apply(PatternFunction<T> f) {
        return f.caseElement(this);
    }

    void setContent(Pattern p) {
        this.p = p;
    }

    public Pattern getContent() {
        return this.p;
    }

    public NameClass getNameClass() {
        return this.nameClass;
    }

    public Locator getLocator() {
        return this.loc;
    }
}

