/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.pattern;

import com.thaiopensource.relaxng.pattern.Alphabet;
import com.thaiopensource.relaxng.pattern.DuplicateAttributeDetector;
import com.thaiopensource.relaxng.pattern.Pattern;
import com.thaiopensource.relaxng.pattern.RestrictionViolationException;
import org.xml.sax.SAXException;

public abstract class BinaryPattern
extends Pattern {
    public final Pattern p1;
    public final Pattern p2;

    BinaryPattern(boolean nullable, int hc, Pattern p1, Pattern p2) {
        super(nullable, Math.max(p1.getContentType(), p2.getContentType()), hc);
        this.p1 = p1;
        this.p2 = p2;
    }

    @Override
    void checkRecursion(int depth) throws SAXException {
        this.p1.checkRecursion(depth);
        this.p2.checkRecursion(depth);
    }

    @Override
    void checkRestrictions(int context, DuplicateAttributeDetector dad, Alphabet alpha) throws RestrictionViolationException {
        this.p1.checkRestrictions(context, dad, alpha);
        this.p2.checkRestrictions(context, dad, alpha);
    }

    @Override
    boolean samePattern(Pattern other) {
        if (this.getClass() != other.getClass()) {
            return false;
        }
        BinaryPattern b = (BinaryPattern)other;
        return this.p1 == b.p1 && this.p2 == b.p2;
    }

    public Pattern getOperand1() {
        return this.p1;
    }

    public Pattern getOperand2() {
        return this.p2;
    }
}

