/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.elements.support.text;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.jeuclid.LayoutContext;
import net.sourceforge.jeuclid.context.Parameter;
import net.sourceforge.jeuclid.elements.AbstractJEuclidElement;
import net.sourceforge.jeuclid.elements.JEuclidElement;
import net.sourceforge.jeuclid.elements.support.GraphicsSupport;
import net.sourceforge.jeuclid.elements.support.attributes.MathVariant;
import net.sourceforge.jeuclid.elements.support.text.CharConverter;
import net.sourceforge.jeuclid.elements.support.text.CharacterMapping;
import net.sourceforge.jeuclid.elements.support.text.CodePointAndVariant;
import net.sourceforge.jeuclid.elements.support.text.MultiAttributedCharacterIterator;
import net.sourceforge.jeuclid.elements.support.text.TextContent;
import net.sourceforge.jeuclid.elements.support.text.TextContentModifier;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class StringUtil {
    public static final boolean OSX = System.getProperty("mrj.version") != null;
    static final CharacterMapping CMAP = CharacterMapping.getInstance();

    private StringUtil() {
    }

    public static AttributedString convertStringtoAttributedString(String inputString, MathVariant baseVariant, float fontSize, LayoutContext context) {
        Font font;
        if (inputString == null) {
            return new AttributedString("");
        }
        StringBuilder builder = new StringBuilder();
        ArrayList<Font> fonts = new ArrayList<Font>();
        String plainString = CharConverter.convertLate((String)inputString);
        for (int i = 0; i < plainString.length(); ++i) {
            if (Character.isLowSurrogate(plainString.charAt(i))) continue;
            CodePointAndVariant cpav1 = new CodePointAndVariant(plainString.codePointAt(i), baseVariant);
            Object[] codeAndFont = StringUtil.mapCpavToCpaf(cpav1, fontSize, context);
            int codePoint = (Integer)codeAndFont[0];
            font = (Font)codeAndFont[1];
            builder.appendCodePoint(codePoint);
            fonts.add(font);
            if (!Character.isSupplementaryCodePoint(codePoint)) continue;
            fonts.add(font);
        }
        AttributedString aString = new AttributedString(builder.toString());
        int len = builder.length();
        for (int i = 0; i < len; ++i) {
            char currentChar = builder.charAt(i);
            if (Character.isLowSurrogate(currentChar)) continue;
            font = (Font)fonts.get(i);
            int count = Character.isHighSurrogate(currentChar) ? 2 : 1;
            aString.addAttribute(TextAttribute.FONT, font, i, i + count);
        }
        return aString;
    }

    public static AttributedCharacterIterator textContentAsAttributedCharacterIterator(LayoutContext contextNow, JEuclidElement contextElement, Node node, float corrector) {
        AttributedCharacterIterator retVal;
        if (node instanceof Element) {
            MultiAttributedCharacterIterator maci = new MultiAttributedCharacterIterator();
            NodeList children = node.getChildNodes();
            Object aci = null;
            int childCount = children.getLength();
            for (int i = 0; i < childCount; ++i) {
                JEuclidElement subContextElement;
                LayoutContext subContext;
                Node child = children.item(i);
                if (child instanceof AbstractJEuclidElement) {
                    subContext = ((AbstractJEuclidElement)child).applyLocalAttributesToContext(contextNow);
                    subContextElement = (JEuclidElement)child;
                } else {
                    subContext = contextNow;
                    subContextElement = contextElement;
                }
                aci = StringUtil.textContentAsAttributedCharacterIterator(subContext, subContextElement, child, corrector);
                maci.appendAttributedCharacterIterator((AttributedCharacterIterator)aci);
            }
            if (childCount != 1) {
                aci = maci;
            }
            if (node instanceof TextContentModifier) {
                TextContentModifier t = (TextContentModifier)node;
                retVal = t.modifyTextContent((AttributedCharacterIterator)aci, contextNow);
            } else {
                retVal = aci;
            }
        } else {
            String theText = TextContent.getText((Node)node);
            float fontSizeInPoint = GraphicsSupport.getFontsizeInPoint((LayoutContext)contextNow) * corrector;
            retVal = StringUtil.convertStringtoAttributedString(theText, contextElement.getMathvariantAsVariant(), fontSizeInPoint, contextNow).getIterator();
        }
        return retVal;
    }

    private static Object[] mapCpavToCpaf(CodePointAndVariant cpav1, float fontSize, LayoutContext context) {
        List alternatives = CMAP.getAllAlternatives(cpav1);
        Font font = null;
        int codePoint = 0;
        StringUtil.sortAlternatives(cpav1, alternatives);
        Iterator it = alternatives.iterator();
        boolean cont = true;
        while (cont) {
            CodePointAndVariant cpav = (CodePointAndVariant)it.next();
            if (it.hasNext()) {
                codePoint = cpav.getCodePoint();
                font = cpav.getVariant().createFont(fontSize, codePoint, context, false);
                if (font == null) continue;
                cont = false;
                continue;
            }
            codePoint = cpav.getCodePoint();
            font = cpav.getVariant().createFont(fontSize, codePoint, context, true);
            cont = false;
        }
        return new Object[]{codePoint, font};
    }

    private static void sortAlternatives(final CodePointAndVariant cpav1, List<CodePointAndVariant> alternatives) {
        Collections.sort(alternatives, new Comparator<CodePointAndVariant>(){

            @Override
            public int compare(CodePointAndVariant o1, CodePointAndVariant o2) {
                int result = 0;
                int codePoint = cpav1.getCodePoint();
                if (o1.getCodePoint() == codePoint && o2.getCodePoint() != codePoint) {
                    result = -1;
                } else if (o1.getCodePoint() != codePoint && o2.getCodePoint() == codePoint) {
                    result = 1;
                }
                return result;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TextLayout createTextLayoutFromAttributedString(Graphics2D g, AttributedString aString, LayoutContext context) {
        Font font;
        AttributedCharacterIterator charIter = aString.getIterator();
        boolean empty = charIter.first() == '\uffff';
        FontRenderContext suggestedFontRenderContext = g.getFontRenderContext();
        boolean antialiasing = (Boolean)context.getParameter(Parameter.ANTIALIAS);
        if (!empty && (font = (Font)aString.getIterator().getAttribute(TextAttribute.FONT)) != null) {
            float minantialias;
            float fontsize = font.getSize2D();
            antialiasing &= fontsize >= (minantialias = ((Float)context.getParameter(Parameter.ANTIALIAS_MINSIZE)).floatValue());
        }
        FontRenderContext realFontRenderContext = new FontRenderContext(suggestedFontRenderContext.getTransform(), antialiasing, false);
        if (empty) {
            return new TextLayout(" ", new Font("", 0, 0), realFontRenderContext);
        }
        Class<TextLayout> clazz = TextLayout.class;
        synchronized (TextLayout.class) {
            return new TextLayout(aString.getIterator(), realFontRenderContext);
        }
    }

    public static float getWidthForTextLayout(TextLayout layout) {
        Rectangle2D r2d = layout.getBounds();
        float realWidth = (float)r2d.getWidth();
        float xo = (float)r2d.getX();
        if (xo > 0.0f) {
            realWidth += xo;
        }
        float invisibleAdvance = layout.getAdvance() - layout.getVisibleAdvance();
        return realWidth + invisibleAdvance;
    }

    public static TextLayoutInfo getTextLayoutInfo(TextLayout textLayout, boolean trim) {
        Rectangle2D textBounds = textLayout.getBounds();
        float ascent = (float)(-textBounds.getY());
        float descent = (float)(textBounds.getY() + textBounds.getHeight());
        float xo = (float)textBounds.getX();
        float xOffset = xo < 0.0f ? -xo : (trim ? -xo : 0.0f);
        float width = StringUtil.getWidthForTextLayout(textLayout);
        return new TextLayoutInfo(ascent, descent, xOffset, width);
    }

    public static class TextLayoutInfo {
        private final float ascent;
        private final float descent;
        private final float offset;
        private final float width;

        protected TextLayoutInfo(float newAscent, float newDescent, float newOffset, float newWidth) {
            this.ascent = newAscent;
            this.descent = newDescent;
            this.offset = newOffset;
            this.width = newWidth;
        }

        public float getAscent() {
            return this.ascent;
        }

        public float getDescent() {
            return this.descent;
        }

        public float getOffset() {
            return this.offset;
        }

        public float getWidth() {
            return this.width;
        }
    }
}

