/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.context;

import java.awt.Color;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import net.sourceforge.jeuclid.LayoutContext;
import net.sourceforge.jeuclid.MutableLayoutContext;
import net.sourceforge.jeuclid.context.Display;
import net.sourceforge.jeuclid.context.Parameter;

public class LayoutContextImpl
implements MutableLayoutContext,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<Parameter, Object> context;

    protected LayoutContextImpl() {
        this.context = new TreeMap<Parameter, Object>();
        this.context.put(Parameter.MATHSIZE, Float.valueOf(12.0f));
        this.context.put(Parameter.SCRIPTMINSIZE, Float.valueOf(8.0f));
        this.context.put(Parameter.ANTIALIAS_MINSIZE, Float.valueOf(10.0f));
        this.context.put(Parameter.SCRIPTSIZEMULTIPLIER, Float.valueOf(0.71f));
        this.context.put(Parameter.SCRIPTLEVEL, 0);
        this.context.put(Parameter.DISPLAY, Display.BLOCK);
        this.context.put(Parameter.DEBUG, false);
        this.context.put(Parameter.ANTIALIAS, true);
        this.context.put(Parameter.MATHCOLOR, Color.BLACK);
        this.context.put(Parameter.MATHBACKGROUND, null);
        ArrayList<String> fontsSanserif = new ArrayList<String>(12);
        fontsSanserif.add("Verdana");
        fontsSanserif.add("Helvetica");
        fontsSanserif.add("Arial");
        fontsSanserif.add("Arial Unicode MS");
        fontsSanserif.add("Lucida Sans Unicode");
        fontsSanserif.add("Lucida Sans");
        fontsSanserif.add("Lucida Grande");
        fontsSanserif.add("DejaVu Sans");
        fontsSanserif.add("DejaVuSans");
        fontsSanserif.add("Bitstream Vera Sans");
        fontsSanserif.add("Luxi Sans");
        fontsSanserif.add("FreeSans");
        fontsSanserif.add("sansserif");
        this.context.put(Parameter.FONTS_SANSSERIF, Collections.unmodifiableList(fontsSanserif));
        ArrayList<String> fontsSerif = new ArrayList<String>(10);
        fontsSerif.add("Constantina");
        fontsSerif.add("Cambria");
        fontsSerif.add("Times");
        fontsSerif.add("Times New Roman");
        fontsSerif.add("Lucida Bright");
        fontsSerif.add("DejaVu Serif");
        fontsSerif.add("DejaVuSerif");
        fontsSerif.add("Bitstream Vera Serif");
        fontsSerif.add("Luxi Serif");
        fontsSerif.add("FreeSerif");
        fontsSerif.add("serif");
        this.context.put(Parameter.FONTS_SERIF, Collections.unmodifiableList(fontsSerif));
        ArrayList<String> fontsMonospaced = new ArrayList<String>(10);
        fontsMonospaced.add("Andale Mono");
        fontsMonospaced.add("Courier");
        fontsMonospaced.add("Courier Mono");
        fontsMonospaced.add("Courier New");
        fontsMonospaced.add("Lucida Sans Typewriter");
        fontsMonospaced.add("DejaVu Sans Mono");
        fontsMonospaced.add("DejaVuSansMono");
        fontsMonospaced.add("Bitstream Vera Sans Mono");
        fontsMonospaced.add("Luxi Mono");
        fontsMonospaced.add("FreeMono");
        fontsMonospaced.add("monospaced");
        this.context.put(Parameter.FONTS_MONOSPACED, Collections.unmodifiableList(fontsMonospaced));
        ArrayList<String> fontsScript = new ArrayList<String>(12);
        fontsScript.add("EUSM10");
        fontsScript.add("cmsy10");
        fontsScript.add("Math5");
        fontsScript.add("Mathematica5");
        fontsScript.add("Savoye LET");
        fontsScript.add("Brush Script MT");
        fontsScript.add("Zapfino");
        fontsScript.add("Apple Chancery");
        fontsScript.add("Edwardian Script ITC");
        fontsScript.add("Lucida Handwriting");
        fontsScript.add("Monotype Corsiva");
        fontsScript.add("Santa Fe LET");
        this.context.put(Parameter.FONTS_SCRIPT, Collections.unmodifiableList(fontsScript));
        ArrayList<String> fontsFraktur = new ArrayList<String>(7);
        fontsFraktur.add("EUFM10");
        fontsFraktur.add("Mathematica6");
        fontsFraktur.add("FetteFraktur");
        fontsFraktur.add("Fette Fraktur");
        fontsFraktur.add("Euclid Fraktur");
        fontsFraktur.add("Lucida Blackletter");
        fontsFraktur.add("Blackmoor LET");
        this.context.put(Parameter.FONTS_FRAKTUR, Collections.unmodifiableList(fontsFraktur));
        ArrayList<String> fontsDoublestruck = new ArrayList<String>(8);
        fontsDoublestruck.add("MSBM10");
        fontsDoublestruck.add("Mathematica7");
        fontsDoublestruck.add("Caslon Open Face");
        fontsDoublestruck.add("Caslon Openface");
        fontsDoublestruck.add("Cloister Open Face");
        fontsDoublestruck.add("Academy Engraved LET");
        fontsDoublestruck.add("Colonna MT");
        fontsDoublestruck.add("Imprint MT Shadow");
        this.context.put(Parameter.FONTS_DOUBLESTRUCK, Collections.unmodifiableList(fontsDoublestruck));
        this.context.put(Parameter.MFRAC_KEEP_SCRIPTLEVEL, Boolean.FALSE);
    }

    public LayoutContextImpl(LayoutContext copyFromContext) {
        if (!(copyFromContext instanceof LayoutContextImpl)) {
            throw new UnsupportedOperationException("LayoutContextImpl(" + copyFromContext.getClass() + ") not supported.");
        }
        this.context = new TreeMap<Parameter, Object>(((LayoutContextImpl)copyFromContext).getParameters());
    }

    public static LayoutContext getDefaultLayoutContext() {
        return SingletonHolder.INSTANCE;
    }

    public LayoutContext setParameter(Parameter which, Object newValue) {
        if (which.valid(newValue)) {
            this.context.put(which, newValue);
        } else if (newValue != null) {
            this.context.put(which, which.fromString(newValue.toString()));
        }
        return this;
    }

    public Object getParameter(Parameter which) {
        return this.context.get(which);
    }

    private Map<Parameter, Object> getParameters() {
        return Collections.unmodifiableMap(this.context);
    }

    private static final class SingletonHolder {
        private static final LayoutContextImpl INSTANCE = new LayoutContextImpl();

        private SingletonHolder() {
        }
    }
}

