/*
 * Decompiled with CFR 0.152.
 */
package net.sf.xslthl.highlighters;

import java.util.List;
import net.sf.xslthl.Block;
import net.sf.xslthl.CharIter;
import net.sf.xslthl.Highlighter;
import net.sf.xslthl.HighlighterConfigurationException;
import net.sf.xslthl.Params;

public class OnelineCommentHighlighter
extends Highlighter {
    protected String start;
    protected String lineBreakEscape;
    protected boolean solitary;

    @Override
    public void init(Params params) throws HighlighterConfigurationException {
        super.init(params);
        if (params.isSet("start")) {
            this.start = params.getParam("start");
            this.lineBreakEscape = params.getParam("lineBreakEscape");
        } else {
            this.start = params.getParam();
        }
        if (this.start == null || this.start.length() == 0) {
            throw new HighlighterConfigurationException("Required parameter 'start' is not set.");
        }
        this.solitary = params.isSet("solitary");
    }

    @Override
    public boolean startsWith(CharIter in) {
        if (in.startsWith(this.start)) {
            if (this.solitary) {
                int i = 1;
                while (i < in.getPosition() && Character.isWhitespace(in.prev(i).charValue())) {
                    if (OnelineCommentHighlighter.isNewLine(in.prev(i))) {
                        return true;
                    }
                    ++i;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean highlight(CharIter in, List<Block> out) {
        int endIndex;
        in.moveNext(this.start.length());
        do {
            endIndex = in.indexOf("\n");
            int cnt = 1;
            if (endIndex == -1) {
                in.moveToEnd();
            } else {
                in.moveNext(endIndex);
                if (in.prev().equals(Character.valueOf('\r'))) {
                    in.moveNext(-1);
                    ++cnt;
                }
            }
            if (this.lineBreakEscape == null || this.lineBreakEscape.length() == 0 || !in.startsWith(this.lineBreakEscape, -1 * this.lineBreakEscape.length())) break;
            in.moveNext(cnt);
        } while (endIndex != -1);
        out.add(in.markedToStyledBlock(this.styleName));
        return true;
    }

    @Override
    public String getDefaultStyle() {
        return "comment";
    }
}

