/*
 * Decompiled with CFR 0.152.
 */
package net.sf.xslthl;

import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class FilteredElementIterator
implements Iterator<Element> {
    protected Element base;
    protected Element current;
    protected Acceptor acceptor;
    protected boolean dirty = true;
    protected boolean finished;

    public FilteredElementIterator(Element baseElement, Acceptor filter) {
        if (baseElement == null) {
            throw new NullPointerException("Base Element can not be null");
        }
        if (filter == null) {
            throw new NullPointerException("Acceptor can not be null");
        }
        this.acceptor = filter;
        this.base = baseElement;
        this.dirty = true;
    }

    public FilteredElementIterator(Element baseElement, Set<String> acceptTagNames) {
        this(baseElement, new TagNameAcceptor(acceptTagNames));
    }

    @Override
    public boolean hasNext() {
        if (!this.finished && this.dirty) {
            this.getNextElement();
        }
        return this.current != null;
    }

    @Override
    public Element next() {
        if (!this.finished && this.dirty) {
            this.getNextElement();
        }
        if (this.finished) {
            throw new NoSuchElementException();
        }
        this.dirty = true;
        return this.current;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Elements can not be removed");
    }

    protected void getNextElement() {
        assert (!this.finished) : "Should not call getNextElements on a finished list";
        this.current = this.current == null ? this.getAcceptedElement(this.base.getFirstChild()) : this.getAcceptedElement(this.current.getNextSibling());
        this.finished = this.current == null;
        this.dirty = false;
    }

    protected Element getAcceptedElement(Node node) {
        while (node != null) {
            Element result;
            if (node.getNodeType() == 1 && node instanceof Element && this.acceptor.accepted(result = (Element)node)) {
                return result;
            }
            node = node.getNextSibling();
        }
        return null;
    }

    public static interface Acceptor {
        public boolean accepted(Element var1);
    }

    public static class TagNameAcceptor
    implements Acceptor {
        protected Set<String> names;

        public TagNameAcceptor(Set<String> acceptNames) {
            if (acceptNames == null) {
                throw new NullPointerException("Set can not be null");
            }
            this.names = new HashSet<String>(acceptNames);
        }

        @Override
        public boolean accepted(Element elm) {
            return this.names.contains(elm.getTagName());
        }
    }
}

