/*
 * Decompiled with CFR 0.152.
 */
package net.sf.xslthl;

import com.icl.saxon.Context;
import com.icl.saxon.expr.XPathException;
import com.icl.saxon.om.AxisEnumeration;
import com.icl.saxon.om.Builder;
import com.icl.saxon.om.DocumentInfo;
import com.icl.saxon.om.NamePool;
import com.icl.saxon.om.NodeEnumeration;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.pattern.AnyNodeTest;
import com.icl.saxon.pattern.NodeTest;
import com.icl.saxon.tree.AttributeCollection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.xslthl.Block;
import net.sf.xslthl.Config;
import net.sf.xslthl.MainHighlighter;
import net.sf.xslthl.StyledBlock;
import org.xml.sax.Attributes;

public class ConnectorSaxon6 {
    private static Logger logger = Logger.getLogger("net.sf.xslthl.saxon6connector");

    private static void blockToSaxon6Node(Block b, Builder builder, NamePool pool, Config config) throws Exception {
        if (b.isStyled()) {
            AttributeCollection emptyAtts = new AttributeCollection(pool);
            int elemId = pool.allocate(config.prefix, config.uri, ((StyledBlock)b).getStyle());
            builder.startElement(elemId, (Attributes)emptyAtts, new int[0], 0);
            builder.characters(b.getText().toCharArray(), 0, b.getText().length());
            builder.endElement(elemId);
        } else {
            builder.characters(b.getText().toCharArray(), 0, b.getText().length());
        }
    }

    public static NodeEnumeration highlight(Context context, String hlCode, NodeEnumeration nodes) throws Exception {
        return ConnectorSaxon6.highlight(context, hlCode, nodes, null);
    }

    public static NodeEnumeration highlight(Context context, String hlCode, NodeEnumeration nodes, String configFilename) throws Exception {
        try {
            Config c = Config.getInstance(configFilename);
            MainHighlighter hl = c.getMainHighlighter(hlCode);
            NamePool pool = context.getController().getNamePool();
            ArrayList<NodeInfo> resultNodes = new ArrayList<NodeInfo>();
            while (nodes.hasMoreElements()) {
                NodeInfo ni = nodes.nextElement();
                AxisEnumeration ae = ni.getEnumeration((byte)3, (NodeTest)AnyNodeTest.getInstance());
                while (ae.hasMoreElements()) {
                    NodeInfo n2i = ae.nextElement();
                    if (n2i.getNodeType() == 3) {
                        if (hl != null) {
                            try {
                                Builder builder = context.getController().makeBuilder();
                                builder.startDocument();
                                List<Block> l = hl.highlight(n2i.getStringValue());
                                for (Block b : l) {
                                    ConnectorSaxon6.blockToSaxon6Node(b, builder, pool, c);
                                }
                                builder.endDocument();
                                DocumentInfo doc = builder.getCurrentDocument();
                                AxisEnumeration elms = doc.getEnumeration((byte)3, (NodeTest)AnyNodeTest.getInstance());
                                while (elms.hasMoreElements()) {
                                    resultNodes.add(elms.nextElement());
                                }
                            }
                            catch (Exception e) {
                                logger.log(Level.SEVERE, String.format("Highligher threw unhandled error at position %s: %s", n2i.getStringValue(), e.getMessage()), e);
                                resultNodes.add(n2i);
                            }
                            continue;
                        }
                        resultNodes.add(n2i);
                        continue;
                    }
                    resultNodes.add(n2i);
                }
            }
            return new NodeEnumerationIterator(resultNodes.iterator());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    static class NodeEnumerationIterator
    implements NodeEnumeration {
        protected Iterator<NodeInfo> it;

        NodeEnumerationIterator(Iterator<NodeInfo> useit) {
            this.it = useit;
        }

        public boolean hasMoreElements() {
            return this.it.hasNext();
        }

        public boolean isPeer() {
            return true;
        }

        public boolean isReverseSorted() {
            return false;
        }

        public boolean isSorted() {
            return true;
        }

        public NodeInfo nextElement() throws XPathException {
            return this.it.next();
        }
    }
}

