/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.basic.xml.xpath;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import ro.sync.basic.prettyprint.SimplePrettyPrinter;
import ro.sync.basic.prettyprint.SimplePrettyPrinterException;
import ro.sync.basic.xml.xpath.NodeFilter;

public class XPathUtil {
    public static String performXPath(URL url, String xpath) throws IOException {
        return XPathUtil.performXPath(url, xpath, XPathConstants.NODESET);
    }

    public static String performXPath(URL url, String xpath, QName resultType) throws IOException {
        return XPathUtil.performXPath(url, xpath, resultType, null);
    }

    public static String performXPath(URL url, String xpath, QName resultType, NodeFilter nodeFilter) throws IOException {
        try {
            XPath xpathEngine = XPathFactory.newInstance().newXPath();
            InputSource inputSource = new InputSource(url.toString());
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setValidating(false);
            documentBuilderFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            documentBuilderFactory.setFeature("http://xml.org/sax/features/validation", false);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(inputSource);
            Object nodes = xpathEngine.evaluate(xpath, document, resultType);
            if (nodes instanceof NodeList) {
                NodeList nodeList = (NodeList)nodes;
                if (nodeFilter != null) {
                    nodeFilter.filter(nodeList);
                }
                return XPathUtil.serializeNodes(nodeList);
            }
            return String.valueOf(nodes);
        }
        catch (ParserConfigurationException | SAXException e1) {
            throw new IOException(e1);
        }
        catch (XPathExpressionException e) {
            throw new IOException("Cannot execute XPath", e);
        }
    }

    public static String performXPath(File file, String xpath) throws IOException {
        return XPathUtil.performXPath(file.toURI().toURL(), xpath);
    }

    public static String getElemContent(String content, String elemName) {
        String res = null;
        Pattern compile = Pattern.compile("<" + elemName + "(.*)>(.*)</" + elemName + ">", 40);
        Matcher matcher = compile.matcher(content);
        if (matcher.find()) {
            res = matcher.group(2);
        }
        return res;
    }

    public static String serializeNodes(NodeList list) throws IOException {
        StringWriter writer = new StringWriter();
        try {
            int length = list.getLength();
            for (int i = 0; i < length; ++i) {
                ((Writer)writer).write(SimplePrettyPrinter.prettyPrintNode(list.item(i), true));
                if (i == length - 1) continue;
                ((Writer)writer).write("\n");
            }
            String serializedContent = ((Object)writer).toString();
            String string = serializedContent.replace("\r", "");
            return string;
        }
        catch (IOException ex) {
            String string = null;
            return string;
        }
        catch (SimplePrettyPrinterException e) {
            throw new IOException(e.getMessage(), e);
        }
        finally {
            try {
                ((Writer)writer).close();
            }
            catch (IOException iOException) {}
        }
    }
}

