/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.basic.xml.encoding;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xerces.util.XMLChar;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XNIException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import ro.sync.basic.classloader.ClassLoaderUtil;
import ro.sync.basic.contenttypes.ContentTypeChecker;
import ro.sync.basic.io.IOStreamUtil;
import ro.sync.basic.io.NonCloseableReader;
import ro.sync.basic.io.NonCloseableStringReader;
import ro.sync.basic.util.NumberParserUtil;
import ro.sync.basic.util.URLUtil;
import ro.sync.basic.xml.BasicXmlUtil;
import ro.sync.basic.xml.XercesOutputInhibitor;
import ro.sync.basic.xml.encoding.AccessibleEncodingMap;
import ro.sync.basic.xml.encoding.AdditionalEncodingMap;
import ro.sync.basic.xml.encoding.CharacterEncodingException;
import ro.sync.basic.xml.encoding.EncodingChooser;
import ro.sync.basic.xml.encoding.EncodingContentTypeProvider;
import ro.sync.basic.xml.encoding.EncodingDetectorInterface;
import ro.sync.basic.xml.encoding.JavaMappingEncodingException;
import ro.sync.basic.xml.encoding.JavaPlatformEncodingProvider;
import ro.sync.basic.xml.parser.ContentHandlerAdapter;
import ro.sync.basic.xml.parser.lexer.XMLLexer;
import ro.sync.basic.xml.pifinder.PIFinder;

public class EncodingDetectorImpl
implements EncodingDetectorInterface {
    private static final Hashtable bomBytesHash = new Hashtable();
    private static final String BREAKING = "Breaking";
    static final boolean supportsUTF32;
    static int headerSize;
    private static Logger logger;
    private static final String CSS_CHARSET_DECL = "@charset";
    protected String msgError = "Error";
    protected String msgCannotMapIanaToJava = "The document encoding {0} cannot be mapped to a Java encoding";
    protected String msgCharacterDecoderError = "Cannot decode character.";
    protected String msgEncodingErrorsWithLink = "Character encoding error. Using encoding: {0}.";
    protected String msgEncodingErrors = "Character encoding error. Using encoding: {0}.";
    protected int bomOption = 0;
    protected int eHandling = 0;
    protected String encodingForNonXml = "UTF8";
    private EncodingContentTypeProvider ctProvider = filePath -> "text/xml";

    public static boolean isUTF32Supported() {
        boolean supportsUTF32 = false;
        try {
            supportsUTF32 = Charset.forName("UTF-32") != null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return supportsUTF32;
    }

    @Override
    public String getJavaEncodingFromHeaderWithNullFallback(NonCloseableReader reader, List bomBytes) {
        try {
            return this.getJavaEncodingFromHeader(reader, bomBytes);
        }
        catch (JavaMappingEncodingException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getJavaEncodingFromHeader(NonCloseableReader reader, List bomBytes) throws JavaMappingEncodingException {
        reader.rewind();
        String encoding = null;
        try {
            encoding = this.getJavaEncodingFromHeader(new BufferedReader(reader), bomBytes);
        }
        finally {
            reader.rewind();
        }
        return encoding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getJavaEncodingFromHeader(BufferedReader reader, List bomBytes) throws JavaMappingEncodingException {
        String encoding = null;
        try {
            reader.mark(1024);
            char[] chars = new char[1024];
            int len = reader.read(chars, 0, chars.length);
            if (len > 0) {
                encoding = this.getJavaEncodingFromHeader(new String(chars, 0, len), bomBytes);
            }
        }
        catch (JavaMappingEncodingException e) {
            throw e;
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                reader.reset();
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return encoding;
    }

    @Override
    public String getJavaEncodingFromHeader(String str, List bomBytes) throws JavaMappingEncodingException {
        String headerEncoding = this.getHeaderJavaEncoding(str, bomBytes);
        if (headerEncoding == "xmlNoEncoding") {
            headerEncoding = "UTF8";
        }
        return headerEncoding;
    }

    @Override
    public String getHeaderIANAEncoding(Reader reader, boolean useMark) throws IOException {
        String header = EncodingDetectorImpl.extractHeader(reader, useMark);
        String headerEncoding = PIFinder.getHeaderEncoding(new NonCloseableStringReader(header));
        if (headerEncoding == null) {
            String htmlCharset;
            String cssCharset = EncodingDetectorImpl.getCSSCharset(header);
            if (cssCharset != null && cssCharset.length() > 0) {
                headerEncoding = cssCharset;
            }
            if (headerEncoding == null && (htmlCharset = EncodingDetectorImpl.getHTMLCharset(header)) != null && htmlCharset.length() > 0) {
                headerEncoding = htmlCharset;
            }
        }
        return headerEncoding;
    }

    private static String extractHeader(Reader reader, boolean useMark) throws IOException {
        String header = null;
        if (reader != null) {
            char[] chunk;
            if (useMark) {
                reader.mark(headerSize);
            }
            header = reader.read(chunk = new char[headerSize]) != -1 ? new String(chunk) : "";
            if (useMark) {
                reader.reset();
            }
        }
        return header;
    }

    @Override
    public String getHeaderJavaEncoding(String header, List bomBytes) throws JavaMappingEncodingException {
        if (header == null) {
            throw new IllegalArgumentException("Argument header cannot be null.");
        }
        String ianaEncoding = PIFinder.getHeaderEncoding(new NonCloseableStringReader(header));
        if (ianaEncoding != null && ianaEncoding.trim().length() == 0) {
            String javaEncodingFromIANA = this.getJavaEncodingFromIANA(null, bomBytes);
            if (javaEncodingFromIANA != null) {
                return javaEncodingFromIANA;
            }
            return "xmlNoEncoding";
        }
        if (ianaEncoding == null) {
            String htmlCharset;
            String cssCharset = EncodingDetectorImpl.getCSSCharset(header);
            if (cssCharset != null && cssCharset.length() > 0) {
                ianaEncoding = cssCharset;
            }
            if (ianaEncoding == null && (htmlCharset = EncodingDetectorImpl.getHTMLCharset(header)) != null && htmlCharset.length() > 0) {
                ianaEncoding = htmlCharset;
            }
        }
        return this.getJavaEncodingFromIANA(ianaEncoding, bomBytes);
    }

    public static String getHTMLCharset(String header) {
        String htmlCharset = null;
        final boolean[] rootIsHTML = new boolean[1];
        XMLLexer parser = new XMLLexer();
        ContentHandlerAdapter handler = new ContentHandlerAdapter(){

            @Override
            public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
                if ("html".equals(BasicXmlUtil.getLocalName(qName))) {
                    rootIsHTML[0] = true;
                }
                throw new SAXException("Ended.");
            }
        };
        parser.setContentHandler(handler);
        try {
            parser.setProperty("http://xml.org/sax/properties/lexical-handler", handler);
            parser.parse(new InputSource(new StringReader(header)));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (rootIsHTML[0]) {
            header = header.replaceAll("\\s*\\<\\!\\-\\-((?!\\-\\-\\>)[\\s\\S])*\\-\\-\\>\\s*", "");
            Pattern pattern = Pattern.compile("\\s+charset\\s*=\\s*(\"|')?[^'\"\\s/>]*");
            Matcher matcher = pattern.matcher(header);
            if (matcher.find()) {
                htmlCharset = header.substring(matcher.start(), matcher.end()).replaceAll("[\\s|\"|'|/|>]", "");
                htmlCharset = htmlCharset.substring(htmlCharset.indexOf(61) + 1);
            }
        }
        return htmlCharset;
    }

    private static String getCSSCharset(String header) {
        char firstQuote;
        String charsetValueHolder;
        int indexOfSemiCol;
        String cssCharset = null;
        if (header.length() > CSS_CHARSET_DECL.length() && header.substring(0, CSS_CHARSET_DECL.length()).toLowerCase().equals(CSS_CHARSET_DECL) && (indexOfSemiCol = header.indexOf(59)) != -1 && (charsetValueHolder = header.substring(CSS_CHARSET_DECL.length(), indexOfSemiCol).trim()).length() > 2 && ((firstQuote = charsetValueHolder.charAt(0)) == '\'' || firstQuote == '\"') && firstQuote == charsetValueHolder.charAt(charsetValueHolder.length() - 1)) {
            cssCharset = charsetValueHolder.substring(1, charsetValueHolder.length() - 1);
        }
        return cssCharset;
    }

    @Override
    public String getIANAEncodingFromJava(String javaEncoding) {
        return AdditionalEncodingMap.getJava2IANAMapping(javaEncoding);
    }

    @Override
    public String getJavaEncodingFromIANA(String ianaEncoding) throws JavaMappingEncodingException {
        return this.getJavaEncodingFromIANA(ianaEncoding, null);
    }

    private String getJavaEncodingFromIANA(String ianaEncoding, List<Byte> bomBytes) throws JavaMappingEncodingException {
        String javaEncoding = null;
        if (bomBytes != null && bomBytes.size() == 2) {
            if (ianaEncoding == null || "UTF-16".equals(ianaEncoding)) {
                byte b1 = bomBytes.get(0);
                byte b2 = bomBytes.get(1);
                if (b1 == -1 && b2 == -2) {
                    return "UnicodeLittle";
                }
                if (b1 == -2 && b2 == -1) {
                    return "UnicodeBig";
                }
            }
        } else if ("UTF-16".equals(ianaEncoding)) {
            return System.getProperty("sun.io.unicode.encoding", "UnicodeLittle");
        }
        if (ianaEncoding != null && (javaEncoding = AdditionalEncodingMap.getIANA2JavaMapping(ianaEncoding)) == null && (javaEncoding = AdditionalEncodingMap.getIANA2JavaMapping(ianaEncoding.toUpperCase())) == null) {
            if (this.isJavaEncoding(ianaEncoding)) {
                javaEncoding = ianaEncoding;
            } else {
                Object errorMessage = this.msgCannotMapIanaToJava != null ? MessageFormat.format(this.msgCannotMapIanaToJava, ianaEncoding) : "Cannot map " + ianaEncoding + " to a Java encoding";
                throw new JavaMappingEncodingException((String)errorMessage);
            }
        }
        return javaEncoding;
    }

    @Override
    public boolean isJavaEncoding(String encoding) {
        try {
            new InputStreamReader((InputStream)new ByteArrayInputStream(new byte[]{120, 109, 108}), encoding).close();
        }
        catch (UnsupportedEncodingException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("UEE Is not a java encoding:" + encoding);
            }
            return false;
        }
        catch (IOException e) {
            if (logger.isDebugEnabled()) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            return false;
        }
        return true;
    }

    @Override
    public String getJavaEncoding(Reader reader, boolean useMark, List bomBytes) throws IOException {
        String header = EncodingDetectorImpl.extractHeader(reader, useMark);
        return this.getJavaEncodingFromHeader(header, bomBytes);
    }

    private String getJavaEncodingForReading(InputStream inputStream, boolean useMark, List bomBytes, String defaultJavaEncoding) throws IOException, JavaMappingEncodingException {
        if (inputStream == null) {
            throw new IllegalArgumentException("Argument inputStream cannot be null.");
        }
        if (useMark) {
            inputStream.mark(headerSize);
        }
        byte[] bytes = new byte[headerSize];
        IOStreamUtil.readFully(inputStream, bytes);
        String javaEncoding = this.getJavaEncoding(new InputSource(new ByteArrayInputStream(bytes)));
        if (javaEncoding == null) {
            javaEncoding = defaultJavaEncoding;
        }
        try {
            String header = new String(bytes, javaEncoding);
            if (logger.isDebugEnabled()) {
                logger.debug("The header is: " + header);
            }
            String headerEncoding = this.getHeaderJavaEncoding(header, bomBytes);
            if (logger.isDebugEnabled()) {
                logger.debug("HE " + headerEncoding);
            }
            if (!"xmlNoEncoding".equals(headerEncoding)) {
                boolean ambigousHeaderEncoding;
                boolean bl = ambigousHeaderEncoding = headerEncoding != null && (headerEncoding.equals("Unicode") || headerEncoding.equals("UTF-16"));
                if (!ambigousHeaderEncoding) {
                    javaEncoding = headerEncoding;
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            logger.warn(e.getMessage(), (Throwable)e);
            throw new JavaMappingEncodingException("Cannot determine the encoding.");
        }
        if (useMark) {
            inputStream.reset();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("The encoding is: " + javaEncoding);
        }
        return javaEncoding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getJavaEncoding(InputSource inputSource) throws IOException {
        if (inputSource == null) {
            throw new IllegalArgumentException("inputSource argument cannot be null.");
        }
        ClassLoader oldClassLoader = ClassLoaderUtil.installContextClassLoader();
        try {
            DOMParserEncodingDetector parser = new DOMParserEncodingDetector();
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug("Parsing..");
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Setting to true: http://apache.org/xml/features/allow-java-encodings");
                }
                parser.setFeature("http://apache.org/xml/features/allow-java-encodings", true);
                parser.setErrorHandler(new XercesOutputInhibitor());
                parser.parse(inputSource);
            }
            catch (SAXException e) {
                if (logger.isDebugEnabled()) {
                    if (BREAKING.equals(e.getMessage())) {
                        logger.debug(BREAKING);
                    } else {
                        logger.debug(e.getMessage(), (Throwable)e);
                    }
                }
            }
            catch (FileNotFoundException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            String string = parser.getJavaEncoding();
            return string;
        }
        finally {
            ClassLoaderUtil.uninstallContextClassLoader(oldClassLoader);
        }
    }

    @Override
    public String getJavaPlatformEncoding() {
        return JavaPlatformEncodingProvider.getJavaPlatformEncoding();
    }

    @Override
    public String getDefaultIANAPlatformEncoding() {
        return "UTF-8";
    }

    public EncodingDetectorImpl() {
    }

    public EncodingDetectorImpl(String msgError, String msgCannotMapIanaToJava, String msgCharacterDecoderError, String msgEncodingErrorsWithLink, String msgEncodingErrors, int bomOption, int eHandling, String encodingForNonXml, EncodingContentTypeProvider ctProvider) {
        this.ctProvider = ctProvider;
        if (msgError != null) {
            this.msgError = msgError;
        }
        if (msgCannotMapIanaToJava != null) {
            this.msgCannotMapIanaToJava = msgCannotMapIanaToJava;
        }
        if (msgCharacterDecoderError != null) {
            this.msgCharacterDecoderError = msgCharacterDecoderError;
        }
        if (msgEncodingErrorsWithLink != null) {
            this.msgEncodingErrorsWithLink = msgEncodingErrorsWithLink;
        }
        if (msgEncodingErrors != null) {
            this.msgEncodingErrors = msgEncodingErrors;
        }
        this.bomOption = bomOption;
        this.eHandling = eHandling;
        this.encodingForNonXml = encodingForNonXml;
    }

    @Override
    public Object[] getEncodingName(byte[] b4, int count) {
        if (count < 2) {
            return new Object[]{null, null, NumberParserUtil.valueOfInteger(0)};
        }
        int b0 = b4[0] & 0xFF;
        int b1 = b4[1] & 0xFF;
        if (b0 == 254 && b1 == 255) {
            return new Object[]{"UTF-16BE", Boolean.TRUE, NumberParserUtil.valueOfInteger(2)};
        }
        if (b0 == 255 && b1 == 254 && (count < 4 || b4[2] != 0 || b4[3] != 0)) {
            return new Object[]{"UTF-16LE", Boolean.FALSE, NumberParserUtil.valueOfInteger(2)};
        }
        if (count < 3) {
            return new Object[]{null, null, NumberParserUtil.valueOfInteger(0)};
        }
        int b2 = b4[2] & 0xFF;
        if (b0 == 239 && b1 == 187 && b2 == 191) {
            return new Object[]{"UTF-8", null, NumberParserUtil.valueOfInteger(3)};
        }
        if (count < 4) {
            return new Object[]{null, null, NumberParserUtil.valueOfInteger(0)};
        }
        int b3 = b4[3] & 0xFF;
        if (b0 == 0 && b1 == 0 && b2 == 0 && b3 != 0) {
            return new Object[]{"ISO-10646-UCS-4", Boolean.TRUE, NumberParserUtil.valueOfInteger(4)};
        }
        if (b0 != 0 && b1 == 0 && b2 == 0 && b3 == 0) {
            return new Object[]{"ISO-10646-UCS-4", Boolean.FALSE, NumberParserUtil.valueOfInteger(4)};
        }
        if (b0 == 0 && b1 == 0 && b2 != 0 && b3 == 0) {
            return new Object[]{"ISO-10646-UCS-4", null, NumberParserUtil.valueOfInteger(4)};
        }
        if (b0 == 0 && b1 != 0 && b2 == 0 && b3 == 0) {
            return new Object[]{"ISO-10646-UCS-4", null, NumberParserUtil.valueOfInteger(4)};
        }
        if (b0 == 0 && b1 == 0 && b2 == 254 && b3 == 255) {
            return new Object[]{"ISO-10646-UCS-4", null, NumberParserUtil.valueOfInteger(4)};
        }
        if (b0 == 255 && b1 == 254 && b2 == 0 && b3 == 0) {
            return new Object[]{"ISO-10646-UCS-4", Boolean.FALSE, NumberParserUtil.valueOfInteger(4), Boolean.TRUE};
        }
        if (b0 == 0 && b1 != 0 && b2 == 0 && b3 != 0) {
            return new Object[]{"UTF-16BE", Boolean.TRUE, NumberParserUtil.valueOfInteger(0)};
        }
        if (b0 != 0 && b1 == 0 && b2 != 0 && b3 == 0) {
            return new Object[]{"UTF-16LE", Boolean.FALSE, NumberParserUtil.valueOfInteger(0)};
        }
        if (b0 == 76 && b1 == 111 && b2 == 167 && b3 == 148) {
            return new Object[]{"CP037", null, NumberParserUtil.valueOfInteger(4)};
        }
        return new Object[]{null, null, NumberParserUtil.valueOfInteger(0)};
    }

    private InputStreamReader createReader(InputStream inputStream, String encoding, boolean hasUTF16Mark, String defaultJavaEncoding) throws IOException {
        if (encoding == null) {
            encoding = defaultJavaEncoding;
        }
        if (encoding == null) {
            return this.createInputStreamReader(inputStream);
        }
        String ENCODING = encoding.toUpperCase(Locale.ENGLISH);
        if (ENCODING.equals("UTF-8")) {
            return this.createInputStreamReader(inputStream, "UTF8");
        }
        if (ENCODING.equals("ISO-10646-UCS-4") && !supportsUTF32) {
            throw new IOException("Detected unsupported encoding: ISO-10646-UCS-4");
        }
        if (ENCODING.equals("ISO-10646-UCS-2")) {
            throw new IOException("Detected unsupported encoding: ISO-10646-UCS-2");
        }
        boolean validIANA = XMLChar.isValidIANAEncoding((String)encoding);
        boolean validJava = XMLChar.isValidJavaEncoding((String)encoding);
        if (!validIANA || !validJava) {
            encoding = "ISO-8859-1";
        }
        String javaEncoding = AdditionalEncodingMap.getIANA2JavaMapping(ENCODING);
        if (hasUTF16Mark) {
            if ("UnicodeLittleUnmarked".equals(javaEncoding)) {
                javaEncoding = "UnicodeLittle";
            }
            if ("UnicodeBigUnmarked".equals(javaEncoding)) {
                javaEncoding = "UnicodeBig";
            }
        }
        if (javaEncoding == null) {
            javaEncoding = encoding;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Effectively using for reader:" + javaEncoding);
        }
        return this.createInputStreamReader(inputStream, javaEncoding);
    }

    @Override
    public InputStreamReader createReader(InputStream inputStream, String description, EncodingChooser encodingChooser, String defaultJavaEncoding, List<Byte> bomBytes) throws IOException {
        int count;
        if (logger.isDebugEnabled()) {
            logger.debug("defaultJavaEncoding: " + defaultJavaEncoding);
        }
        BufferedInputStream is = new BufferedInputStream(inputStream);
        ((InputStream)is).mark(1000);
        byte[] b4 = new byte[4];
        for (count = 0; count < 4; ++count) {
            b4[count] = (byte)((InputStream)is).read();
        }
        boolean forceSkipBOM = false;
        Object[] encInfo = this.getEncodingName(b4, count);
        if (encInfo.length > 3) {
            forceSkipBOM = (Boolean)encInfo[3];
        }
        int bomLength = (Integer)encInfo[2];
        Boolean isBigEndian = (Boolean)encInfo[1];
        String bomEncoding = (String)encInfo[0];
        if (bomLength > 0 && bomBytes != null) {
            bomBytes.clear();
            for (int i = 0; i < bomLength; ++i) {
                bomBytes.add(b4[i]);
            }
        }
        ((InputStream)is).reset();
        String encoding = null;
        try {
            encoding = this.getJavaEncodingForReading(is, false, bomBytes, defaultJavaEncoding);
        }
        catch (JavaMappingEncodingException ex) {
            logger.warn(ex.getMessage(), (Throwable)ex);
            if (encodingChooser == null) {
                encoding = defaultJavaEncoding;
                if (logger.isDebugEnabled()) {
                    logger.debug("encodingChooser is null and JavaMappingEncodingException: " + ex.getMessage() + "\nso use defaultJavaEncoding: " + defaultJavaEncoding);
                }
            }
            encodingChooser.showErrorMessage(ex.getMessage(), this.msgError + " " + description);
            encoding = this.askUserForEncoding(encodingChooser);
        }
        ((InputStream)is).reset();
        bomEncoding = EncodingDetectorImpl.composeArtificialUTF32Notation(bomEncoding, isBigEndian);
        if (bomEncoding != null) {
            encoding = bomEncoding;
        }
        if (forceSkipBOM) {
            ((InputStream)is).skip(bomLength);
        } else if (bomLength == 3 || bomLength == 2) {
            ((InputStream)is).skip(bomLength);
        }
        boolean hasUTF16Mark = isBigEndian != null && bomLength == 2;
        return this.createReader(is, encoding, hasUTF16Mark, defaultJavaEncoding);
    }

    private String askUserForEncoding(EncodingChooser encodingChooser) {
        encodingChooser.setEncodings(AccessibleEncodingMap.getSupportedJavaEncodings());
        String result = encodingChooser.getSelectedEncoding();
        if (result == null) {
            logger.warn("No selected encoding from list. Using UTF8");
            result = "UTF8";
        }
        if (logger.isDebugEnabled()) {
            logger.debug("user selected the encoding: " + result);
        }
        return result;
    }

    @Override
    public InputStreamReader createReader(URL url, EncodingChooser encodingChooser, String defaultJavaEncoding, List bomBytes) throws IOException {
        url = URLUtil.removeQueryFromFileURL(url);
        URLConnection connection = url.openConnection();
        connection.connect();
        return this.createReader(connection.getInputStream(), URLUtil.getDescription(url), encodingChooser, defaultJavaEncoding, bomBytes);
    }

    @Override
    public String getJavaEncoding(File file) throws IOException {
        FileInputStream is = new FileInputStream(file);
        InputStreamReader isr = this.createReader(is, null, null, null, null);
        String encoding = isr.getEncoding();
        isr.close();
        return encoding;
    }

    @Override
    public OutputStreamWriter createWriter(OutputStream os, String javaEncoding, String defaultPlatformEncoding, boolean hasUTF8BOMWhenLoading) throws UnsupportedEncodingException, IOException {
        String defaultUnicodeEncoding;
        OutputStreamWriter wr = null;
        String encoding = null;
        if (javaEncoding == null) {
            String string = encoding = defaultPlatformEncoding != null ? defaultPlatformEncoding : StandardCharsets.UTF_8.name();
            if (logger.isDebugEnabled()) {
                logger.debug("Using the options default for non xml: " + encoding);
            }
        } else {
            encoding = javaEncoding;
            if (logger.isDebugEnabled()) {
                logger.debug("Saving document using java encoding: " + javaEncoding);
            }
        }
        byte[] bytesToWrite = null;
        switch (this.bomOption) {
            case 0: {
                if (!hasUTF8BOMWhenLoading) break;
                bytesToWrite = (byte[])bomBytesHash.get(encoding);
                break;
            }
            case 2: {
                bytesToWrite = (byte[])bomBytesHash.get(encoding);
            }
        }
        if (bytesToWrite != null) {
            if (logger.isDebugEnabled()) {
                for (int i = 0; i < bytesToWrite.length; ++i) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("BOM[" + i + "]" + bytesToWrite[i]);
                }
            }
            os.write(bytesToWrite);
        }
        if (("UTF-16".equals(encoding) || "UTF16".equals(encoding) || "Unicode".equals(encoding)) && (defaultUnicodeEncoding = System.getProperty("sun.io.unicode.encoding")) != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("The encoding " + encoding + " is too generic. Trying to use the value of the property sun.io.unicode.encoding: " + defaultUnicodeEncoding);
            }
            encoding = defaultUnicodeEncoding;
        }
        if (encoding == null) {
            wr = new OutputStreamWriter(os);
        } else {
            try {
                if (Charset.isSupported(encoding)) {
                    Charset charset = Charset.forName(encoding);
                    CharsetEncoder encoder = charset.newEncoder();
                    encoder.onMalformedInput(CodingErrorAction.REPORT);
                    encoder.onUnmappableCharacter(CodingErrorAction.REPORT);
                    wr = new OutputStreamWriter(os, encoder);
                } else {
                    if (logger.isDebugEnabled()) {
                        logger.debug("The encoding is not known by the Charset: ");
                    }
                    wr = new OutputStreamWriter(os, encoding);
                }
            }
            catch (IllegalCharsetNameException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug(e.getMessage(), (Throwable)e);
                }
                throw new UnsupportedEncodingException("Bad encoding: " + e);
            }
            catch (UnsupportedCharsetException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug(e.getMessage(), (Throwable)e);
                }
                throw new UnsupportedEncodingException("Bad encoding: " + e);
            }
            catch (UnsupportedOperationException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug(e.getMessage(), (Throwable)e);
                }
                throw new UnsupportedEncodingException("Cannot create encoder: " + e);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Effectively using for writer: " + wr.getEncoding());
        }
        return wr;
    }

    @Override
    public InputStreamReader createReader(File fileWithEncoding) throws IOException {
        return this.createReader(URLUtil.correct(fileWithEncoding), null, this.getJavaEncodingFromExtension(fileWithEncoding.getAbsolutePath()), null);
    }

    @Override
    public InputStreamReader createReader(File fileWithEncoding, List bomBytes) throws IOException {
        return this.createReader(URLUtil.correct(fileWithEncoding), null, this.getJavaEncodingFromExtension(fileWithEncoding.getAbsolutePath()), bomBytes);
    }

    @Override
    public String getJavaEncodingFromExtension(String filePath) {
        String defaultJavaEncoding = this.encodingForNonXml;
        if (filePath != null) {
            String contentType = this.ctProvider.getContentTypeForSystemID(filePath);
            if (logger.isDebugEnabled()) {
                logger.debug("Detected Content type for file:" + URLUtil.filterPasswords(filePath) + " is:" + contentType);
            }
            defaultJavaEncoding = this.getJavaEncodingFromContentType(contentType);
        }
        return defaultJavaEncoding;
    }

    @Override
    public String getJavaEncodingFromContentType(String contentType) {
        String defaultJavaEncoding = this.encodingForNonXml;
        if (contentType != null) {
            if (ContentTypeChecker.isXMLContentType(contentType)) {
                defaultJavaEncoding = "UTF8";
            } else if ("text/dtd".equals(contentType) || "text/javascript".equals(contentType) || "text/json".equals(contentType) || "text/json-schema".equals(contentType) || "text/yaml".equals(contentType) || "text/sql".equals(contentType) || "text/xquery".equals(contentType) || "text/css".equals(contentType) || "text/markdown".equals(contentType) || "text/rnc".equals(contentType)) {
                defaultJavaEncoding = "UTF8";
            } else if ("text/properties".equals(contentType)) {
                defaultJavaEncoding = "8859_1";
            }
        }
        return defaultJavaEncoding;
    }

    private InputStreamReader createInputStreamReader(InputStream in) throws UnsupportedEncodingException {
        return this.createInputStreamReader(in, null);
    }

    private static Charset getCharset(final String encoding) {
        return CacheHolder.AVAILABLE_CHARSETS.computeIfAbsent(encoding, new Function<String, Charset>(){

            @Override
            public Charset apply(String t) {
                return Charset.forName(encoding);
            }
        });
    }

    private InputStreamReader createInputStreamReader(InputStream in, String javaEncoding) throws UnsupportedEncodingException {
        if (this.eHandling == 2 || this.eHandling == 0) {
            if (javaEncoding == null) {
                javaEncoding = this.getJavaPlatformEncoding();
            }
            String encoding = AdditionalEncodingMap.getJava2IANAMapping(javaEncoding);
            if ("UnicodeLittle".equals(javaEncoding) || "UnicodeBig".equals(javaEncoding)) {
                encoding = null;
            }
            if (encoding == null) {
                encoding = javaEncoding;
            }
            Charset cs = EncodingDetectorImpl.getCharset(encoding);
            CharsetDecoder dec = null;
            if (cs != null) {
                dec = cs.newDecoder();
            }
            if (dec != null) {
                if (this.eHandling == 2) {
                    dec.onMalformedInput(CodingErrorAction.IGNORE);
                    dec.onUnmappableCharacter(CodingErrorAction.IGNORE);
                    return new InputStreamReader(in, dec);
                }
                dec.onMalformedInput(CodingErrorAction.REPORT);
                dec.onUnmappableCharacter(CodingErrorAction.REPORT);
                return new EncodingErrorReportingReader(in, dec);
            }
        }
        if (javaEncoding == null) {
            return new InputStreamReader(in);
        }
        return new InputStreamReader(in, javaEncoding);
    }

    @Override
    public int getBytesPerChar(String encoding) {
        String enc = encoding.toUpperCase(Locale.ENGLISH);
        int bpc = -1;
        if (enc.equals("ASCII") || enc.equals("CP1252") || enc.startsWith("ISO-8859") || enc.startsWith("ISO8859")) {
            bpc = 1;
        }
        if (enc.indexOf("UTF-16") != -1 || enc.indexOf("UTF16") != -1 || enc.indexOf("UNICODE") != -1) {
            bpc = 2;
        }
        return bpc;
    }

    private static String composeArtificialUTF32Notation(String ianaEncoding, Boolean bigEndian) {
        if ("ISO-10646-UCS-4".equals(ianaEncoding) && bigEndian != null && !bigEndian.booleanValue()) {
            ianaEncoding = (String)ianaEncoding + " LE";
        }
        return ianaEncoding;
    }

    public void setBomOption(int bomOption) {
        this.bomOption = bomOption;
    }

    public void setErrorHandling(int eHandling) {
        this.eHandling = eHandling;
    }

    public void setEncodingForNonXml(String encodingForNonXml) {
        this.encodingForNonXml = encodingForNonXml;
    }

    static {
        bomBytesHash.put("UTF8", new byte[]{-17, -69, -65});
        bomBytesHash.put("UTF-8", bomBytesHash.get("UTF8"));
        supportsUTF32 = EncodingDetectorImpl.isUTF32Supported();
        headerSize = 1024;
        logger = LoggerFactory.getLogger((String)EncodingDetectorImpl.class.getName());
    }

    private static class DOMParserEncodingDetector
    extends DOMParser {
        String _mimeEncoding = null;

        private DOMParserEncodingDetector() {
        }

        private String getJavaEncoding() throws JavaMappingEncodingException {
            String mimeEncoding = this.getMimeEncoding();
            String javaEncoding = null;
            if (logger.isDebugEnabled()) {
                logger.debug("The mime encoding is:" + mimeEncoding);
            }
            if (mimeEncoding != null) {
                javaEncoding = mimeEncoding.equals("DEFAULT") ? "UTF8" : (mimeEncoding.equalsIgnoreCase("UTF-16") ? "Unicode" : AdditionalEncodingMap.getIANA2JavaMapping(mimeEncoding));
                if (javaEncoding == null) {
                    throw new JavaMappingEncodingException("Could not map into Java the specified encoding: " + mimeEncoding);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Returning: " + javaEncoding);
                }
            }
            return javaEncoding;
        }

        public void startDocument(XMLLocator locator, String encoding, NamespaceContext namespaceContext, Augmentations augs) throws XNIException {
            if (logger.isDebugEnabled()) {
                logger.debug("Started the document with encoding: " + encoding + " Aug:" + augs);
            }
            if (encoding != null) {
                this.setMimeEncoding(encoding);
            } else {
                this.setMimeEncoding("UTF-8");
            }
            throw new XNIException(EncodingDetectorImpl.BREAKING);
        }

        private void setMimeEncoding(String encoding) {
            this._mimeEncoding = encoding;
        }

        private String getMimeEncoding() {
            return this._mimeEncoding;
        }
    }

    private static class CacheHolder {
        private static final Map<String, Charset> AVAILABLE_CHARSETS = new ConcurrentHashMap<String, Charset>();

        private CacheHolder() {
        }

        static {
            AVAILABLE_CHARSETS.putAll(Charset.availableCharsets());
        }
    }

    private class EncodingErrorReportingReader
    extends InputStreamReader {
        public EncodingErrorReportingReader(InputStream in, CharsetDecoder dec) {
            super(in, dec);
        }

        @Override
        public int read() throws IOException {
            try {
                return super.read();
            }
            catch (CharacterCodingException e) {
                throw new CharacterEncodingException(this.getErrorMessage(), this.getDetailedErrorMessage(), e);
            }
            catch (IllegalStateException e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new IOException(this.getErrorMessage(e));
            }
        }

        @Override
        public int read(char[] cbuf, int offset, int length) throws IOException {
            try {
                return super.read(cbuf, offset, length);
            }
            catch (CharacterCodingException e) {
                throw new CharacterEncodingException(this.getErrorMessage(), this.getDetailedErrorMessage(), e);
            }
            catch (IllegalStateException e) {
                throw new IOException(this.getErrorMessage(e), e);
            }
        }

        private String getErrorMessage() {
            return MessageFormat.format(EncodingDetectorImpl.this.msgEncodingErrors, this.getEncoding());
        }

        private String getDetailedErrorMessage() {
            return MessageFormat.format(EncodingDetectorImpl.this.msgEncodingErrorsWithLink, this.getEncoding());
        }

        private String getErrorMessage(RuntimeException e) {
            return EncodingDetectorImpl.this.msgCharacterDecoderError + "\n" + this.getEncoding() + " - " + e.getClass().getName() + " [" + e.getMessage() + "]";
        }
    }
}

