/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.basic.util.java;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ro.sync.basic.util.NumberFormatException;
import ro.sync.basic.util.NumberParserUtil;

class JavaVersionParser {
    static final int JAVA_VERSION_FORMAT_FIELDS_COUNT = 4;
    private static final Pattern NUMBER_PATTERN = Pattern.compile("\\d+");
    private static final char[] V_NUM_STRING_SEPARATOR_CHAR = new char[]{'_', '-', '+'};

    private JavaVersionParser() {
        throw new IllegalStateException("Utility class instantiation is prohibited.");
    }

    static int[] parse(String javaVersionString) throws NumberFormatException {
        int[] version = new int[4];
        javaVersionString = javaVersionString.trim();
        String[] versionTokens = javaVersionString.split("\\.", 4);
        String lastTokenExtraInfo = null;
        for (int i = 0; i < versionTokens.length; ++i) {
            String extraInfo = JavaVersionParser.processNumericToken(versionTokens[i], i, i == versionTokens.length - 1, version);
            if (i != versionTokens.length - 1) continue;
            lastTokenExtraInfo = extraInfo;
        }
        boolean validTokens = false;
        if (version[0] >= 1 && version[0] < 9) {
            if (versionTokens.length == 3) {
                JavaVersionParser.parse1xMicroUpdate(lastTokenExtraInfo, version);
                validTokens = true;
            } else if (versionTokens.length == 2 && (lastTokenExtraInfo == null || lastTokenExtraInfo.isEmpty())) {
                validTokens = true;
            }
        } else if (version[0] == 9 && versionTokens.length <= 3 || version[0] >= 10) {
            validTokens = true;
        }
        if (!validTokens) {
            throw new IllegalArgumentException("Unknown version format: " + javaVersionString);
        }
        return version;
    }

    private static String processNumericToken(String token, int tokenIndex, boolean isLastToken, int[] versionArray) throws NumberFormatException {
        boolean validToken = false;
        String tokenPostfix = null;
        Matcher numberMatcher = NUMBER_PATTERN.matcher(token);
        if (numberMatcher.find() && numberMatcher.start() == 0) {
            int endOffset = numberMatcher.end();
            boolean bl = validToken = endOffset == token.length() || isLastToken && JavaVersionParser.isAllowedVNumStringSeparator(token.charAt(endOffset));
            if (validToken && versionArray[0] > 0 && endOffset != token.length()) {
                char vNumStringSeparatorChar = token.charAt(endOffset);
                boolean bl2 = validToken = versionArray[0] < 9 && (vNumStringSeparatorChar == '_' || vNumStringSeparatorChar == '-') || versionArray[0] >= 9 && (vNumStringSeparatorChar == '-' || vNumStringSeparatorChar == '+');
            }
            if (validToken) {
                versionArray[tokenIndex] = NumberParserUtil.parseInt(token.substring(0, endOffset));
                if (isLastToken) {
                    tokenPostfix = token.substring(endOffset);
                }
            }
        }
        if (!validToken) {
            throw new IllegalArgumentException("Invalid token format: " + token);
        }
        return tokenPostfix;
    }

    private static boolean isAllowedVNumStringSeparator(char c) {
        for (int i = 0; i < V_NUM_STRING_SEPARATOR_CHAR.length; ++i) {
            if (V_NUM_STRING_SEPARATOR_CHAR[i] != c) continue;
            return true;
        }
        return false;
    }

    private static void parse1xMicroUpdate(String token, int[] version) throws NumberFormatException {
        if (token == null || token.isEmpty()) {
            return;
        }
        String microString = null;
        String updateString = null;
        microString = token;
        int updateSeparatorIndex = token.indexOf(95);
        int identifiersSeparatorIndex = token.indexOf(45);
        if (updateSeparatorIndex > -1 || identifiersSeparatorIndex > -1) {
            if (updateSeparatorIndex > -1) {
                microString = token.substring(0, updateSeparatorIndex);
                updateString = token.substring(updateSeparatorIndex + 1);
                identifiersSeparatorIndex = updateString.indexOf(45);
                if (identifiersSeparatorIndex > -1) {
                    updateString = updateString.substring(0, identifiersSeparatorIndex);
                }
            } else if (identifiersSeparatorIndex > -1) {
                microString = token.substring(0, identifiersSeparatorIndex);
            }
        }
        if (microString != null && !microString.isEmpty()) {
            version[2] = NumberParserUtil.parseInt(microString);
        }
        if (updateString != null && !updateString.isEmpty()) {
            version[3] = NumberParserUtil.parseInt(updateString);
        }
    }
}

