/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.basic.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;

public class ArraysUtil {
    public static final Object[][] shiftRight(Object[][] views, int colPos) {
        Object[][] newViews = (Object[][])Array.newInstance(views[0].getClass().getComponentType(), views.length, views[0].length + 1);
        for (int j = 0; j < views.length; ++j) {
            System.arraycopy(views[j], 0, newViews[j], 0, colPos);
            System.arraycopy(views[j], colPos, newViews[j], colPos + 1, views[j].length - colPos);
        }
        return newViews;
    }

    public static final Object[][] removeRowInMatrix(Object[][] matrix, int rowIndex) {
        Object[][] leftViews = (Object[][])Array.newInstance(matrix[0].getClass().getComponentType(), matrix.length - 1, matrix[0].length);
        int offset = 0;
        for (int s = 0; s < matrix.length; ++s) {
            if (s == rowIndex) {
                offset = 1;
                continue;
            }
            System.arraycopy(matrix[s], 0, leftViews[s - offset], 0, matrix[s].length);
        }
        return leftViews;
    }

    public static final Object[][] removeColumnInMatrix(Object[][] recs, int colIndex) {
        Object[][] leftRecords = (Object[][])Array.newInstance(recs[0].getClass().getComponentType(), recs.length, recs[0].length - 1);
        for (int i = 0; i < recs.length; ++i) {
            System.arraycopy(recs[i], 0, leftRecords[i], 0, colIndex);
            System.arraycopy(recs[i], colIndex + 1, leftRecords[i], colIndex, leftRecords[i].length - colIndex);
        }
        return leftRecords;
    }

    public static final Object[][] increaseNoOfCols(Object[][] recs, int newColsNo) {
        Object[][] newRecords = (Object[][])Array.newInstance(recs[0].getClass().getComponentType(), recs.length, newColsNo);
        for (int i = 0; i < recs.length; ++i) {
            System.arraycopy(recs[i], 0, newRecords[i], 0, recs[i].length);
        }
        return newRecords;
    }

    public static final Object[][] shiftDownMatrix(Object[][] rec, int shiftPosition, int gap, int realColNo) {
        Object[][] newRecords = (Object[][])Array.newInstance(rec[0].getClass().getComponentType(), rec.length + gap, rec[0].length);
        int offset = 0;
        for (int i = 0; i < rec.length; ++i) {
            if (i == shiftPosition) {
                offset = gap;
            }
            System.arraycopy(rec[i], 0, newRecords[i + offset], 0, realColNo);
        }
        return newRecords;
    }

    public static final Object[] compactArray(Object[] array, int maxSize) {
        Object[] toReturn = array;
        if (array != null && array.length > maxSize) {
            toReturn = (Object[])Array.newInstance(array.getClass().getComponentType(), maxSize);
            System.arraycopy(array, 0, toReturn, 0, maxSize);
        }
        return toReturn;
    }

    public static final Object[] extendArray(Object[] array, int maxSize) {
        Object[] toReturn = array;
        if (array != null) {
            toReturn = (Object[])Array.newInstance(array.getClass().getComponentType(), maxSize);
            System.arraycopy(array, 0, toReturn, 0, array.length);
        }
        return toReturn;
    }

    public static final Object[][] compactMatrix(Object[][] matrix, int realColsSize) {
        Object[][] newRecords = (Object[][])Array.newInstance(matrix[0].getClass().getComponentType(), matrix.length, realColsSize);
        for (int i = 0; i < matrix.length; ++i) {
            System.arraycopy(matrix[i], 0, newRecords[i], 0, realColsSize);
        }
        return newRecords;
    }

    public static Object mergeArrays(Object array1, Object array2, int mergePosition) {
        if (array1 instanceof List && array2 instanceof List) {
            ArrayList toReturn = new ArrayList(((List)array1).size() + ((List)array2).size());
            toReturn.addAll((List)array1);
            if (mergePosition >= 0 && mergePosition < ((List)array1).size()) {
                toReturn.addAll(mergePosition, (List)array2);
            } else {
                toReturn.addAll((List)array2);
            }
            return toReturn;
        }
        int array1Length = Array.getLength(array1);
        int array2Length = Array.getLength(array2);
        Object result = Array.newInstance(array1.getClass().getComponentType(), array1Length + array2Length);
        int insertIndex = mergePosition >= 0 && mergePosition < Array.getLength(array1) ? mergePosition : array1Length;
        System.arraycopy(array1, 0, result, 0, insertIndex);
        System.arraycopy(array2, 0, result, insertIndex, array2Length);
        System.arraycopy(array1, insertIndex, result, insertIndex + array2Length, array1Length - insertIndex);
        return result;
    }

    static Object[] shiftRight(Object[] cols, int colIndex) {
        Object[] newCols = (Object[])Array.newInstance(cols.getClass().getComponentType(), cols.length + 1);
        System.arraycopy(cols, 0, newCols, 0, colIndex);
        System.arraycopy(cols, colIndex, newCols, colIndex + 1, cols.length - colIndex);
        return newCols;
    }

    public static Object removeIndexFromArray(Object array, int index) {
        if (array instanceof List) {
            ((List)array).remove(index);
            return array;
        }
        Object leftColNames = Array.newInstance(array.getClass().getComponentType(), Array.getLength(array) - 1);
        System.arraycopy(array, 0, leftColNames, 0, index);
        System.arraycopy(array, index + 1, leftColNames, index, Array.getLength(leftColNames) - index);
        return leftColNames;
    }

    public static Class getComponentType(Object array) {
        if (array instanceof List) {
            Object firstObject;
            List list = (List)array;
            if (list.size() > 0 && (firstObject = list.get(0)) != null) {
                return firstObject.getClass();
            }
            return Object.class;
        }
        return array.getClass().getComponentType();
    }

    public static Object getValueFromArray(Object array, int index) {
        if (array instanceof List) {
            return ((List)array).get(index);
        }
        return Array.get(array, index);
    }

    public static int getArrayLength(Object array) {
        if (array instanceof List) {
            return ((List)array).size();
        }
        if (array != null) {
            return Array.getLength(array);
        }
        return 0;
    }

    public static void setInArray(Object array, int index, Object value) {
        if (array instanceof List) {
            ((List)array).set(index, value);
        } else {
            Array.set(array, index, value);
        }
    }

    public static Object addInArray(Object array, int index, Object value) {
        Object toReturn = array;
        if (array instanceof List) {
            ((List)array).add(index, value);
        } else {
            toReturn = ArraysUtil.mergeArrays(array, new Object[]{value}, index);
        }
        return toReturn;
    }

    public static boolean isEmpty(Object array) {
        if (array != null) {
            if (array instanceof List) {
                return ((List)array).isEmpty();
            }
            if (array.getClass().isArray()) {
                return Array.getLength(array) == 0;
            }
        }
        return false;
    }
}

