/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.basic.io;

import java.net.URL;
import java.util.Arrays;
import ro.sync.basic.util.Equaler;
import ro.sync.basic.util.URLTimestampUtil;

public class URLSetDescription {
    public URL[] locations;
    public Long[] locationTimeStamps;
    private boolean longTimestampDetectionTime = false;

    public URLSetDescription(URL[] locations) {
        this.locations = locations;
        if (locations != null) {
            long before = System.currentTimeMillis();
            this.locationTimeStamps = new Long[locations.length];
            for (int i = 0; i < locations.length; ++i) {
                this.locationTimeStamps[i] = URLTimestampUtil.getTimeStamp(locations[i]);
            }
            long after = System.currentTimeMillis();
            this.longTimestampDetectionTime = after - before > 200L;
        }
    }

    public String toString() {
        return "URLs:" + (this.locations != null ? Arrays.asList(this.locations) : null);
    }

    public boolean equals(Object obj) {
        boolean changesTookPlace = false;
        if (obj instanceof URLSetDescription) {
            URLSetDescription newDescription = (URLSetDescription)obj;
            if (!Equaler.verifyArrayEquals(this.locations, newDescription.locations)) {
                changesTookPlace = true;
            } else if (!Equaler.verifyArrayEquals(this.locationTimeStamps, newDescription.locationTimeStamps)) {
                changesTookPlace = true;
            }
        } else {
            changesTookPlace = true;
        }
        return !changesTookPlace;
    }

    public int hashCode() {
        StringBuffer buf = new StringBuffer();
        if (this.locations != null) {
            for (int i = 0; i < this.locations.length; ++i) {
                buf.append(this.locations[i]).append(this.locationTimeStamps[i]).append(",");
            }
        }
        return buf.toString().hashCode();
    }

    public boolean isLongTimestampDetectionTime() {
        return this.longTimestampDetectionTime;
    }

    public boolean hasBeenChanged() {
        boolean hasChanged = false;
        int length = this.locations.length;
        for (int i = 0; i < length; ++i) {
            if (this.locationTimeStamps[i].equals(URLTimestampUtil.getTimeStamp(this.locations[i]))) continue;
            hasChanged = true;
            break;
        }
        return hasChanged;
    }
}

