/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.basic.io;

import java.io.IOException;
import java.io.Reader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.basic.io.NonCloseableReader;

public abstract class NonCloseableReaderWrapper
extends NonCloseableReader {
    private static Logger logger = LoggerFactory.getLogger((String)NonCloseableReaderWrapper.class.getName());
    private Reader reader;

    public NonCloseableReaderWrapper() {
        this.rewind();
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        if (this.reader == null) {
            this.reader = this.createWrappedReader();
        }
        return this.reader.read(cbuf, off, len);
    }

    public abstract Reader createWrappedReader() throws IOException;

    @Override
    public void rewind() {
        this.closeCurrentReader();
    }

    protected void finalize() throws Throwable {
        this.closeCurrentReader();
        super.finalize();
    }

    private void closeCurrentReader() {
        if (this.reader != null) {
            try {
                this.reader.close();
            }
            catch (IOException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Cannot close the reader." + e, (Throwable)e);
                }
            }
            finally {
                this.reader = null;
            }
        }
    }
}

