/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.basic.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class LazyFileOutputStream
extends OutputStream {
    private FileOutputStream fos;
    private File file;
    private boolean append;
    private boolean opened = false;
    private boolean closed = false;

    public LazyFileOutputStream(String filePath) {
        this(filePath, false);
    }

    public LazyFileOutputStream(String filePath, boolean append) {
        this(new File(filePath), append);
    }

    public LazyFileOutputStream(File f) {
        this(f, false);
    }

    public LazyFileOutputStream(File file, boolean append) {
        this.file = file;
        this.append = append;
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.opened) {
            this.fos.close();
        }
        this.closed = true;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public synchronized void write(byte[] b, int offset, int len) throws IOException {
        this.ensureOpened();
        this.fos.write(b, offset, len);
    }

    @Override
    public synchronized void write(int b) throws IOException {
        this.ensureOpened();
        this.fos.write(b);
    }

    private synchronized void ensureOpened() throws IOException {
        if (this.closed) {
            throw new IOException(this.file + " has already been closed.");
        }
        if (!this.opened) {
            this.fos = new FileOutputStream(this.file.getAbsolutePath(), this.append);
            this.opened = true;
        }
    }
}

