/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.basic.charsequence;

import ro.sync.basic.charsequence.CharArraySequence;
import ro.sync.basic.charsequence.LowercaseCharSequence;

public class CharSequenceUtil {
    public static int indexOf(CharSequence sourceSeq, CharSequence targetSeq, int fromIndex) {
        if (targetSeq instanceof String && sourceSeq instanceof String) {
            return sourceSeq.toString().indexOf(targetSeq.toString(), fromIndex);
        }
        return CharSequenceUtil.indexOf(sourceSeq, 0, sourceSeq.length(), targetSeq, 0, targetSeq.length(), fromIndex);
    }

    public static int indexOf(CharSequence sourceSeq, int ch, int fromIndex) {
        int max = sourceSeq.length();
        if (fromIndex < 0) {
            fromIndex = 0;
        } else if (fromIndex >= max) {
            return -1;
        }
        for (int i = fromIndex; i < max; ++i) {
            if (sourceSeq.charAt(i) != ch) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(CharSequence sourceSeq, CharSequence targetSeq, int fromIndex) {
        if (sourceSeq instanceof String && targetSeq instanceof String) {
            return sourceSeq.toString().lastIndexOf(targetSeq.toString(), fromIndex);
        }
        return CharSequenceUtil.lastIndexOf(sourceSeq, 0, sourceSeq.length(), targetSeq, 0, targetSeq.length(), fromIndex);
    }

    private static int indexOf(CharSequence source, int sourceOffset, int sourceCount, CharSequence target, int targetOffset, int targetCount, int fromIndex) {
        if (fromIndex >= sourceCount) {
            return targetCount == 0 ? sourceCount : -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (targetCount == 0) {
            return fromIndex;
        }
        char first = target.charAt(targetOffset);
        int max = sourceOffset + (sourceCount - targetCount);
        for (int i = sourceOffset + fromIndex; i <= max; ++i) {
            if (source.charAt(i) != first) {
                while (++i <= max && source.charAt(i) != first) {
                }
            }
            if (i > max) continue;
            int j = i + 1;
            int end = j + targetCount - 1;
            int k = targetOffset + 1;
            while (j < end && source.charAt(j) == target.charAt(k)) {
                ++j;
                ++k;
            }
            if (j != end) continue;
            return i - sourceOffset;
        }
        return -1;
    }

    private static int lastIndexOf(CharSequence source, int sourceOffset, int sourceCount, CharSequence target, int targetOffset, int targetCount, int fromIndex) {
        int start;
        int rightIndex = sourceCount - targetCount;
        if (fromIndex < 0) {
            return -1;
        }
        if (fromIndex > rightIndex) {
            fromIndex = rightIndex;
        }
        if (targetCount == 0) {
            return fromIndex;
        }
        int strLastIndex = targetOffset + targetCount - 1;
        char strLastChar = target.charAt(strLastIndex);
        int min = sourceOffset + targetCount - 1;
        int i = min + fromIndex;
        block0: while (true) {
            if (i >= min && source.charAt(i) != strLastChar) {
                --i;
                continue;
            }
            if (i < min) {
                return -1;
            }
            int j = i - 1;
            start = j - (targetCount - 1);
            int k = strLastIndex - 1;
            while (j > start) {
                if (source.charAt(j--) == target.charAt(k--)) continue;
                --i;
                continue block0;
            }
            break;
        }
        return start - sourceOffset + 1;
    }

    public static CharSequence toLowerCase(CharSequence charSeq) {
        if (charSeq instanceof String) {
            return ((String)charSeq).toLowerCase();
        }
        return new LowercaseCharSequence(charSeq);
    }

    public static CharSequence trim(CharSequence charSeq) {
        if (charSeq instanceof String) {
            return charSeq.toString().trim();
        }
        return CharSequenceUtil.trim(charSeq, true, true);
    }

    public static CharSequence trim(CharSequence charSeq, boolean leftSide, boolean rightSide) {
        int st;
        int length;
        int len = length = charSeq.length();
        if (leftSide) {
            for (st = 0; st < len && charSeq.charAt(st) <= ' '; ++st) {
            }
        }
        if (rightSide) {
            while (st < len && charSeq.charAt(len - 1) <= ' ') {
                --len;
            }
        }
        return st > 0 || len < length ? charSeq.subSequence(st, len) : charSeq;
    }

    public static int hashCode(CharSequence charSeq) {
        int h = 0;
        int off = 0;
        int len = charSeq.length();
        for (int i = 0; i < len; ++i) {
            h = 31 * h + charSeq.charAt(off++);
        }
        return h;
    }

    public static int indexOf(CharSequence sourceSeq, CharSequence targetSeq) {
        return CharSequenceUtil.indexOf(sourceSeq, targetSeq, 0);
    }

    public static int lastIndexOf(CharSequence sourceSeq, CharSequence targetSeq) {
        return CharSequenceUtil.lastIndexOf(sourceSeq, targetSeq, sourceSeq.length());
    }

    public static boolean startsWith(CharSequence cs, String str) {
        if (cs instanceof String) {
            return cs.toString().startsWith(str);
        }
        return CharSequenceUtil.startsWithInternal(cs, str, 0);
    }

    private static boolean startsWithInternal(CharSequence cs, CharSequence prefix, int toffset) {
        int to = toffset;
        int po = 0;
        int pc = prefix.length();
        int len = cs.length();
        if (toffset < 0 || toffset > len - pc) {
            return false;
        }
        while (--pc >= 0) {
            if (cs.charAt(to++) == prefix.charAt(po++)) continue;
            return false;
        }
        return true;
    }

    public static boolean endsWith(CharSequence cs, String str) {
        if (cs instanceof String) {
            return cs.toString().endsWith(str);
        }
        return CharSequenceUtil.startsWithInternal(cs, str, cs.length() - str.length());
    }

    public static int indexOf(char[] source, int sourceOffset, int sourceCount, char[] target, int targetOffset, int targetCount, int fromIndex) {
        return CharSequenceUtil.indexOf((CharSequence)new CharArraySequence(source, sourceOffset, sourceOffset + sourceCount), new CharArraySequence(target, targetOffset, targetOffset + targetCount), fromIndex);
    }

    public static CharSequence getWSCharsAtStart(CharSequence s) {
        char c;
        int count = 0;
        int length = s.length();
        for (int i = 0; i < length && ((c = s.charAt(i)) == ' ' || c == '\t'); ++i) {
            ++count;
        }
        return s.subSequence(0, count);
    }

    public static int countWSCharsAtStart(CharSequence s) {
        int count = 0;
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (c == ' ' || c == '\t') {
                ++count;
                continue;
            }
            return count;
        }
        return count;
    }
}

