/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.apache.batik.bridge.AnimatableGenericSVGBridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.bridge.ErrorConstants;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.MarkerBridge;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.bridge.UnitProcessor;
import org.apache.batik.bridge.ViewBox;
import org.apache.batik.css.engine.value.Value;
import org.apache.batik.ext.awt.image.renderable.ClipRable;
import org.apache.batik.ext.awt.image.renderable.ClipRable8Bit;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.gvt.CompositeGraphicsNode;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.Marker;
import org.apache.batik.parser.UnitProcessor;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SVGMarkerElementBridge
extends AnimatableGenericSVGBridge
implements MarkerBridge,
ErrorConstants {
    protected SVGMarkerElementBridge() {
    }

    public String getLocalName() {
        return "marker";
    }

    public Marker createMarker(BridgeContext ctx, Element markerElement, Element paintedElement) {
        AffineTransform markerTxf;
        double orient;
        GVTBuilder builder = ctx.getGVTBuilder();
        CompositeGraphicsNode markerContentNode = new CompositeGraphicsNode();
        boolean hasChildren = false;
        for (Node n = markerElement.getFirstChild(); n != null; n = n.getNextSibling()) {
            Element child;
            GraphicsNode markerNode;
            if (n.getNodeType() != 1 || (markerNode = builder.build(ctx, child = (Element)n)) == null) continue;
            hasChildren = true;
            markerContentNode.getChildren().add(markerNode);
        }
        if (!hasChildren) {
            return null;
        }
        UnitProcessor.Context uctx = UnitProcessor.createContext((BridgeContext)ctx, (Element)paintedElement);
        float markerWidth = 3.0f;
        String s = markerElement.getAttributeNS(null, "markerWidth");
        if (s.length() != 0) {
            markerWidth = UnitProcessor.svgHorizontalLengthToUserSpace((String)s, (String)"markerWidth", (UnitProcessor.Context)uctx);
        }
        if (markerWidth == 0.0f) {
            return null;
        }
        float markerHeight = 3.0f;
        s = markerElement.getAttributeNS(null, "markerHeight");
        if (s.length() != 0) {
            markerHeight = UnitProcessor.svgVerticalLengthToUserSpace((String)s, (String)"markerHeight", (UnitProcessor.Context)uctx);
        }
        if (markerHeight == 0.0f) {
            return null;
        }
        boolean reverse = false;
        s = markerElement.getAttributeNS(null, "orient");
        if (s.length() == 0) {
            orient = 0.0;
        } else if ("auto".equals(s) || "auto-start-reverse".equals(s)) {
            orient = Double.NaN;
            reverse = "auto-start-reverse".equals(s);
        } else {
            try {
                orient = SVGUtilities.convertSVGNumber((String)s);
            }
            catch (NumberFormatException nfEx) {
                throw new BridgeException(ctx, markerElement, (Exception)nfEx, "attribute.malformed", new Object[]{"orient", s});
            }
        }
        Value val = CSSUtilities.getComputedStyle((Element)paintedElement, (int)52);
        float strokeWidth = val.getFloatValue();
        s = markerElement.getAttributeNS(null, "markerUnits");
        int unitsType = s.length() == 0 ? 3 : (int)SVGUtilities.parseMarkerCoordinateSystem((Element)markerElement, (String)"markerUnits", (String)s, (BridgeContext)ctx);
        if (unitsType == 3) {
            markerTxf = new AffineTransform();
            markerTxf.scale(strokeWidth, strokeWidth);
        } else {
            markerTxf = new AffineTransform();
        }
        AffineTransform preserveAspectRatioTransform = ViewBox.getPreserveAspectRatioTransform((Element)markerElement, (float)markerWidth, (float)markerHeight, (BridgeContext)ctx);
        if (preserveAspectRatioTransform == null) {
            return null;
        }
        markerTxf.concatenate(preserveAspectRatioTransform);
        markerContentNode.setTransform(markerTxf);
        if (CSSUtilities.convertOverflow((Element)markerElement)) {
            float[] offsets = CSSUtilities.convertClip((Element)markerElement);
            Rectangle2D.Float markerClip = offsets == null ? new Rectangle2D.Float(0.0f, 0.0f, strokeWidth * markerWidth, strokeWidth * markerHeight) : new Rectangle2D.Float(offsets[3], offsets[0], strokeWidth * markerWidth - offsets[1] - offsets[3], strokeWidth * markerHeight - offsets[2] - offsets[0]);
            CompositeGraphicsNode comp = new CompositeGraphicsNode();
            comp.getChildren().add(markerContentNode);
            Filter clipSrc = comp.getGraphicsNodeRable(true);
            comp.setClip((ClipRable)new ClipRable8Bit(clipSrc, (Shape)markerClip));
            markerContentNode = comp;
        }
        float refX = 0.0f;
        s = markerElement.getAttributeNS(null, "refX");
        if (s.length() != 0) {
            refX = UnitProcessor.svgHorizontalCoordinateToUserSpace((String)s, (String)"refX", (UnitProcessor.Context)uctx);
        }
        float refY = 0.0f;
        s = markerElement.getAttributeNS(null, "refY");
        if (s.length() != 0) {
            refY = UnitProcessor.svgVerticalCoordinateToUserSpace((String)s, (String)"refY", (UnitProcessor.Context)uctx);
        }
        float[] ref = new float[]{refX, refY};
        markerTxf.transform(ref, 0, ref, 0, 1);
        Marker marker = new Marker((GraphicsNode)markerContentNode, new Point2D.Float(ref[0], ref[1]), orient, reverse);
        return marker;
    }
}

