/*
 * Copyright (c) 2018 Syncro Soft SRL - All Rights Reserved.
 *
 * This file contains proprietary and confidential source code.
 * Unauthorized copying of this file, via any medium, is strictly prohibited.
 */
package org.w3c.flute.parser.selectors;

import java.util.Arrays;

/**
 * Adds a pseudo level to an array of existing levels, preserving the natural order.
 * 
 * @author dan
 *
 */
public class PseudoLevelMerger {
  /**
   * Adds a level into the array. If the level is already in the array, does nothing.
   * If the array is <code>null</code> it is reallocated.
   * 
   * @param levels Existing levels. May be <code>null</code>
   * @param pseudoLevel The pseudo level to add. 
   * @return The new levels array. Never <code>null</code>.
   */
  public static int[] addPseudoLevel(int[] levels, int pseudoLevel) {

    int idx = Arrays.binarySearch(levels, pseudoLevel);  
    if (idx < 0){
      idx = - idx - 1;
      int [] tmp = levels;
      
      levels = new int[tmp.length + 1];
      
      System.arraycopy(tmp, 0, levels, 0, idx);
      levels[idx] = pseudoLevel;
      System.arraycopy(tmp, idx, levels, idx + 1, tmp.length - idx);
    }
  
    return levels;
  }

  /**
   * Merges two sorted arrays, removing the duplicates.
   * @param levels1 The first array.
   * @param levels2 The second array.
   * 
   * @return The merged array. Never <code>null</code>.
   */
  public static int[] mergeLevels(int[] levels1, int[] levels2) {

    for (int i = 0; i < levels2.length; i++) {
      levels1 = addPseudoLevel(levels1, levels2[i]);     
    }
    
    return levels1;
  }
}
