/*
 * Copyright (c) 2000 World Wide Web Consortium,
 * (Massachusetts Institute of Technology, Institut National de
 * Recherche en Informatique et en Automatique, Keio University). All
 * Rights Reserved. This program is distributed under the W3C's Software
 * Intellectual Property License. This program is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.
 * See W3C License http://www.w3.org/Consortium/Legal/ for more details.
 *
 * $Id$
 */
package org.w3c.flute.parser.selectors;

import java.util.Map;

import org.w3c.flute.css.sac.Condition;

/**
 * This refers to [foo~='beta'], that is it matches if the value of foo contains the beta string as a token.
 * 
 * @version $Revision$
 * @author  Philippe Le Hegaret
 */
public class OneOfAttributeConditionImpl extends AttributeConditionImpl {

  /**
   * Creates a new condition.
   * 
   * @param nsURI The namespace of the attribute
   * @param localName The local name of the attribute
   * @param value The value of the attribute
   */
  public OneOfAttributeConditionImpl(String nsURI, String localName, String value) {
    super(nsURI, localName, value);
  }

  /**
   * An integer indicating the type of <code>Condition</code>.
   */
  @Override
  public short getConditionType() {
    return Condition.SAC_ONE_OF_ATTRIBUTE_CONDITION;
  }

  /**
   * @see org.w3c.flute.parser.selectors.AttributeConditionImpl#getSerialization(java.util.Map)
   */
  @Override
  public String getSerialization(Map<String, String> proxyNamespaceMapping) {
    return super.getSerialization("~=", proxyNamespaceMapping);
  }
}
