/*
 * Copyright (c) 2000 World Wide Web Consortium,
 * (Massachusetts Institute of Technology, Institut National de
 * Recherche en Informatique et en Automatique, Keio University). All
 * Rights Reserved. This program is distributed under the W3C's Software
 * Intellectual Property License. This program is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.
 * See W3C License http://www.w3.org/Consortium/Legal/ for more details.
 *
 * $Id$
 */
package org.w3c.flute.parser.selectors;

import java.util.Map;

import org.w3c.flute.css.sac.Condition;
import org.w3c.flute.css.sac.LangCondition;

/**
 * @version $Revision$
 * @author  Philippe Le Hegaret
 */
public class LangConditionImpl implements LangCondition {

  /**
   * The language code to match.
   */
  private String lang;

  /**
   * Creates a new LangConditionImpl
   * @param lang The language code to match.
   */
  public LangConditionImpl(String lang) {
    this.lang = lang;
  }

  /**
   * An integer indicating the type of <code>Condition</code>.
   */
  @Override
  public short getConditionType() {
    return Condition.SAC_LANG_CONDITION;
  }

  /**
   * Returns the language code.
   */
  @Override
  public String getLang() {
    return lang;
  }
  
  /**
   * @see org.w3c.flute.css.sac.Condition#getSerialization(java.util.Map)
   */
  @Override
  public String getSerialization(Map<String, String> proxyNamespaceMapping) {
    return ":lang(" + lang + ")";
  }
}
