/*
 * Copyright (c) 2018 Syncro Soft SRL - All Rights Reserved.
 *
 * This file contains proprietary and confidential source code.
 * Unauthorized copying of this file, via any medium, is strictly prohibited.
 */
package org.w3c.flute.parser.selectors;

import org.w3c.css.sac.Locator;

/**
 * Base-class for all the selectors that can be localized (back-mapped) 
 * into the CSS source code.
 * 
 * @author dan
 */
public abstract class AbstractLocalizableSelector {

  /**
   * The system ID of the CSS defining this selector.
   */
  private String uri;

  /**
   * The line in the CSS
   */
  private int line;

  /**
   *  The column in the CSS 
   */
  private int column;
  
  /**
   * Constructor.
   * 
   * @param locator The CSS parser locator. It is used for back-mapping. Can be <code>null</code>.
   */
  public AbstractLocalizableSelector(Locator locator) {
    if(locator != null){
      this.uri = locator.getURI();
      this.line = locator.getLineNumber();
      this.column = locator.getColumnNumber();
    }
  }

  /**
   * @return Returns the URI. Can be <code>null</code> if the URI is unknown.
   */
  public String getUri() {
    return uri;
  }

  /**
   * @return Returns the line. <code>-1</code> if unknown.
   */
  public int getLine() {
    return line;
  }

  /**
   * @return Returns the column. <code>-1</code> if unknown.
   */
  public int getColumn() {
    return column;
  }

}
