<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:xs="http://www.w3.org/2001/XMLSchema" exclude-result-prefixes="xs" version="2.0">
    <xsl:output omit-xml-declaration="yes" indent="yes"/>
    <xsl:param name="rootName">topicmeta</xsl:param>
    <xsl:param name="linktext">linktext</xsl:param>
    <xsl:param name="navtitle">navtitle</xsl:param>
    <xsl:param name="shortdesc">shortdesc</xsl:param>

    <xsl:template match="@* | node()">
        <xsl:copy>
            <xsl:apply-templates select="@* | node()"/>
        </xsl:copy>
    </xsl:template>

    <xsl:template match="*[name() = $navtitle]">
        <xsl:copy>
            <xsl:apply-templates select="@* | node()"/>
        </xsl:copy>
        <xsl:if test="not(following-sibling::*[name() = $linktext])">
            <xsl:if test="not(following-sibling::*[name() = $shortdesc])">
                <xsl:call-template name="insertEmptyShortDesc"/>
            </xsl:if>
        </xsl:if>
    </xsl:template>

    <xsl:template match="*[name() = $linktext]">
        <xsl:copy>
            <xsl:apply-templates select="@* | node()"/>
        </xsl:copy>
        <xsl:if test="not(following-sibling::*[name() = $shortdesc])">
            <xsl:call-template name="insertEmptyShortDesc"/>
        </xsl:if>
    </xsl:template>

    <xsl:template match="*[name() = $rootName]">
        <xsl:copy>
            <xsl:apply-templates select="@*"/>
            <xsl:if test="count(child::*[name() = $shortdesc]) = 0">
                <xsl:if test="count(child::*[name() = $linktext]) = 0">
                    <xsl:if test="count(child::*[name() = $navtitle]) = 0">
                        <xsl:call-template name="insertEmptyShortDesc"/>
                    </xsl:if>
                </xsl:if>
            </xsl:if>
            <xsl:apply-templates select="node()"/>
        </xsl:copy>
    </xsl:template>

    <xsl:template name="insertEmptyShortDesc">
        <xsl:element name="{$shortdesc}">
            <xsl:text>$select("Insert short description here")</xsl:text>
        </xsl:element>
    </xsl:template>

    <xsl:template match="*[name() = $shortdesc][1]">
        <xsl:copy>
            <xsl:apply-templates select="@*"/>
            <xsl:text>$select("</xsl:text>
            <xsl:if test="not(node())">
                <xsl:text>Insert short description here</xsl:text>
            </xsl:if>
            <xsl:apply-templates select="node()"/>
            <xsl:text>")</xsl:text>
        </xsl:copy>
    </xsl:template>

</xsl:stylesheet>
