<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:xs="http://www.w3.org/2001/XMLSchema"
    exclude-result-prefixes="xs util s map"
    xmlns:util="http://www.oxygenxml.com/ns/framework/extend/util"
    xmlns:s="http://www.oxygenxml.com/ns/framework/extend"
    xmlns:map="http://www.w3.org/2005/xpath-functions/map"
    version="3.0">
    
    <xd:doc xmlns:xd="http://www.oxygenxml.com/ns/doc/xsl">
        <xd:desc>
            <xd:p>Updates basic framework entries, like name, classpath, catalogs.</xd:p>
        </xd:desc>
    </xd:doc>
    
    
    <xd:doc xmlns:xd="http://www.oxygenxml.com/ns/doc/xsl">
        <xd:desc>
            <xd:p>Base framework context. Framework name updater.</xd:p>
        </xd:desc>
    </xd:doc>
    <xsl:template match="documentTypeDescriptor/field[@name='name']" mode="copy-target">
        <xsl:copy>
            <xsl:apply-templates mode="copy-target" select="@*"/>
            <xsl:sequence select="util:stringValue($script/s:name/text())"></xsl:sequence>
        </xsl:copy>
    </xsl:template>
    
    <xd:doc xmlns:xd="http://www.oxygenxml.com/ns/doc/xsl">
        <xd:desc>
            <xd:p>Base framework context. Framework description updater.</xd:p>
        </xd:desc>
    </xd:doc>
    <xsl:template match="documentTypeDescriptor/field[@name='description']" mode="copy-target">
        <xsl:copy>
            <xsl:apply-templates mode="copy-target" select="@*"/>
            <xsl:choose>
                <xsl:when test="$script/s:description">
                    <xsl:sequence select="util:stringValue($script/s:description/text())"></xsl:sequence>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:apply-templates select="node()" mode="#current"/>
                </xsl:otherwise>
            </xsl:choose>
            
        </xsl:copy>
    </xsl:template>
    
    <xd:doc xmlns:xd="http://www.oxygenxml.com/ns/doc/xsl">
        <xd:desc>
            <xd:p>Set the initial page.</xd:p>
        </xd:desc>
    </xd:doc>
    <xsl:template match="documentTypeDescriptor/field[@name='imposedInitialPage']" mode="copy-target">
        <xsl:copy>
            <xsl:apply-templates mode="copy-target" select="@*"/>
            <xsl:choose>
                <xsl:when test="$script/s:initialPage">
                    <!-- EditorSpecific actualy sets 'useImposedInitialPage' to false. There is no 'EditorSpecific' value. -->
                    <xsl:variable name="pageValue" select="if ('EditorSpecific' = $script/s:initialPage/text()) then 'Text' else $script/s:initialPage/text()"/>
                    <xsl:sequence select="util:stringValue($pageValue)"></xsl:sequence>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:apply-templates select="node()" mode="#current"/>
                </xsl:otherwise>
            </xsl:choose>
            
        </xsl:copy>
    </xsl:template>
    
    <xd:doc xmlns:xd="http://www.oxygenxml.com/ns/doc/xsl">
        <xd:desc>
            <xd:p>Set the initial page.</xd:p>
        </xd:desc>  
    </xd:doc>
    <xsl:template match="documentTypeDescriptor/field[@name='useImposedInitialPage']" mode="copy-target">
        <xsl:copy>
            <xsl:apply-templates mode="copy-target" select="@*"/>
            <xsl:choose>
                <xsl:when test="$script/s:initialPage">
                    <xsl:variable name="useImposedInitialPage" select="if ('EditorSpecific' = $script/s:initialPage/text()) then 'false' else 'true'"/>
                    
                    <Boolean><xsl:value-of select="$useImposedInitialPage"/></Boolean>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:apply-templates select="node()" mode="#current"/>
                </xsl:otherwise>
            </xsl:choose>
            
        </xsl:copy>
    </xsl:template>

    <xsl:param name="priorityMap" as="map(*)" select="map {
        'Lowest' : '1', 
        'Low' : '2',
        'Normal' : '3', 
        'High' : '4', 
        'Highest' : '5'
        }"/>
    
    <xd:doc xmlns:xd="http://www.oxygenxml.com/ns/doc/xsl">
        <xd:desc>
            <xd:p>Base framework context. Framework name updater.</xd:p>
        </xd:desc>
    </xd:doc>
    <xsl:template match="documentTypeDescriptor/field[@name='priority']" mode="copy-target">
        <xsl:copy>
            <xsl:apply-templates mode="copy-target" select="@*"/>
            <xsl:variable name="override" select="$script/s:priority/text()"/>
            <xsl:choose>
                <xsl:when test="$override and map:get($priorityMap, $override)">
                    <Integer><xsl:value-of select="map:get($priorityMap, $override)"/></Integer>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:apply-templates mode="copy-target" select="node()"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:copy>
    </xsl:template>
    
    <xd:doc xmlns:xd="http://www.oxygenxml.com/ns/doc/xsl">
        <xd:desc>
            <xd:p>Base framework context. Framework classpath updater.</xd:p>
        </xd:desc>
    </xd:doc>
    <xsl:template match="documentTypeDescriptor/field[@name='classpath']/String-array" mode="copy-target">
        <!--        
      field name="classpath">
			<String-array>
				<String>${framework}/dita.jar</String>
				<String>${framework}/resources/</String>
			</String-array>
		</field>
        -->
        
        <xsl:call-template name="updateStringPathArray">
            <xsl:with-param name="container" select="$script/s:classpath"/>
            <xsl:with-param name="relativePathRewritePolicy">url</xsl:with-param>
        </xsl:call-template>
    </xsl:template>
    
    <!-- Web resources folder-->
    <xsl:template match="documentTypeDescriptor/field[@name='webResources']/String-array" mode="copy-target">
        <!--        
      field name="webResources">
            <String-array>
                <String>${frameworkDir}/web1</String>
                <String>${frameworkDir}/web2</String>
            </String-array>
        </field>
        -->
        
        <xsl:call-template name="updateStringPathArray">
            <xsl:with-param name="container" select="$script/s:webResources"/>
            <xsl:with-param name="relativePathRewritePolicy">url</xsl:with-param>
        </xsl:call-template>
    </xsl:template>
    
    <xd:doc xmlns:xd="http://www.oxygenxml.com/ns/doc/xsl">
        <xd:desc>An empty web resource container in the base framework. Put the entries from the script instead.</xd:desc>
    </xd:doc>
    <xsl:template match="documentTypeDescriptor/field[@name='webResources']/null" mode="copy-target">
        <xsl:variable name="temp">
        <String-array>
            <xsl:if test="$script/@base and string-length($script/@base)">
                <String><xsl:value-of select="concat('${frameworkDir(',$script/@base, ')}/web')"/></String>
            </xsl:if>
        </String-array>
        </xsl:variable>
        
        <xsl:for-each select="$temp/*">
            <xsl:call-template name="updateStringPathArray">
                <xsl:with-param name="container" select="$script/s:webResources"/>
                <xsl:with-param name="relativePathRewritePolicy">url</xsl:with-param>
            </xsl:call-template>
        </xsl:for-each>
    </xsl:template>

    <xd:doc xmlns:xd="http://www.oxygenxml.com/ns/doc/xsl">
        <xd:desc>
            <xd:p>Updates a string array according to the script.</xd:p>
                <xd:p>Target:</xd:p>
            <xd:pre>
    <String-array>
       <String>${framework}/catalog.xml</String>
       <String>${configured.ditaot.dir.url}/plugins/org.dita.base/catalog-dita.xml</String>
       <String>${configured.ditaot.dir.url}/catalog-dita.xml</String>
       <String>${framework}/styleguide/catalog.xml</String>
       <String>${framework}/plugin/catalog.xml</String>
  </String-array></xd:pre>
            
           <xd:p>Script:</xd:p>
            <xd:pre>
        <addEntry path="${framework}/first.jar" position="first"/>
        <addEntry path="${framework}/last.jar" position="last"/>
        
        <removeEntry path="${framework}/refactoring/"/></xd:pre>
        </xd:desc>
        <xd:param name="container">The target to update:
        <xd:pre><String-array>
       <String>${framework}/catalog.xml</String>
       <String>${configured.ditaot.dir.url}/plugins/org.dita.base/catalog-dita.xml</String>
       <String>${configured.ditaot.dir.url}/catalog-dita.xml</String>
       <String>${framework}/styleguide/catalog.xml</String>
       <String>${framework}/plugin/catalog.xml</String>
  </String-array></xd:pre></xd:param>
        <xd:param name="relativePathRewritePolicy">
            <xd:ul>
                <xd:li>none - no rewriting</xd:li>
                <xd:li>dir - put a $frameworkDir in front.</xd:li>
                <xd:li>url - put a $framework in front.</xd:li>
            </xd:ul>
        </xd:param>
    </xd:doc>
    <xsl:template name="updateStringPathArray">
        <xsl:param name="container"></xsl:param>
        <xsl:param name="relativePathRewritePolicy">none</xsl:param>
        <xsl:copy>
            <xsl:apply-templates mode="copy-target" select="@*"/>
            
            <xsl:for-each select="$container/s:addEntry[@position='before']">
                <xsl:sequence select="util:serializePathValue(@path, $relativePathRewritePolicy)"></xsl:sequence>
            </xsl:for-each>
            
            <xsl:variable name="skipAll" select="$container/@inherit = 'none'"/>
            <xsl:if test="not($skipAll)">
                <xsl:variable name="skipped" select="util:replaceBaseWithFramework($container/s:removeEntry/xs:string(@path))"/>
               <xsl:apply-templates mode="copy-target" select="*[not(util:isSkippedEntry(text(), $skipped))]"/>
            </xsl:if>
            
            <xsl:for-each select="$container/s:addEntry[not(@position) or @position='after']">
                <xsl:sequence select="util:serializePathValue(@path, $relativePathRewritePolicy)"></xsl:sequence>
            </xsl:for-each>   
        </xsl:copy>
    </xsl:template>
    
    <xd:doc xmlns:xd="http://www.oxygenxml.com/ns/doc/xsl">
        <xd:desc>
            <xd:p>Base framework context. Framework xml catalogs updater.</xd:p>
        </xd:desc>
    </xd:doc>
    <xsl:template match="documentTypeDescriptor/field[@name='xmlCatalogs']/String-array" mode="copy-target">
        <!-- <field name="xmlCatalogs">
      <String-array>
       <String>${framework}/catalog.xml</String>
       <String>${configured.ditaot.dir.url}/plugins/org.dita.base/catalog-dita.xml</String>
       <String>${configured.ditaot.dir.url}/catalog-dita.xml</String>
       <String>${framework}/styleguide/catalog.xml</String>
       <String>${framework}/plugin/catalog.xml</String>
      </String-array>
     </field> -->
        
        <xsl:call-template name="updateStringPathArray">
            <xsl:with-param name="container" select="$script/s:xmlCatalogs"/>
            <xsl:with-param name="relativePathRewritePolicy">url</xsl:with-param>
        </xsl:call-template>
    </xsl:template>
    
    <xd:doc xmlns:xd="http://www.oxygenxml.com/ns/doc/xsl">
        <xd:desc>
            <xd:p>Base framework context. Framework templates locations updater.</xd:p>
        </xd:desc>
    </xd:doc>
    <xsl:template match="documentTypeDescriptor/field[@name='templatesLocations']/String-array" mode="copy-target">
        <!-- 
     <field name="templatesLocations">
      <String-array>
       <String>${configured.ditaot.dir}/plugins/*/template_folders/*</String>
       <String>${frameworkDir}/templates/sample-project</String>
       <String>${frameworkDir}/templates/topic</String>
       <String>${frameworkDir}/templates/topic-xsd</String>
      </String-array>
     </field>
        -->
        
        <xsl:call-template name="updateStringPathArray">
            <xsl:with-param name="container" select="$script/s:documentTemplates"/>
            <xsl:with-param name="relativePathRewritePolicy">dir</xsl:with-param>
        </xsl:call-template>
    </xsl:template>
    
    <!-- 
    
    Extension points.
    
    -->
    
    <xd:doc xmlns:xd="http://www.oxygenxml.com/ns/doc/xsl">
        <xd:desc>
            <xd:p>Maps some extension points names to a some human-friendly aliases.</xd:p>
        </xd:desc>
    </xd:doc>
    <xsl:param name="extensionAlias" as="map(*)" select="map { 
        'extensionsBundleClassName' : 'extensionsBundle', 
        'externalObjectInsertionHandler' : 'authorModeExternalObjectInsertionHandler',
        'cssStylesFilterExtension' : 'authorCssStylesFilterExtension',
        'tableSupportClassName' : 'authorTableCellSpanProvider',
        'tableCellSeparatorSupportClassName' : 'authorTableCellSepProvider',
        'tableColWidthSupportClassName' : 'authorTableColumnWidthProvider',
        'editPropertiesHandler' : 'authorEditPropertiesHandler'
        }"/>
    
    
    <xd:doc xmlns:xd="http://www.oxygenxml.com/ns/doc/xsl">
        <xd:desc>
            <xd:p>Override extension points.</xd:p>
        </xd:desc>
    </xd:doc>
    <xsl:template match="documentTypeDescriptor/field[
        @name='extensionsBundleClassName' 
        or @name='xmlNodeCustomizerExtension'
        or @name='externalObjectInsertionHandler'
        or @name='customAttributeValueEditor'
        or @name='textModeExternalObjectInsertionHandler'
        or @name='attributesValueEditor'
        or @name='cssStylesFilterExtension'
        or @name='authorSwingDndExtension'
        or @name='textSWTDndExtension'
        or @name='authorSWTDndExtension'
        or @name='schemaManagerFilterExtension'
        or @name='elementLocatorExtension'
        ] |
        documentTypeDescriptor/field[@name='authorExtensionDescriptor']/authorExtension/field[
        @name='customReferencesResolver' 
        or @name='tableSupportClassName'
        or @name='tableCellSeparatorSupportClassName'
        or @name='tableColWidthSupportClassName'
        or @name='authorExtensionStateListener'
        or @name='attributesRecognizer'
        or @name='editPropertiesHandler'
        or @name='authorActionEventHandler'
        or @name='authorImageDecorator'
        ]" mode="copy-target">
        <xsl:variable name="extensionName" select="@name"/>
        <xsl:variable name="alias" select="map:get($extensionAlias, $extensionName)"/>
        <xsl:variable name="extensionPoint" select="$script/s:extensionPoints/s:extension[@name=$extensionName or @name=$alias][1]"/>
        
        <xsl:copy>
            <xsl:apply-templates mode="copy-target" select="@*"/>
            <xsl:choose>
                <xsl:when test="$extensionPoint and string-length($extensionPoint/@value) > 0">
                    <!-- We have a value -->
                    <xsl:sequence  select="util:stringValue($extensionPoint/@value)"></xsl:sequence>
                </xsl:when>
                <xsl:when test="$extensionPoint and string-length($extensionPoint/@value) = 0">
                    <!-- We have an extension point but without a value. It's like a reset. -->
                    <null/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:apply-templates mode="copy-target" select="node()"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:copy>
    </xsl:template>
    
    <xd:doc xmlns:xd="http://www.oxygenxml.com/ns/doc/xsl">
        <xd:desc>Override parent class loader if needed.</xd:desc>
    </xd:doc>
    <xsl:template match="documentTypeDescriptor/field[@name='parentClassLoaderID']"  mode="copy-target">
        <xsl:variable name="classLoaderID" select="$script/s:classpath/@parentClassLoaderID"/>
        
        <xsl:copy>
            <xsl:apply-templates mode="copy-target" select="@*"/>
            <xsl:choose>
                <xsl:when test="$classLoaderID and string-length($classLoaderID) > 0">
                    <!-- We have a value -->
                    <xsl:sequence  select="util:stringValue($classLoaderID)"></xsl:sequence>
                </xsl:when>
                <xsl:when test="$classLoaderID and string-length($classLoaderID) = 0">
                    <!-- We have an extension point but without a value. It's like a reset. -->
                    <null/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:apply-templates mode="copy-target" select="node()"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:copy>
    </xsl:template>
    
    
    <xsl:param name="schemaTypeMap" as="map(*)" select="map {
        'dtd' : '1', 
        'xmlschema' : '2',
        'not_specified' : '0', 
        'rnc' : '3', 
        'rng' : '4', 
        'xmlschema_sch' : '5',
        'rng_sch' : '6',
        'sch' : '7',
        'nvdl' : '9',
        'json_schema' : '10',
        'json_meta_schema':11
        }"/>
    
    <xd:doc xmlns:xd="http://www.oxygenxml.com/ns/doc/xsl">
        <xd:desc>Set default schema.</xd:desc>
    </xd:doc>
    <xsl:template match="documentTypeDescriptor/field[@name='schemaDescriptor']"  mode="copy-target">
        <xsl:variable name="defaultSchema" select="$script/s:defaultSchema"/>
        <xsl:choose>
            <xsl:when test="$defaultSchema">
                <xsl:copy>
                    <xsl:apply-templates mode="copy-target" select="@*"/>
                    <xsl:call-template name="generateDefaultSchema">
                        <xsl:with-param name="defaultSchema" select="$defaultSchema"></xsl:with-param>
                    </xsl:call-template>
                </xsl:copy>
            </xsl:when>
            <xsl:otherwise>
                <xsl:copy>
                    <xsl:apply-templates mode="copy-target" select="@* | *"/>
                </xsl:copy>
            </xsl:otherwise>
        </xsl:choose>
        
    </xsl:template>
    
    <xd:doc xmlns:xd="http://www.oxygenxml.com/ns/doc/xsl">
        <xd:desc>Set default schema.</xd:desc>
        <xd:param name="defaultSchema">The default schema element.</xd:param>
    </xd:doc>
    <xsl:template name="generateDefaultSchema">
        <xsl:param name="defaultSchema"/>
        
        <xsl:variable name="defaultSchemaType">
            <xsl:choose>
                <xsl:when test="$defaultSchema/@schemaType">
                    <xsl:value-of select="map:get($schemaTypeMap, $defaultSchema/@schemaType)"/>
                </xsl:when>
                <!-- Not specified. -->
                <xsl:otherwise>0</xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <docTypeSchema>
            <field name="type">
                <Integer><xsl:value-of select="$defaultSchemaType"/></Integer>
            </field>
            <field name="uri">
                <String><xsl:value-of select="util:serializePathValue($defaultSchema/@href, 'url')"/></String>
            </field>
        </docTypeSchema>
    
    </xsl:template>
    
</xsl:stylesheet>