/*
 * Decompiled with CFR 0.152.
 */
package org.json.oxygen;

import org.json.JSONObject;
import org.json.XML;
import org.json.XMLParserConfiguration;
import org.json.oxygen.JSONConversionOptions;
import org.json.oxygen.JSONUtil;

public final class JSONSchemaUtil {
    public static final String PROPERTIES = "properties";
    public static final String PROPERTY = "property";
    public static final String DEFINITIONS = "definitions";
    public static final String DEFINITION = "definition";
    public static final String PATTERN_PROPERTIES = "patternProperties";
    public static final String PATTERN_PROPERTY = "patternProperty";
    public static final String NAME = "name";
    public static final String VALUE = "value";
    public static final String SCHEMA = "schema";
    public static final String TOP_PROPERTIES = "topProperties";
    public static final String QUOTE = "&quot;";

    private JSONSchemaUtil() {
        throw new UnsupportedOperationException("Instantiation of this utility class is not allowed!");
    }

    public static void appendJsonSchemaProperties(StringBuilder sb, JSONObject jo, String key, JSONConversionOptions options) {
        JSONObject properties = jo.optJSONObject(key);
        sb.append('<').append(key).append('>');
        for (String property : properties.keySet()) {
            options.setJsonLocation(jo.getLocation(JSONUtil.unescapeXMLTagName(key)));
            if (PROPERTIES.equals(key)) {
                sb.append('<').append(PROPERTY).append(' ').append(NAME).append('=').append(JSONUtil.getQuotedString(XML.escape(property).replace("\"", QUOTE))).append('>').append(XML.toString(properties.get(property), null, XMLParserConfiguration.ORIGINAL, 0, 0, options)).append("</").append(PROPERTY).append('>');
                continue;
            }
            if (DEFINITIONS.equals(key)) {
                sb.append('<').append(DEFINITION).append(' ').append(NAME).append('=').append(JSONUtil.getQuotedString(XML.escape(property))).append('>').append(XML.toString(properties.get(property), null, XMLParserConfiguration.ORIGINAL, 0, 0, options)).append("</").append(DEFINITION).append('>');
                continue;
            }
            if (!PATTERN_PROPERTIES.equals(key)) continue;
            sb.append('<').append(PATTERN_PROPERTY).append(' ').append(VALUE).append('=').append(JSONUtil.getQuotedString(XML.escape(property))).append('>').append(XML.toString(properties.get(property), null, XMLParserConfiguration.ORIGINAL, 0, 0, options)).append("</").append(PATTERN_PROPERTY).append('>');
        }
        sb.append("</").append(key).append('>');
    }

    public static void extractJsonSchemaProperties(JSONObject context) {
        if (!JSONSchemaUtil.updateJSONSchemaProperties(context, PROPERTY, NAME) && !JSONSchemaUtil.updateJSONSchemaProperties(context, DEFINITION, NAME)) {
            JSONSchemaUtil.updateJSONSchemaProperties(context, PATTERN_PROPERTY, VALUE);
        }
    }

    private static boolean updateJSONSchemaProperties(JSONObject context, String targetKey, String filterKey) {
        JSONObject properties;
        Object originalTargetKey = targetKey;
        JSONObject obj = context.optJSONObject((String)originalTargetKey);
        if (!(obj != null && obj.has(filterKey) || (obj = context.optJSONObject((String)(targetKey = (String)targetKey + "_temp"))) != null)) {
            targetKey = (String)originalTargetKey + "#1";
            obj = context.optJSONObject((String)targetKey);
        }
        if ((properties = JSONSchemaUtil.filterKey(obj, filterKey)) != null) {
            String value = obj.getString(filterKey).replace(QUOTE, "\"");
            context.put(value, properties);
            if (!obj.get(filterKey).equals(targetKey)) {
                context.remove((String)targetKey);
            }
        }
        return properties != null;
    }

    private static JSONObject filterKey(JSONObject originalObj, String keyToFilter) {
        JSONObject newObj = null;
        if (originalObj != null) {
            newObj = new JSONObject();
            for (String key : originalObj.keySet()) {
                if (key.equals(keyToFilter)) continue;
                newObj.put(key, originalObj.get(key));
            }
        }
        return newObj;
    }

    public static boolean isJSONSchemaKeyword(String key) {
        return PROPERTIES.equals(key) || DEFINITIONS.equals(key) || PATTERN_PROPERTIES.equals(key);
    }

    public static boolean isJSONRootAttributes(String tagName, String token) {
        return !(!"JSON".equals(tagName) && !"array".equals(tagName) || !TOP_PROPERTIES.equals(token) && !SCHEMA.equals(token));
    }

    public static boolean hasSerializationKeyword(JSONObject context) {
        String lastKey = context.keySet().stream().reduce((first, second) -> second).orElse(null);
        return PROPERTY.equals(lastKey) || DEFINITION.equals(lastKey) || PATTERN_PROPERTY.equals(lastKey);
    }
}

