/*
 * Decompiled with CFR 0.152.
 */
package org.everit.json.schema.loader;

import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.everit.json.schema.FormatValidator;
import org.everit.json.schema.loader.SchemaClient;
import org.everit.json.schema.loader.SchemaLoader;
import org.everit.json.schema.loader.SpecificationVersion;
import org.everit.json.schema.loader.internal.DefaultSchemaClient;
import org.everit.json.schema.regexp.JavaUtilRegexpFactory;
import org.everit.json.schema.regexp.RegexpFactory;

class LoaderConfig {
    final SchemaClient schemaClient;
    final Map<String, FormatValidator> formatValidators;
    final Map<URI, Object> schemasByURI;
    final SpecificationVersion specVersion;
    final boolean useDefaults;
    final boolean nullableSupport;
    final RegexpFactory regexpFactory;

    static LoaderConfig defaultV4Config() {
        return new LoaderConfig(new DefaultSchemaClient(), SpecificationVersion.DRAFT_4.defaultFormatValidators(), SpecificationVersion.DRAFT_4, false);
    }

    LoaderConfig(SchemaClient schemaClient, Map<String, FormatValidator> formatValidators, SpecificationVersion specVersion, boolean useDefaults) {
        this(schemaClient, formatValidators, Collections.emptyMap(), specVersion, useDefaults, false, new JavaUtilRegexpFactory());
    }

    LoaderConfig(SchemaClient schemaClient, Map<String, FormatValidator> formatValidators, Map<URI, Object> schemasByURI, SpecificationVersion specVersion, boolean useDefaults, boolean nullableSupport, RegexpFactory regexpFactory) {
        this.schemaClient = Objects.requireNonNull(schemaClient, "schemaClient cannot be null");
        this.formatValidators = Objects.requireNonNull(formatValidators, "formatValidators cannot be null");
        this.schemasByURI = schemasByURI == null ? new HashMap<URI, Object>() : schemasByURI;
        this.specVersion = Objects.requireNonNull(specVersion, "specVersion cannot be null");
        this.useDefaults = useDefaults;
        this.nullableSupport = nullableSupport;
        this.regexpFactory = Objects.requireNonNull(regexpFactory, "regexpFactory cannot be null");
    }

    SchemaLoader.SchemaLoaderBuilder initLoader() {
        SchemaLoader.SchemaLoaderBuilder loaderBuilder = SchemaLoader.builder().schemaClient(this.schemaClient).useDefaults(this.useDefaults).regexpFactory(this.regexpFactory).nullableSupport(this.nullableSupport).formatValidators(new HashMap<String, FormatValidator>(this.formatValidators));
        loaderBuilder.schemasByURI = this.schemasByURI;
        if (SpecificationVersion.DRAFT_6.equals((Object)this.specVersion)) {
            loaderBuilder.draftV6Support();
        } else if (SpecificationVersion.DRAFT_7.equals((Object)this.specVersion)) {
            loaderBuilder.draftV7Support();
        } else if (SpecificationVersion.DRAFT_2019_09.equals((Object)this.specVersion)) {
            loaderBuilder.draftV2019Support();
        } else if (SpecificationVersion.DRAFT_2020_12.equals((Object)this.specVersion)) {
            loaderBuilder.draftV2020Support();
        }
        return loaderBuilder;
    }
}

