/*
 * Decompiled with CFR 0.152.
 */
package org.everit.json.schema;

import java.io.StringWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.everit.json.schema.SchemaLocation;
import org.everit.json.schema.ToStringVisitor;
import org.everit.json.schema.ValidationException;
import org.everit.json.schema.Validator;
import org.everit.json.schema.Visitor;
import org.everit.json.schema.internal.JSONPrinter;
import org.everit.json.schema.regexp.Regexp;

public abstract class Schema {
    private final String title;
    private final String description;
    private final String id;
    @Deprecated
    protected final String schemaLocation;
    private final SchemaLocation location;
    private final Object defaultValue;
    private final Boolean nullable;
    private final Boolean readOnly;
    private final Boolean writeOnly;
    private final Boolean deprecated;
    private final Map<String, Object> unprocessedProperties;

    protected Schema(Builder<?> builder) {
        this.title = builder.title;
        this.description = builder.description;
        this.id = builder.id;
        this.schemaLocation = builder.schemaLocation == null ? null : builder.schemaLocation.toString();
        this.location = builder.schemaLocation;
        this.defaultValue = builder.defaultValue;
        this.nullable = builder.nullable;
        this.readOnly = builder.readOnly;
        this.writeOnly = builder.writeOnly;
        this.deprecated = builder.deprecated;
        this.unprocessedProperties = new HashMap<String, Object>(builder.unprocessedProperties);
    }

    public void validate(Object subject) {
        Validator.builder().build().performValidation(this, subject);
    }

    public boolean definesProperty(String field) {
        return false;
    }

    Set<Regexp> getNestedPatterns() {
        return Collections.emptySet();
    }

    List<Schema> getNestedItemSchemas() {
        return Collections.emptyList();
    }

    String[] headAndTailOfJsonPointerFragment(String pointer) {
        String remaining;
        String nextToken;
        String field = pointer.replaceFirst("^#", "").replaceFirst("^/", "");
        int firstSlashIdx = field.indexOf(47);
        if (firstSlashIdx == -1) {
            nextToken = field;
            remaining = null;
        } else {
            nextToken = field.substring(0, firstSlashIdx);
            remaining = field.substring(firstSlashIdx + 1);
        }
        return new String[]{nextToken, remaining, field};
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Schema) {
            Schema schema = (Schema)o;
            return schema.canEqual(this) && Objects.equals(this.title, schema.title) && Objects.equals(this.defaultValue, schema.defaultValue) && Objects.equals(this.description, schema.description) && Objects.equals(this.id, schema.id) && Objects.equals(this.nullable, schema.nullable) && Objects.equals(this.readOnly, schema.readOnly) && Objects.equals(this.writeOnly, schema.writeOnly) && Objects.equals(this.deprecated, schema.deprecated) && Objects.equals(this.unprocessedProperties, schema.unprocessedProperties);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.title, this.description, this.id, this.defaultValue, this.nullable, this.readOnly, this.writeOnly, this.deprecated, this.unprocessedProperties);
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public String getId() {
        return this.id;
    }

    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public SchemaLocation getLocation() {
        return this.location;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public boolean hasDefaultValue() {
        return this.defaultValue != null;
    }

    public Boolean isNullable() {
        return this.nullable;
    }

    public Boolean isReadOnly() {
        return this.readOnly;
    }

    public Boolean isWriteOnly() {
        return this.writeOnly;
    }

    public Boolean isDeprecated() {
        return this.deprecated;
    }

    public Map<String, Object> getUnprocessedProperties() {
        return Collections.unmodifiableMap(this.unprocessedProperties);
    }

    public void describeTo(JSONPrinter writer) {
        this.accept(new ToStringVisitor(writer));
    }

    void describePropertiesTo(JSONPrinter writer) {
    }

    abstract void accept(Visitor var1);

    public String toString() {
        StringWriter w = new StringWriter();
        JSONPrinter writer = new JSONPrinter(w);
        new ToStringVisitor(writer).visit(this);
        return w.getBuffer().toString();
    }

    @Deprecated
    protected ValidationException failure(String message, String keyword) {
        return new ValidationException(this, message, keyword, this.schemaLocation.toString());
    }

    @Deprecated
    protected ValidationException failure(Class<?> expectedType, Object actualValue) {
        return new ValidationException(this, expectedType, actualValue, "type", this.schemaLocation.toString());
    }

    protected boolean canEqual(Object other) {
        return other instanceof Schema;
    }

    public static abstract class Builder<S extends Schema> {
        private String title;
        private String description;
        private String id;
        private SchemaLocation schemaLocation;
        private Object defaultValue;
        private Boolean nullable = null;
        private Boolean readOnly = null;
        private Boolean writeOnly = null;
        private Boolean deprecated = null;
        public Map<String, Object> unprocessedProperties = new HashMap<String, Object>(0);

        public Builder<S> title(String title) {
            this.title = title;
            return this;
        }

        public Builder<S> description(String description) {
            this.description = description;
            return this;
        }

        public Builder<S> id(String id) {
            this.id = id;
            return this;
        }

        @Deprecated
        public Builder<S> schemaLocation(String schemaLocation) {
            return this.schemaLocation(SchemaLocation.parseURI(schemaLocation));
        }

        public Builder<S> schemaLocation(SchemaLocation location) {
            this.schemaLocation = location;
            return this;
        }

        public Builder<S> defaultValue(Object defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public Builder<S> nullable(Boolean nullable) {
            this.nullable = nullable;
            return this;
        }

        public Builder<S> readOnly(Boolean readOnly) {
            this.readOnly = readOnly;
            return this;
        }

        public Builder<S> writeOnly(Boolean writeOnly) {
            this.writeOnly = writeOnly;
            return this;
        }

        public Builder<S> deprecated(Boolean deprecated) {
            this.deprecated = deprecated;
            return this;
        }

        public Builder<S> unprocessedProperties(Map<String, Object> unprocessedProperties) {
            this.unprocessedProperties = unprocessedProperties;
            return this;
        }

        public abstract S build();
    }
}

