/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.table.properties;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.node.AuthorDocumentFragment;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.commons.table.operations.TableOperationsUtil;
import ro.sync.ecss.extensions.commons.table.properties.GuiElements;
import ro.sync.ecss.extensions.commons.table.properties.ShowTablePropertiesBaseOperation;
import ro.sync.ecss.extensions.commons.table.properties.TabInfo;
import ro.sync.ecss.extensions.commons.table.properties.TablePropertiesHelper;
import ro.sync.ecss.extensions.commons.table.properties.TableProperty;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public abstract class CALSAndHTMLShowTablePropertiesBase
extends ShowTablePropertiesBaseOperation {
    public static final String[] HORIZONTAL_ALIGN_VALUES = new String[]{"left", "right", "center", "justify", "char"};
    public static final String[] VERTICAL_ALIGN_VALUES = new String[]{"top", "middle", "bottom"};

    public CALSAndHTMLShowTablePropertiesBase(TablePropertiesHelper helper) {
        super(helper);
    }

    @Override
    protected List<TabInfo> getCategoriesAndProperties(List<Integer[]> selections) {
        TabInfo cellsInformation;
        TabInfo columnsInformation;
        TabInfo rowsInformation;
        ArrayList<TabInfo> categories = new ArrayList<TabInfo>();
        TabInfo tableInformation = this.getTableInformation(selections);
        if (tableInformation != null) {
            categories.add(tableInformation);
        }
        if ((rowsInformation = this.getRowsInformation(selections)) != null) {
            categories.add(rowsInformation);
        }
        if ((columnsInformation = this.getColumnsInformation(selections)) != null) {
            categories.add(columnsInformation);
        }
        if ((cellsInformation = this.getCellsInformation(selections)) != null) {
            categories.add(cellsInformation);
        }
        return categories;
    }

    private TabInfo getColumnsInformation(List<Integer[]> selections) {
        TabInfo columnsTabInfo = null;
        List<AuthorElement> cells = TableOperationsUtil.getTableElementsOfType(this.authorAccess, selections, 6, this.tableHelper);
        List<AuthorElement> colSpecs = this.getColSpecs(this.getCellIndexes(cells));
        List<TableProperty> attributes = this.getColumnsAttributes();
        ArrayList<TableProperty> columnsProperties = new ArrayList<TableProperty>();
        ArrayList<AuthorElement> nodes = new ArrayList<AuthorElement>();
        HashMap<TableProperty, String> commonValues = new HashMap<TableProperty, String>();
        nodes.addAll(colSpecs);
        if (!colSpecs.isEmpty()) {
            int i;
            for (i = 0; i < colSpecs.size(); ++i) {
                AuthorElement currentElement = colSpecs.get(i);
                for (int j = 0; j < attributes.size(); ++j) {
                    if (i == 0) {
                        commonValues.put(attributes.get(j), "Not computed");
                    }
                    commonValues.put(attributes.get(j), this.getCommonValue(currentElement, attributes.get(j).getAttributeName(), (String)commonValues.get(attributes.get(j))));
                }
            }
            for (i = 0; i < attributes.size(); ++i) {
                TableProperty currentAttribute = attributes.get(i);
                TableProperty tb = this.getAttrProperty(colSpecs, (String)commonValues.get(currentAttribute), currentAttribute);
                if (tb == null) continue;
                columnsProperties.add(tb);
            }
            columnsTabInfo = new TabInfo(colSpecs.size() > 1 ? "Columns" : "Column", columnsProperties, colSpecs);
            columnsTabInfo.setContextInfo(MessageFormat.format(this.authorAccess.getAuthorResourceBundle().getMessage("Affected_columns"), colSpecs.size()));
        }
        return columnsTabInfo;
    }

    private TabInfo getCellsInformation(List<Integer[]> selections) {
        TabInfo cellsTabInfo = null;
        List<AuthorElement> cells = TableOperationsUtil.getTableElementsOfType(this.authorAccess, selections, 6, this.tableHelper);
        ArrayList<TableProperty> cellsProperties = new ArrayList<TableProperty>();
        ArrayList<AuthorElement> nodes = new ArrayList<AuthorElement>();
        HashMap<TableProperty, String> commonValues = new HashMap<TableProperty, String>();
        List<TableProperty> attributes = this.getCellsAttributes();
        nodes.addAll(cells);
        if (!cells.isEmpty()) {
            int i;
            for (i = 0; i < cells.size(); ++i) {
                AuthorElement currentElement = cells.get(i);
                for (int j = 0; j < attributes.size(); ++j) {
                    if (i == 0) {
                        commonValues.put(attributes.get(j), "Not computed");
                    }
                    commonValues.put(attributes.get(j), this.getCommonValue(currentElement, attributes.get(j).getAttributeName(), (String)commonValues.get(attributes.get(j))));
                }
            }
            for (i = 0; i < attributes.size(); ++i) {
                TableProperty currentAttribute = attributes.get(i);
                TableProperty tb = this.getAttrProperty(cells, (String)commonValues.get(currentAttribute), currentAttribute);
                if (tb == null) continue;
                cellsProperties.add(tb);
            }
            cellsTabInfo = new TabInfo(cells.size() > 1 ? "Cells" : "Cell", cellsProperties, nodes);
            cellsTabInfo.setContextInfo(MessageFormat.format(this.authorAccess.getAuthorResourceBundle().getMessage("Affected_cells"), cells.size()));
        }
        return cellsTabInfo;
    }

    protected List<TableProperty> getCellsAttributes() {
        ArrayList<TableProperty> attrs = new ArrayList<TableProperty>();
        attrs.add(new TableProperty("align", "Horizontal_alignment", Arrays.asList(HORIZONTAL_ALIGN_VALUES), null, "Horizontal_alignment", GuiElements.RADIO_BUTTONS, null, true, true));
        attrs.add(new TableProperty("valign", "Vertical_alignment", Arrays.asList(VERTICAL_ALIGN_VALUES), null, "Vertical_alignment", GuiElements.RADIO_BUTTONS, null, true, true));
        attrs.add(new TableProperty("colsep", "Column_separator", Arrays.asList("0", "1"), null, "Separators", GuiElements.COMBOBOX, null, true, true));
        attrs.add(new TableProperty("rowsep", "Row_separator", Arrays.asList("0", "1"), null, "Separators", GuiElements.COMBOBOX, null, true, true));
        return attrs;
    }

    private TabInfo getRowsInformation(List<Integer[]> selections) {
        TabInfo tabInfo = null;
        ArrayList<TableProperty> rowsProperties = new ArrayList<TableProperty>();
        List<AuthorElement> collectedRows = TableOperationsUtil.getTableElementsOfType(this.authorAccess, selections, 0, this.tableHelper);
        List<TableProperty> attributesToEdit = this.getRowsAttributesToEdit();
        if (!collectedRows.isEmpty()) {
            String rowType = null;
            HashMap<TableProperty, String> commonValues = new HashMap<TableProperty, String>();
            for (int i = 0; i < collectedRows.size(); ++i) {
                AuthorElement rowElement = collectedRows.get(i);
                AuthorNode parent = rowElement.getParent();
                String currentType = null;
                if (parent.getType() == 0) {
                    if (this.tableHelper.isTableBody((AuthorElement)parent)) {
                        currentType = "Body";
                    } else if (this.tableHelper.isTableHead((AuthorElement)parent)) {
                        currentType = "Header";
                    } else if (this.tableHelper.allowsFooter() && this.tableHelper.isTableFoot((AuthorElement)parent)) {
                        currentType = "Footer";
                    }
                }
                if (rowType == null) {
                    rowType = currentType;
                } else if (!rowType.equals(currentType) && !rowType.equals("<preserve>")) {
                    rowType = "<preserve>";
                }
                for (int j = 0; j < attributesToEdit.size(); ++j) {
                    if (i == 0) {
                        commonValues.put(attributesToEdit.get(j), "Not computed");
                    }
                    String commonValue = this.getCommonValue(rowElement, attributesToEdit.get(j).getAttributeName(), (String)commonValues.get(attributesToEdit.get(j)));
                    commonValues.put(attributesToEdit.get(j), commonValue);
                }
            }
            HashMap<String, String> icons = new HashMap<String, String>();
            ArrayList<String> attrValues = new ArrayList<String>();
            attrValues.add("Header");
            attrValues.add("Body");
            icons.put("Header", "/images/table-properties/RowTypeHeader.png");
            icons.put("Body", "/images/table-properties/RowTypeBody.png");
            if (this.tableHelper.allowsFooter()) {
                attrValues.add("Footer");
                icons.put("Footer", "/images/table-properties/RowTypeFooter.png");
            }
            if (rowType != null && rowType.equals("<preserve>")) {
                attrValues.add("<preserve>");
                icons.put("<preserve>", "/images/table-properties/EmptyIcon.png");
            }
            boolean active = this.checkRowSpans(collectedRows, 4);
            rowsProperties.add(new TableProperty("rowType", "Row_type", attrValues, rowType, "Row_type", GuiElements.RADIO_BUTTONS, icons, false, active));
            for (int i = 0; i < attributesToEdit.size(); ++i) {
                TableProperty currentAttribute = attributesToEdit.get(i);
                TableProperty tb = this.getAttrProperty(collectedRows, (String)commonValues.get(currentAttribute), currentAttribute);
                if (tb == null) continue;
                rowsProperties.add(tb);
            }
        }
        if (!rowsProperties.isEmpty()) {
            tabInfo = new TabInfo(collectedRows.size() > 1 ? "Rows" : "Row", rowsProperties, collectedRows);
            tabInfo.setContextInfo(MessageFormat.format(this.authorAccess.getAuthorResourceBundle().getMessage("Affected_rows"), collectedRows.size()));
        }
        return tabInfo;
    }

    @Override
    protected boolean computeFragmentsToMoveInsideFooter(List<AuthorDocumentFragment> fragments, List<Position> offsets, TabInfo tabInfo, List<AuthorElement> nodesToModify, AuthorElement currentNode) throws AuthorOperationException {
        int offset = -1;
        boolean deleteParent = false;
        if (!this.tableHelper.isTableFoot((AuthorElement)currentNode.getParentElement())) {
            try {
                AuthorElement tableFoot = this.tableHelper.getFirstChildOfTypeFromParentWithType(currentNode, 3, 4);
                if (tableFoot == null) {
                    AuthorElement elementAncestor = TableOperationsUtil.getElementAncestor((AuthorNode)currentNode, 4, this.tableHelper);
                    List contentNodes = elementAncestor.getContentNodes();
                    for (int i = 0; i < contentNodes.size(); ++i) {
                        AuthorNode elementAncestorChild = (AuthorNode)contentNodes.get(i);
                        if (elementAncestorChild instanceof AuthorElement && this.tableHelper.getElementType((AuthorElement)elementAncestorChild) == 2) {
                            this.authorAccess.getDocumentController().insertXMLFragment(this.tableHelper.getElementTag(3), elementAncestorChild, "After");
                            break;
                        }
                        if (!(elementAncestorChild instanceof AuthorElement) || this.tableHelper.getElementType((AuthorElement)elementAncestorChild) != 1) continue;
                        this.authorAccess.getDocumentController().insertXMLFragment(this.tableHelper.getElementTag(3), elementAncestorChild, "Before");
                        break;
                    }
                    tableFoot = this.tableHelper.getFirstChildOfTypeFromParentWithType(currentNode, 3, 4);
                }
                List contentNodes = currentNode.getParentElement().getContentNodes();
                if (tabInfo.getNodes().containsAll(contentNodes)) {
                    deleteParent = true;
                }
                if (tableFoot != null) {
                    offset = tableFoot.getStartOffset() + 1;
                    Position pos = this.authorAccess.getDocumentController().createPositionInContent(offset);
                    offsets.add(pos);
                    this.processFragment(currentNode, fragments, false);
                    if (!nodesToModify.contains(currentNode)) {
                        nodesToModify.add(currentNode);
                    }
                }
            }
            catch (BadLocationException e) {
                throw new AuthorOperationException(e.getMessage(), (Throwable)e);
            }
        }
        return deleteParent;
    }

    @Override
    protected boolean computeFragmentMoveInsideHeader(List<AuthorDocumentFragment> fragments, List<Position> offsets, TabInfo tabInfo, List<AuthorElement> nodesToModify, AuthorElement currentNode) throws AuthorOperationException {
        int offset = -1;
        boolean deleteParent = false;
        if (!this.tableHelper.isTableHead((AuthorElement)currentNode.getParentElement())) {
            try {
                AuthorElement tableHead = this.tableHelper.getFirstChildOfTypeFromParentWithType(currentNode, 2, 4);
                if (tableHead == null) {
                    AuthorElement tgroupElem = TableOperationsUtil.getElementAncestor((AuthorNode)currentNode, 4, this.tableHelper);
                    ArrayList<AuthorElement> children = new ArrayList<AuthorElement>();
                    if (this.tableHelper.allowsFooter()) {
                        TableOperationsUtil.getChildElements(tgroupElem, 3, children, this.tableHelper);
                    }
                    if (children.isEmpty()) {
                        TableOperationsUtil.getChildElements(tgroupElem, 1, children, this.tableHelper);
                    }
                    if (!children.isEmpty()) {
                        this.authorAccess.getDocumentController().insertXMLFragment(this.tableHelper.getElementTag(2), ((AuthorElement)children.get(0)).getStartOffset());
                    }
                    tableHead = this.tableHelper.getFirstChildOfTypeFromParentWithType(currentNode, 2, 4);
                }
                List contentNodes = currentNode.getParentElement().getContentNodes();
                if (tabInfo.getNodes().containsAll(contentNodes)) {
                    deleteParent = true;
                }
                if (tableHead != null) {
                    offset = tableHead.getEndOffset();
                    Position pos = this.authorAccess.getDocumentController().createPositionInContent(offset);
                    offsets.add(pos);
                    this.processFragment(currentNode, fragments, true);
                    if (!nodesToModify.contains(currentNode)) {
                        nodesToModify.add(currentNode);
                    }
                }
            }
            catch (BadLocationException e) {
                throw new AuthorOperationException(e.getMessage(), (Throwable)e);
            }
        }
        return deleteParent;
    }

    @Override
    protected boolean computeFragmentsToMoveInsideBody(List<AuthorDocumentFragment> fragments, List<Position> offsets, TabInfo tabInfo, List<AuthorElement> nodesToModify, AuthorElement currentNode) throws AuthorOperationException {
        boolean deleteParent = false;
        int offset = -1;
        if (!this.tableHelper.isTableBody((AuthorElement)currentNode.getParentElement())) {
            try {
                AuthorElement tableBody = this.tableHelper.getFirstChildOfTypeFromParentWithType(currentNode, 1, 4);
                if (tableBody == null) {
                    AuthorElement elementAncestor = TableOperationsUtil.getElementAncestor((AuthorNode)currentNode, 4, this.tableHelper);
                    this.authorAccess.getDocumentController().insertXMLFragment(this.tableHelper.getElementTag(1), (AuthorNode)elementAncestor, "Inside as last child");
                    tableBody = this.tableHelper.getFirstChildOfTypeFromParentWithType(currentNode, 1, 4);
                }
                List contentNodes = currentNode.getParentElement().getContentNodes();
                if (tabInfo.getNodes().containsAll(contentNodes)) {
                    deleteParent = true;
                }
                if (tableBody != null) {
                    if (this.tableHelper.isTableHead((AuthorElement)currentNode.getParentElement())) {
                        offset = tableBody.getStartOffset() + 1;
                    } else if (this.tableHelper.isTableFoot((AuthorElement)currentNode.getParentElement())) {
                        offset = tableBody.getEndOffset();
                    }
                }
                if (offset != -1) {
                    Position pos = this.authorAccess.getDocumentController().createPositionInContent(offset);
                    offsets.add(pos);
                    this.processFragment(currentNode, fragments, false);
                    if (!nodesToModify.contains(currentNode)) {
                        nodesToModify.add(currentNode);
                    }
                }
            }
            catch (BadLocationException e) {
                throw new AuthorOperationException(e.getMessage(), (Throwable)e);
            }
        }
        return deleteParent;
    }

    protected void processFragment(AuthorElement currentNode, List<AuthorDocumentFragment> fragments, boolean moveToHeader) throws BadLocationException {
        fragments.add(this.authorAccess.getDocumentController().createDocumentFragment((AuthorNode)currentNode, true));
    }

    protected List<TableProperty> getRowsAttributesToEdit() {
        ArrayList<TableProperty> attrs = new ArrayList<TableProperty>(2);
        attrs.add(new TableProperty("valign", "Vertical_alignment", Arrays.asList(VERTICAL_ALIGN_VALUES), null, "Vertical_alignment", GuiElements.RADIO_BUTTONS, null, true, true));
        attrs.add(new TableProperty("rowsep", "Row_separator", Arrays.asList("0", "1"), null, "Separators", GuiElements.COMBOBOX, null, true, true));
        return attrs;
    }

    protected List<TableProperty> getColumnsAttributes() {
        ArrayList<TableProperty> attrs = new ArrayList<TableProperty>();
        attrs.add(new TableProperty("align", "Horizontal_alignment", Arrays.asList(HORIZONTAL_ALIGN_VALUES), null, "Horizontal_alignment", GuiElements.RADIO_BUTTONS, null, true, true));
        attrs.add(new TableProperty("colsep", "Column_separator", Arrays.asList("0", "1"), null, "Separators", GuiElements.COMBOBOX, null, true, true));
        attrs.add(new TableProperty("rowsep", "Row_separator", Arrays.asList("0", "1"), null, "Separators", GuiElements.COMBOBOX, null, true, true));
        return attrs;
    }

    protected abstract List<AuthorElement> getColSpecs(Map<AuthorElement, Set<Integer>> var1);

    protected abstract Map<AuthorElement, Set<Integer>> getCellIndexes(List<AuthorElement> var1);
}

