/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.table.operations;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.AuthorResourceBundle;
import ro.sync.ecss.extensions.commons.table.operations.TableRowsInfo;
import ro.sync.ecss.extensions.commons.ui.OKCancelDialog;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class SACustomTableRowInsertionDialog
extends OKCancelDialog {
    private JSpinner rowsSpinner;
    private JRadioButton aboveRadioButton;
    private JRadioButton belowRadioButton;

    public SACustomTableRowInsertionDialog(JFrame parentFrame, AuthorResourceBundle resourceBundle) {
        super(parentFrame, resourceBundle.getMessage("insert.table.rows.custom"), true);
        this.setOkButtonText(resourceBundle.getMessage("Insert"));
        JPanel mainPanel = new JPanel(new GridBagLayout());
        JLabel numberOfRowsLabel = new JLabel(resourceBundle.getMessage("Number_of_rows") + ":");
        GridBagConstraints gridBagConstr = new GridBagConstraints();
        gridBagConstr.gridx = 0;
        gridBagConstr.gridy = 0;
        mainPanel.add((Component)numberOfRowsLabel, gridBagConstr);
        this.rowsSpinner = new JSpinner();
        numberOfRowsLabel.setLabelFor(this.rowsSpinner);
        this.rowsSpinner.setModel(new SpinnerNumberModel(1, 1, Integer.MAX_VALUE, 1));
        this.rowsSpinner.setPreferredSize(new Dimension(110, (int)this.rowsSpinner.getPreferredSize().getHeight()));
        gridBagConstr = new GridBagConstraints();
        gridBagConstr.gridx = 1;
        gridBagConstr.gridy = 0;
        mainPanel.add((Component)this.rowsSpinner, gridBagConstr);
        JLabel positionLabel = new JLabel(resourceBundle.getMessage("Position") + ":");
        gridBagConstr = new GridBagConstraints();
        gridBagConstr.gridx = 0;
        gridBagConstr.gridy = 1;
        gridBagConstr.anchor = 17;
        mainPanel.add((Component)positionLabel, gridBagConstr);
        this.aboveRadioButton = new JRadioButton(resourceBundle.getMessage("Above"));
        this.aboveRadioButton.setSelected(false);
        this.belowRadioButton = new JRadioButton(resourceBundle.getMessage("Below"));
        this.belowRadioButton.setSelected(true);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.aboveRadioButton);
        buttonGroup.add(this.belowRadioButton);
        JPanel positionPanel = new JPanel();
        positionPanel.add(this.aboveRadioButton);
        positionPanel.add(this.belowRadioButton);
        positionLabel.setLabelFor(positionPanel);
        gridBagConstr = new GridBagConstraints();
        gridBagConstr.gridx = 1;
        gridBagConstr.gridy = 1;
        mainPanel.add((Component)positionPanel, gridBagConstr);
        this.getContentPane().add((Component)mainPanel, "Center");
        this.pack();
        this.setResizable(false);
    }

    public TableRowsInfo showDialog(TableRowsInfo previousTableRowsInfo) {
        this.initialize(previousTableRowsInfo);
        super.setVisible(true);
        TableRowsInfo tableRowInfo = null;
        if (this.getResult() == 1) {
            int rowsNumber = (Integer)this.rowsSpinner.getValue();
            boolean insertBelow = this.belowRadioButton.isSelected();
            tableRowInfo = new TableRowsInfo(rowsNumber, insertBelow);
        }
        return tableRowInfo;
    }

    private void initialize(TableRowsInfo previousTableRowsInfo) {
        if (previousTableRowsInfo == null) {
            previousTableRowsInfo = new TableRowsInfo();
        }
        this.rowsSpinner.setValue(previousTableRowsInfo.getRowsNumber());
        this.aboveRadioButton.setSelected(!previousTableRowsInfo.isInsertBelow());
        this.belowRadioButton.setSelected(previousTableRowsInfo.isInsertBelow());
    }
}

