/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.table.operations;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.AuthorResourceBundle;
import ro.sync.ecss.extensions.commons.table.operations.TableColumnsInfo;
import ro.sync.ecss.extensions.commons.ui.OKCancelDialog;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class SACustomTableColumnInsertionDialog
extends OKCancelDialog {
    private JSpinner columnsSpinner;
    private JRadioButton beforeRadioButton;
    private JRadioButton afterRadioButton;

    public SACustomTableColumnInsertionDialog(JFrame parentFrame, AuthorResourceBundle resourceBundle) {
        super(parentFrame, resourceBundle.getMessage("insert.table.columns.custom"), true);
        this.setOkButtonText(resourceBundle.getMessage("Insert"));
        JPanel mainPanel = new JPanel(new GridBagLayout());
        JLabel numberOfColumnsLabel = new JLabel(resourceBundle.getMessage("Number_of_columns") + ":");
        GridBagConstraints gridBagConstr = new GridBagConstraints();
        gridBagConstr.gridx = 0;
        gridBagConstr.gridy = 0;
        mainPanel.add((Component)numberOfColumnsLabel, gridBagConstr);
        this.columnsSpinner = new JSpinner();
        numberOfColumnsLabel.setLabelFor(this.columnsSpinner);
        this.columnsSpinner.setModel(new SpinnerNumberModel(1, 1, Integer.MAX_VALUE, 1));
        this.columnsSpinner.setPreferredSize(new Dimension(110, (int)this.columnsSpinner.getPreferredSize().getHeight()));
        gridBagConstr = new GridBagConstraints();
        gridBagConstr.gridx = 1;
        gridBagConstr.gridy = 0;
        mainPanel.add((Component)this.columnsSpinner, gridBagConstr);
        JLabel positionLabel = new JLabel(resourceBundle.getMessage("Position") + ":");
        gridBagConstr = new GridBagConstraints();
        gridBagConstr.gridx = 0;
        gridBagConstr.gridy = 1;
        gridBagConstr.anchor = 17;
        mainPanel.add((Component)positionLabel, gridBagConstr);
        this.beforeRadioButton = new JRadioButton(resourceBundle.getMessage("Before"));
        this.beforeRadioButton.setSelected(false);
        this.afterRadioButton = new JRadioButton(resourceBundle.getMessage("After"));
        this.afterRadioButton.setSelected(true);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.beforeRadioButton);
        buttonGroup.add(this.afterRadioButton);
        JPanel positionPanel = new JPanel();
        positionPanel.add(this.beforeRadioButton);
        positionPanel.add(this.afterRadioButton);
        positionLabel.setLabelFor(positionPanel);
        gridBagConstr = new GridBagConstraints();
        gridBagConstr.gridx = 1;
        gridBagConstr.gridy = 1;
        mainPanel.add((Component)positionPanel, gridBagConstr);
        this.getContentPane().add((Component)mainPanel, "Center");
        this.pack();
        this.setResizable(false);
    }

    public TableColumnsInfo showDialog(TableColumnsInfo previousTableColumnsInfo) {
        this.initialize(previousTableColumnsInfo);
        super.setVisible(true);
        TableColumnsInfo tableColumnsInfo = null;
        if (this.getResult() == 1) {
            int columnsNumber = (Integer)this.columnsSpinner.getValue();
            boolean insertAfter = this.afterRadioButton.isSelected();
            tableColumnsInfo = new TableColumnsInfo(columnsNumber, insertAfter);
        }
        return tableColumnsInfo;
    }

    private void initialize(TableColumnsInfo previousTableColumnsInfo) {
        if (previousTableColumnsInfo == null) {
            previousTableColumnsInfo = new TableColumnsInfo();
        }
        this.columnsSpinner.setValue(previousTableColumnsInfo.getColumnsNumber());
        this.beforeRadioButton.setSelected(!previousTableColumnsInfo.isInsertAfter());
        this.afterRadioButton.setSelected(previousTableColumnsInfo.isInsertAfter());
    }
}

