/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.operations;

import javax.swing.text.BadLocationException;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorOperation;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.WebappCompatible;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
@WebappCompatible
public class RenameElementOperation
implements AuthorOperation {
    public static final String ARGUMENT_ELEMENT_XPATH_LOCATION = "elementLocation";
    public static final String ARGUMENT_ELEMENT_NAME = "elementName";
    protected ArgumentDescriptor[] arguments = new ArgumentDescriptor[2];

    public RenameElementOperation() {
        ArgumentDescriptor argumentDescriptor;
        this.arguments[0] = argumentDescriptor = new ArgumentDescriptor(ARGUMENT_ELEMENT_NAME, 0, "A string representing the new elements' qualified name. To declare a new namespace, append to the qualified name the pound (#) character and the namespace declaration.");
        this.arguments[1] = argumentDescriptor = new ArgumentDescriptor(ARGUMENT_ELEMENT_XPATH_LOCATION, 2, "An XPath expression indicating the elements to be renamed.\nNote: If it is not defined then the element at the caret position will be used.");
    }

    public void doOperation(AuthorAccess authorAccess, ArgumentsMap args) throws AuthorOperationException {
        Object elementName;
        Object xpathLocation = args.getArgumentValue(ARGUMENT_ELEMENT_XPATH_LOCATION);
        AuthorNode[] nodesToRename = null;
        if (xpathLocation instanceof String && !((String)xpathLocation).trim().isEmpty()) {
            nodesToRename = authorAccess.getDocumentController().findNodesByXPath(((String)xpathLocation).trim(), true, true, true);
            if (nodesToRename.length == 0) {
                throw new AuthorOperationException("The element XPath location does not identify a node: " + xpathLocation);
            }
        } else {
            try {
                nodesToRename = new AuthorNode[]{authorAccess.getDocumentController().getNodeAtOffset(authorAccess.getEditorAccess().getCaretOffset())};
            }
            catch (BadLocationException e) {
                throw new AuthorOperationException("Cannot identify the current node", (Throwable)e);
            }
        }
        if ((elementName = args.getArgumentValue(ARGUMENT_ELEMENT_NAME)) instanceof String) {
            for (int i = 0; i < nodesToRename.length; ++i) {
                if (!(nodesToRename[i] instanceof AuthorElement)) continue;
                authorAccess.getDocumentController().renameElement((AuthorElement)nodesToRename[i], (String)elementName);
            }
        } else {
            throw new AuthorOperationException("The elements' new name/qname does not represent a valid name: " + elementName);
        }
    }

    public ArgumentDescriptor[] getArguments() {
        return this.arguments;
    }

    public String getDescription() {
        return "Renames the elements identified by the given XPath expression or the current element if no XPath is provided.";
    }
}

