/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.operations;

import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.AuthorOperation;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.WebappCompatible;
import ro.sync.ecss.extensions.api.node.AuthorDocumentFragment;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
@WebappCompatible
public class InsertOrReplaceTextOperation
implements AuthorOperation {
    private static final String ARGUMENT_NAME = "text";
    private static final ArgumentDescriptor[] ARGUMENTS = new ArgumentDescriptor[]{new ArgumentDescriptor("text", 0, "The text to be inserted"), SCHEMA_AWARE_ARGUMENT_DESCRIPTOR};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doOperation(AuthorAccess authorAccess, ArgumentsMap args) {
        block10: {
            AuthorDocumentController controller = authorAccess.getDocumentController();
            controller.beginCompoundEdit();
            boolean deleteSelection = false;
            try {
                Object argVal = args.getArgumentValue(ARGUMENT_NAME);
                if (argVal instanceof String) {
                    Object schemaAwareArgumentValue;
                    if (authorAccess.getEditorAccess().hasSelection()) {
                        deleteSelection = true;
                        authorAccess.getEditorAccess().deleteSelection();
                    }
                    if ("false".equals(schemaAwareArgumentValue = args.getArgumentValue("schemaAware"))) {
                        authorAccess.getDocumentController().insertText(authorAccess.getEditorAccess().getCaretOffset(), (String)argVal);
                    } else {
                        AuthorDocumentFragment textFragment = authorAccess.getDocumentController().createNewDocumentTextFragment((String)argVal);
                        authorAccess.getDocumentController().insertFragmentSchemaAware(authorAccess.getEditorAccess().getCaretOffset(), textFragment);
                    }
                    break block10;
                }
                throw new IllegalArgumentException("The argument value was not defined, it is " + argVal);
            }
            catch (AuthorOperationException e) {
                if (deleteSelection) {
                    controller.cancelCompoundEdit();
                }
            }
            finally {
                controller.endCompoundEdit();
            }
        }
    }

    public ArgumentDescriptor[] getArguments() {
        return ARGUMENTS;
    }

    public String getDescription() {
        return "Insert a simple text. If selection is present, the selected text will be replaced with the new one.";
    }
}

