/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.operations;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.ExecuteMultipleActionsWithExtraAskValuesOperation;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.WebappCompatible;
import ro.sync.ecss.extensions.api.editor.AuthorExtensionAskAction;
import ro.sync.ecss.extensions.commons.operations.ExecuteMultipleActionsOperation;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
@WebappCompatible
public class ExecuteMultipleWebappCompatibleActionsOperation
extends ExecuteMultipleActionsOperation
implements ExecuteMultipleActionsWithExtraAskValuesOperation {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)ExecuteMultipleWebappCompatibleActionsOperation.class.getName());

    public void doOperation(AuthorAccess authorAccess, ArgumentsMap args, List<String> asksValues) throws AuthorOperationException {
        ArrayDeque<String> asks;
        Object actionIDs = args.getArgumentValue("actionIDs");
        ArrayDeque<String> arrayDeque = asks = asksValues == null ? null : new ArrayDeque<String>(asksValues);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Asks values: " + asksValues);
        }
        List<Object> actions = this.getActions(authorAccess, actionIDs);
        for (Object action : actions) {
            if (asks != null && !asks.isEmpty() && action instanceof AuthorExtensionAskAction) {
                AuthorExtensionAskAction askAction = (AuthorExtensionAskAction)action;
                ArrayList<String> actionAsksList = new ArrayList<String>();
                int asksVariablesCount = askAction.countAsksVariables();
                if (asksVariablesCount > 0 && asksVariablesCount <= asks.size()) {
                    for (int i = 0; i < asksVariablesCount; ++i) {
                        actionAsksList.add((String)asks.removeFirst());
                    }
                }
                askAction.performActionWithValues(actionAsksList);
                continue;
            }
            authorAccess.getEditorAccess().getActionsProvider().invokeAction(action);
        }
    }

    public List<Object> getActions(AuthorAccess authorAccess, Map args) throws AuthorOperationException {
        Object actionIDs = args.get("actionIDs");
        return this.getActions(authorAccess, actionIDs);
    }
}

