/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.operations;

import java.util.ArrayList;
import java.util.List;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.AuthorReviewController;
import ro.sync.ecss.extensions.api.highlights.AuthorPersistentHighlight;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
final class ElementLocationPath {
    private final List<ElementLocationPathComponent> path = new ArrayList<ElementLocationPathComponent>();

    private ElementLocationPath() {
    }

    public List<ElementLocationPathComponent> getPath() {
        return this.path;
    }

    public String toXPath() {
        StringBuilder sb = new StringBuilder();
        for (ElementLocationPathComponent elementLocationComponent : this.path) {
            sb.append(elementLocationComponent.toXPath());
        }
        return sb.toString();
    }

    private ElementLocationPath addFront(ElementLocationPathComponent comp) {
        this.path.add(0, comp);
        return this;
    }

    public static ElementLocationPath getCurrentElementLocation(AuthorReviewController authorReviewController, AuthorElement currentElement, AuthorElement sourceElement) {
        ElementLocationPath currentElementLocation = new ElementLocationPath();
        AuthorElement tmp = currentElement;
        if (tmp.isDescendentOf((AuthorNode)sourceElement)) {
            while (tmp != sourceElement) {
                AuthorNode child;
                AuthorElement parent = (AuthorElement)tmp.getParent();
                List contentNodes = parent.getContentNodes();
                int index = 1;
                for (int i = 0; i < contentNodes.size() && (child = (AuthorNode)contentNodes.get(i)) != tmp; ++i) {
                    boolean ignoreThisNode = false;
                    if (child.getType() != 0) {
                        ignoreThisNode = true;
                    } else {
                        AuthorPersistentHighlight[] intersectingHighlights = authorReviewController.getChangeHighlights(child.getStartOffset(), child.getEndOffset());
                        if (intersectingHighlights != null) {
                            for (int j = 0; j < intersectingHighlights.length; ++j) {
                                if (intersectingHighlights[j].getType() != AuthorPersistentHighlight.PersistentHighlightType.CHANGE_DELETE || intersectingHighlights[j].getStartOffset() > child.getStartOffset() || child.getEndOffset() > intersectingHighlights[j].getEndOffset()) continue;
                                ignoreThisNode = true;
                                break;
                            }
                        }
                    }
                    if (ignoreThisNode) continue;
                    ++index;
                }
                currentElementLocation.addFront(new Child(index));
                tmp = parent;
            }
            currentElementLocation.addFront(new Child(1));
        } else {
            currentElementLocation = tmp.equals(sourceElement) ? new ElementLocationPath().addFront(new Root()) : new ElementLocationPath().addFront(new Parent());
        }
        return currentElementLocation;
    }

    public static interface ElementLocationPathComponent {
        public String toXPath();
    }

    public static class Child
    implements ElementLocationPathComponent {
        private final int index;

        public Child(int index) {
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }

        @Override
        public String toXPath() {
            return "/*[" + this.index + "]";
        }
    }

    public static class Root
    implements ElementLocationPathComponent {
        @Override
        public String toXPath() {
            return "/*";
        }
    }

    public static class Parent
    implements ElementLocationPathComponent {
        @Override
        public String toXPath() {
            return "/..";
        }
    }
}

