/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons;

import java.util.Stack;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.basic.util.NumberFormatException;
import ro.sync.basic.util.NumberParserUtil;
import ro.sync.ecss.extensions.api.link.Attr;
import ro.sync.ecss.extensions.api.link.ElementLocator;
import ro.sync.ecss.extensions.api.link.ElementLocatorException;
import ro.sync.ecss.extensions.api.link.IDTypeVerifier;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class XPointerElementLocator
extends ElementLocator {
    private static final Logger logger = LoggerFactory.getLogger((String)XPointerElementLocator.class.getName());
    private IDTypeVerifier idVerifier;
    private String[] xpointerPath;
    private Stack currentElementIndexStack = new Stack();
    private int xpointerPathDepth;
    private boolean startWithElementID = false;
    private int startElementDepth = 0;
    private int endElementDepth = 0;
    private int lastIndexInParent;

    public XPointerElementLocator(IDTypeVerifier idVerifier, String link) throws ElementLocatorException {
        super(link);
        this.idVerifier = idVerifier;
        link = link.substring("element(".length(), link.length() - 1);
        if (link != null && link.length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(link, "/", false);
            this.xpointerPath = new String[stringTokenizer.countTokens()];
            int i = 0;
            while (stringTokenizer.hasMoreTokens()) {
                this.xpointerPath[i] = stringTokenizer.nextToken();
                boolean invalidFormat = false;
                if (this.xpointerPath[i].length() == 0) {
                    invalidFormat = true;
                }
                if (i > 0) {
                    try {
                        NumberParserUtil.parseInt((String)this.xpointerPath[i]);
                    }
                    catch (NumberFormatException e) {
                        invalidFormat = true;
                    }
                }
                if (invalidFormat) {
                    throw new ElementLocatorException("Only the element() scheme is supported when locating XPointer links. Supported formats: element(elementID), element(/1/2/3), element(elemID/2/3/4).");
                }
                ++i;
            }
            if (Character.isDigit(this.xpointerPath[0].charAt(0))) {
                this.xpointerPathDepth = this.xpointerPath.length;
            } else {
                this.xpointerPathDepth = -1;
                this.startWithElementID = true;
            }
        } else {
            String errorMessage = "Syntax Error.\nThe XPointer element() scheme with no arguments is not permitted.";
            throw new ElementLocatorException(errorMessage);
        }
    }

    public void endElement(String uri, String localName, String name) {
        this.endElementDepth = this.startElementDepth--;
        this.lastIndexInParent = (Integer)this.currentElementIndexStack.pop();
    }

    public boolean startElement(String uri, String localName, String name, Attr[] atts) {
        boolean linkLocated = false;
        ++this.startElementDepth;
        if (this.endElementDepth != this.startElementDepth) {
            this.currentElementIndexStack.push(1);
        } else {
            this.currentElementIndexStack.push(this.lastIndexInParent + 1);
        }
        if (this.startWithElementID) {
            String xpointerElement = this.xpointerPath[0];
            for (int i = 0; i < atts.length; ++i) {
                if (!xpointerElement.equals(atts[i].getValue()) || !this.idVerifier.hasIDType(localName, uri, atts[i].getQName(), atts[i].getNamespace())) continue;
                this.xpointerPathDepth = this.startElementDepth + this.xpointerPath.length - 1;
                break;
            }
        }
        if (this.xpointerPathDepth == this.startElementDepth) {
            linkLocated = true;
            try {
                int stopIdx;
                int xpointerIdx = this.xpointerPath.length - 1;
                int n = stopIdx = this.startWithElementID ? 1 : 0;
                for (int stackIdx = this.currentElementIndexStack.size() - 1; xpointerIdx >= stopIdx && stackIdx >= 0; --xpointerIdx, --stackIdx) {
                    int currentElementIndex;
                    int xpointerIndex = NumberParserUtil.parseInt((String)this.xpointerPath[xpointerIdx]);
                    if (xpointerIndex == (currentElementIndex = ((Integer)this.currentElementIndexStack.get(stackIdx)).intValue())) continue;
                    linkLocated = false;
                    break;
                }
            }
            catch (NumberFormatException e) {
                logger.warn((Object)e, (Throwable)e);
            }
        }
        return linkLocated;
    }
}

