/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.jfx.media.player.video;

import java.awt.Dimension;
import javafx.animation.Animation;
import javafx.animation.FadeTransition;
import javafx.animation.Interpolator;
import javafx.animation.ParallelTransition;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.media.MediaPlayer;
import javafx.util.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.jfx.media.ErrorHandler;
import ro.sync.jfx.media.player.AbstractMediaPlayerPane;
import ro.sync.jfx.media.player.MediaPlayerPaneUtil;

public class VideoMediaPlayerPane
extends AbstractMediaPlayerPane {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)VideoMediaPlayerPane.class.getName());
    private ParallelTransition transition;

    private void stopTransitionAndPlayAnother(double value, double duration) {
        if (this.transition != null) {
            this.transition.stop();
        }
        FadeTransition bottomBarFadeTranzition = new FadeTransition();
        bottomBarFadeTranzition.setNode((Node)this.mediaBottomBar);
        bottomBarFadeTranzition.setToValue(value);
        bottomBarFadeTranzition.setDuration(Duration.millis((double)duration));
        bottomBarFadeTranzition.setInterpolator(Interpolator.EASE_OUT);
        this.transition = new ParallelTransition(new Animation[]{bottomBarFadeTranzition});
        this.transition.play();
    }

    public VideoMediaPlayerPane(MediaPlayer mp, Dimension size, ErrorHandler errorHandler) {
        super(mp, size);
        this.setOnMouseEntered((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent t) {
                VideoMediaPlayerPane.this.stopTransitionAndPlayAnother(1.0, 200.0);
            }
        });
        this.setOnMouseExited((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent t) {
                VideoMediaPlayerPane.this.stopTransitionAndPlayAnother(0.0, 800.0);
            }
        });
        mp.setOnError(() -> {
            String error;
            if (errorHandler != null && (error = MediaPlayerPaneUtil.getErrorMessage(mp)) != null) {
                errorHandler.error(error);
            }
        });
    }

    @Override
    protected void initializePlayer() {
        super.initializePlayer();
        this.mediaBottomBar.setSpacing(5.0);
    }

    @Override
    protected void updateSizes() {
        double extractedWidth = this.mp.getMedia().getWidth();
        double extractedHeight = this.mp.getMedia().getHeight();
        LOGGER.debug("media width: {}", (Object)extractedWidth);
        LOGGER.debug("media height: {}", (Object)extractedHeight);
        if (extractedWidth > 0.0 && extractedHeight > 0.0) {
            double videoScaleFactor = Math.max(extractedWidth / (double)this.size.width, extractedHeight / (double)this.size.height);
            double videoWidth = extractedWidth / videoScaleFactor;
            double videoHeight = extractedHeight / videoScaleFactor;
            double prefHeight = this.mediaBottomBar.prefHeight(videoWidth);
            this.mediaBottomBar.relocate(0.0, videoHeight - prefHeight);
            LOGGER.debug("video width {}", (Object)videoWidth);
            LOGGER.debug("video height: {}", (Object)videoHeight);
            LOGGER.debug("scaleFactor: {}", (Object)videoScaleFactor);
        }
        super.updateSizes();
    }
}

