/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.jfx.media.browser;

import java.awt.Rectangle;
import java.net.URL;
import javafx.application.Platform;
import javax.swing.JComponent;
import ro.sync.jfx.media.JFXComponent;
import ro.sync.jfx.media.browser.BrowserEventHandler;
import ro.sync.jfx.media.browser.SwingBrowserPanel;

public class BrowserComponent
implements JFXComponent {
    private final URL url;
    private SwingBrowserPanel swingBrowserPanel;
    private final BrowserEventHandler callback;

    public BrowserComponent(URL url, BrowserEventHandler callback) {
        this.url = url;
        this.callback = callback;
    }

    @Override
    public JComponent getSwingComponent(Rectangle allocation) {
        if (this.swingBrowserPanel == null) {
            this.swingBrowserPanel = new SwingBrowserPanel(false, this.callback);
            this.swingBrowserPanel.setSize(allocation.width, allocation.height);
            this.swingBrowserPanel.doLayout();
            Platform.runLater(() -> {
                if (this.swingBrowserPanel.getLoadedUrl() == null) {
                    this.swingBrowserPanel.loadURL(this.url);
                }
            });
        }
        return this.swingBrowserPanel;
    }

    @Override
    public void dispose() {
        this.swingBrowserPanel.dispose();
    }

    @Override
    public void deactivate() {
    }
}

