/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs.identity;

import org.apache.xerces.impl.xpath.XPath;
import org.apache.xerces.util.IntStack;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xs.AttributePSVI;
import org.apache.xerces.xs.ShortList;
import org.apache.xerces.xs.XSTypeDefinition;

public class XPathMatcher {
    protected String fXpathDefaultNamespace;
    protected Object fMatchedString;
    LocationPathMatcher[] lpMatchers;

    public XPathMatcher(XPath xpath) {
        XPath.LocationPath[] fLocationPaths = xpath.getLocationPaths();
        this.lpMatchers = new LocationPathMatcher[fLocationPaths.length];
        for (int i = 0; i < fLocationPaths.length; ++i) {
            this.lpMatchers[i] = new LocationPathMatcher(fLocationPaths[i]);
        }
    }

    public boolean isMatched() {
        for (LocationPathMatcher lpm : this.lpMatchers) {
            if (!lpm.isMatched()) continue;
            return true;
        }
        return false;
    }

    protected void handleContent(XSTypeDefinition type, boolean nillable, Object value, short valueType, ShortList itemValueType) {
    }

    protected void matched(Object actualValue, short valueType, ShortList itemValueType, boolean isNil) {
    }

    public void startDocumentFragment() {
        for (LocationPathMatcher lpm : this.lpMatchers) {
            lpm.reset();
        }
        this.fMatchedString = null;
    }

    public void startElement(QName element, XMLAttributes attributes) {
        for (LocationPathMatcher lpm : this.lpMatchers) {
            lpm.onStartElement(element, attributes);
        }
    }

    public void endElement(QName element, XSTypeDefinition type, boolean nillable, Object value, short valueType, ShortList itemValueType) {
        if (this.isMatched()) {
            this.handleContent(type, nillable, value, valueType, itemValueType);
        }
        for (LocationPathMatcher lpm : this.lpMatchers) {
            lpm.onEndElement();
        }
    }

    private static boolean matches(XPath.NodeTest nodeTest, QName value) {
        if (nodeTest.type == 1) {
            return nodeTest.name.equals(value);
        }
        if (nodeTest.type == 4) {
            return nodeTest.name.uri == value.uri;
        }
        return true;
    }

    public void setXPathDefaultNamespace(String xpathDefaultNamespace) {
        this.fXpathDefaultNamespace = xpathDefaultNamespace;
    }

    public class LocationPathMatcher {
        private XPath.LocationPath lp;
        private int[] indices;
        private IntStack indicesStack = new IntStack();
        private int[] nextIndices;
        private int nextSize;

        public LocationPathMatcher(XPath.LocationPath lp) {
            this.lp = lp;
            this.nextIndices = new int[lp.steps.length + 1];
            this.reset();
        }

        public void reset() {
            this.indices = new int[]{0};
            this.indicesStack.clear();
        }

        public void onStartElement(QName element, XMLAttributes attributes) {
            int i;
            this.nextSize = 0;
            for (i = 0; i < this.indices.length; ++i) {
                this.matchAtStep(this.indices[i], element, attributes);
            }
            for (i = 0; i < this.indices.length; ++i) {
                this.indicesStack.push(this.indices[i]);
            }
            this.indicesStack.push(this.indices.length);
            if (this.indices.length != this.nextSize) {
                this.indices = new int[this.nextSize];
            }
            System.arraycopy(this.nextIndices, 0, this.indices, 0, this.nextSize);
        }

        public void onEndElement() {
            int size = this.indicesStack.pop();
            if (this.indices.length != size) {
                this.indices = new int[size];
            }
            for (int i = size - 1; i >= 0; --i) {
                this.indices[i] = this.indicesStack.pop();
            }
        }

        public boolean isMatched() {
            return this.indices.length > 0 && this.indices[this.indices.length - 1] == this.lp.steps.length;
        }

        private void matchAtStep(int index, QName element, XMLAttributes attributes) {
            if (index == this.lp.steps.length) {
                return;
            }
            XPath.Step step = this.lp.steps[index];
            XPath.NodeTest nodeTest = step.nodeTest;
            if (nodeTest.name.uri == null) {
                nodeTest.name.uri = XPathMatcher.this.fXpathDefaultNamespace;
            }
            if (step.axis.type == 4) {
                this.addNextIndex(index);
                this.matchAtStep(index + 1, element, attributes);
            } else if (step.axis.type == 3 || step.axis.type == 1 && XPathMatcher.matches(step.nodeTest, element)) {
                int k;
                for (k = index + 1; k < this.lp.steps.length && this.lp.steps[k].axis.type == 3; ++k) {
                }
                if (k < this.lp.steps.length && this.lp.steps[k].axis.type == 2) {
                    int attrCount = attributes.getLength();
                    QName fQName = new QName();
                    for (int aIndex = 0; aIndex < attrCount; ++aIndex) {
                        attributes.getName(aIndex, fQName);
                        if (this.lp.steps[k].nodeTest.name.uri == null) {
                            this.lp.steps[k].nodeTest.name.uri = XPathMatcher.this.fXpathDefaultNamespace;
                        }
                        if (!XPathMatcher.matches(this.lp.steps[k].nodeTest, fQName) || k + 1 != this.lp.steps.length) continue;
                        AttributePSVI attrPSVI = (AttributePSVI)attributes.getAugmentations(aIndex).getItem("ATTRIBUTE_PSVI");
                        XPathMatcher.this.fMatchedString = attrPSVI.getActualNormalizedValue();
                        XPathMatcher.this.matched(XPathMatcher.this.fMatchedString, attrPSVI.getActualNormalizedValueType(), attrPSVI.getItemValueTypes(), false);
                    }
                } else {
                    this.addNextIndex(k);
                }
            }
        }

        private void addNextIndex(int index) {
            if (this.nextSize == 0 || this.nextIndices[this.nextSize - 1] != index) {
                this.nextIndices[this.nextSize++] = index;
            }
        }
    }
}

