/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.xerces.impl.OxygenExternalEntityTargetChecker;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.basic.util.URLUtil;

public class OxygenAllowlistExternalEntityTargetChecker
implements OxygenExternalEntityTargetChecker {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)OxygenAllowlistExternalEntityTargetChecker.class.getName());
    private List<File> allowedFolders;

    public OxygenAllowlistExternalEntityTargetChecker(List<?> allowedFolders) {
        this.allowedFolders = allowedFolders.stream().map(File.class::cast).collect(Collectors.toList());
    }

    @Override
    public boolean isAllowed(XMLResourceIdentifier entityDescription) {
        boolean allowed;
        String targetSystemId = entityDescription.getExpandedSystemId();
        try {
            URL targetUrl = new URL(targetSystemId);
            if ("file".equals(targetUrl.getProtocol())) {
                File targetFile = URLUtil.getAbsoluteFileFromFileUrl((URL)targetUrl);
                allowed = this.allowedFolders.stream().anyMatch(folder -> OxygenAllowlistExternalEntityTargetChecker.contains(folder, targetFile));
                if (!allowed) {
                    LOGGER.warn("Blocked loading external entity {}", (Object)entityDescription.getExpandedSystemId());
                }
            } else {
                allowed = true;
            }
        }
        catch (MalformedURLException e) {
            allowed = true;
        }
        return allowed;
    }

    private static boolean contains(File folder, File file) {
        return file.getAbsolutePath().startsWith(folder.getAbsolutePath());
    }
}

