/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.exml.editor.csseditor.prettyprint;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.exml.editor.csseditor.prettyprint.CSSPrettyPrinterConstants;
import ro.sync.exml.editor.csseditor.prettyprint.CSSPrettyPrinterTokenManager;
import ro.sync.exml.editor.csseditor.prettyprint.CharStream;
import ro.sync.exml.editor.csseditor.prettyprint.ErrorHandler;
import ro.sync.exml.editor.csseditor.prettyprint.Generic_CharStream;
import ro.sync.exml.editor.csseditor.prettyprint.OutputHandler;
import ro.sync.exml.editor.csseditor.prettyprint.ParseException;
import ro.sync.exml.editor.csseditor.prettyprint.Token;
import ro.sync.exml.editor.csseditor.prettyprint.TokenMgrError;

public class CSSPrettyPrinter
implements CSSPrettyPrinterConstants {
    private static Logger logger = LoggerFactory.getLogger((String)CSSPrettyPrinter.class.getName());
    private WSCommentReport emptyReport = new WSCommentReport(false, false);
    private OutputHandler outputHandler;
    String LS = "\n";
    String blockIndent = "    ";
    String masterIndent = "";
    private boolean preserveEmptyLines = false;
    boolean curlyBracketsOnNewLine = false;
    boolean addExtraLineBetweenBlocks = false;
    boolean removeComments = false;
    static final StringBuilder SPACE = new StringBuilder(" ");
    protected ErrorHandler errorHandler;
    boolean debug = false;
    private boolean addSpaceBeforePropertyValue;
    public CSSPrettyPrinterTokenManager token_source;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    private int jj_gen;
    private final int[] jj_la1 = new int[81];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private static int[] jj_la1_2;
    private static int[] jj_la1_3;
    private final JJCalls[] jj_2_rtns = new JJCalls[17];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public void setLineSeparator(String ls) {
        this.LS = ls;
    }

    public void setOutputHandler(OutputHandler outputHandler) {
        this.outputHandler = outputHandler;
    }

    public OutputHandler getOutputHandler() {
        return this.outputHandler;
    }

    private void write(Token token) throws ParseException {
        if (token != null && !token.isWrittenToOutput()) {
            this.outputHandler.write(token);
            token.setWrittenToOutput(true);
        }
    }

    private void fakeWrite(Token token) throws ParseException {
        if (token != null && !token.isWrittenToOutput()) {
            this.outputHandler.fakeWrite(token);
            token.setWrittenToOutput(true);
        }
    }

    private void write(String string) throws ParseException {
        this.outputHandler.write(string);
    }

    public CSSPrettyPrinter() {
        this((CharStream)null);
    }

    public void setErrorHandler(ErrorHandler error) {
        this.errorHandler = error;
    }

    private CharStream createCharStream(Reader reader) throws IOException {
        return new Generic_CharStream(reader, 1, 1);
    }

    private void newLine(boolean forceNewLine) throws ParseException {
        if (!(this.preserveEmptyLines && !forceNewLine || this.isEndOfFileNext())) {
            this.write(this.LS);
            this.write(this.masterIndent);
        }
    }

    private void newLine() throws ParseException {
        this.newLine(false);
    }

    private boolean isEndOfFileNext() {
        Token t = this.getToken(1);
        return t.kind == 0;
    }

    public void prettyPrintStyleSheet(Reader reader, String blockIndent, String masterIndent, boolean preserveEmptyLines, boolean curlyBracketsOnNewLine, boolean addExtraLineBetweenBlocks, boolean addSpaceBeforePropertyValue, boolean removeComments) throws IOException, ParseException {
        if (reader != null) {
            ReaderWithCounter counterReader = new ReaderWithCounter(reader);
            this.blockIndent = blockIndent;
            this.masterIndent = masterIndent;
            this.addExtraLineBetweenBlocks = addExtraLineBetweenBlocks;
            this.curlyBracketsOnNewLine = curlyBracketsOnNewLine;
            this.preserveEmptyLines = preserveEmptyLines;
            this.addSpaceBeforePropertyValue = addSpaceBeforePropertyValue;
            this.removeComments = removeComments;
            this.ReInit(this.createCharStream(counterReader));
            this.parserUnit();
            int inputCharCount = counterReader.getNonWhitespaceCharsCount();
            int outputCharCount = this.outputHandler.getNonWhitespaceCharCount();
            if (inputCharCount != outputCharCount) {
                if (logger.isDebugEnabled()) {
                    logger.debug("The number of non whitespace characters in the pretty printed content is different from the one in the input: " + outputCharCount + " != " + inputCharCount);
                }
                throw new ParseException("The CSS pretty printer cannot handle this CSS input!");
            }
        } else {
            throw new ParseException("Reader is null!");
        }
    }

    private void reportError(ParseException e) {
        if (this.errorHandler != null) {
            this.errorHandler.error(e);
        }
    }

    private void reportWarningSkipText(String text) {
        if (this.errorHandler != null && text != null) {
            this.errorHandler.warning(new ParseException("Skipping: " + text));
        }
    }

    public final boolean comment() throws ParseException {
        boolean commentConsumed = false;
        Token tw = this.jj_consume_token(5);
        if (this.removeComments) {
            this.fakeWrite(tw);
        } else {
            this.write(tw);
        }
        commentConsumed = true;
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 7: {
                    break;
                }
                default: {
                    this.jj_la1[0] = this.jj_gen;
                    break block3;
                }
            }
            tw = this.jj_consume_token(7);
            if (this.removeComments) {
                this.fakeWrite(tw);
                continue;
            }
            this.write(tw);
        }
        tw = this.jj_consume_token(6);
        if (this.removeComments) {
            this.fakeWrite(tw);
        } else {
            this.write(tw);
        }
        return commentConsumed;
    }

    public final boolean whitespace() throws ParseException {
        boolean lfConsumed = false;
        int noLFs = 0;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 1: {
                Token tw = this.jj_consume_token(1);
                tw.setWrittenToOutput(true);
                break;
            }
            case 2: {
                Token tw = this.jj_consume_token(2);
                if (this.preserveEmptyLines) {
                    noLFs = tw.image.length();
                    for (int i = 0; i < noLFs; ++i) {
                        this.write(this.LS);
                        this.write(this.masterIndent);
                    }
                }
                tw.setWrittenToOutput(true);
                lfConsumed = true;
                break;
            }
            case 3: {
                Token tw = this.jj_consume_token(3);
                tw.setWrittenToOutput(true);
                break;
            }
            default: {
                this.jj_la1[1] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return lfConsumed;
    }

    public final WSCommentReport wsOrComment_ZOM(WSPosition wspos, boolean shouldBreak, String indent) throws ParseException {
        boolean lfConsumed = false;
        boolean firstCommentOnLine = true;
        boolean commentConsumed = false;
        block4: while (this.jj_2_1(2)) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 5: {
                    if (this.preserveEmptyLines && this.outputHandler.isLastNewLine() && !this.removeComments) {
                        this.write(indent);
                    }
                    if (lfConsumed && shouldBreak) {
                        this.newLine();
                        if (!this.preserveEmptyLines && !this.removeComments) {
                            this.write(indent);
                        }
                        firstCommentOnLine = true;
                    } else if (wspos == WSPosition.WS_BEFORE || wspos == WSPosition.NONE && !firstCommentOnLine) {
                        if (this.preserveEmptyLines) {
                            if (!this.outputHandler.isLastNewLine() && !this.LS.isEmpty()) {
                                this.write(" ");
                            }
                        } else if (!this.LS.isEmpty()) {
                            this.write(" ");
                        }
                    }
                    commentConsumed = this.comment();
                    if (commentConsumed) {
                        lfConsumed = false;
                    }
                    if (firstCommentOnLine) {
                        firstCommentOnLine = false;
                    }
                    if (wspos != WSPosition.WS_AFTER) continue block4;
                    if (this.preserveEmptyLines) {
                        if (this.outputHandler.isLastNewLine() || this.LS.isEmpty()) continue block4;
                        this.write(" ");
                        continue block4;
                    }
                    if (this.LS.isEmpty()) continue block4;
                    this.write(" ");
                    continue block4;
                }
                case 1: 
                case 2: 
                case 3: {
                    boolean temp = this.whitespace();
                    lfConsumed |= temp;
                    continue block4;
                }
            }
            this.jj_la1[2] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        if (commentConsumed && !this.removeComments && shouldBreak) {
            this.newLine(!lfConsumed);
        }
        WSCommentReport r = new WSCommentReport(lfConsumed, commentConsumed);
        return r;
    }

    public final boolean wsAndOptionalComment_OOM() throws ParseException {
        boolean wsConsumed = false;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 5: {
                if (this.preserveEmptyLines) {
                    if (!this.outputHandler.isLastNewLine()) {
                        this.write(" ");
                    }
                } else {
                    this.write(" ");
                }
                this.comment();
                break;
            }
            default: {
                this.jj_la1[3] = this.jj_gen;
            }
        }
        this.whitespace();
        wsConsumed = true;
        this.wsOrComment_ZOM(WSPosition.WS_BEFORE, false, "");
        return wsConsumed;
    }

    public final void parserUnit() throws ParseException {
        boolean charsetConsumed = false;
        WSCommentReport report = this.emptyReport;
        this.outputHandler.setIndent("");
        this.write(this.masterIndent);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 75: {
                charsetConsumed = this.charset();
                break;
            }
            default: {
                this.jj_la1[4] = this.jj_gen;
            }
        }
        report = this.wsOrComment_ZOM(charsetConsumed ? WSPosition.WS_BEFORE : WSPosition.NONE, true, "");
        if (charsetConsumed && !report.isCommentConsumed()) {
            this.newLine(!report.isLfConsumed());
        }
        block18: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 8: 
                case 9: 
                case 97: {
                    break;
                }
                default: {
                    this.jj_la1[5] = this.jj_gen;
                    break block18;
                }
            }
            this.ignoreStatement();
        }
        block19: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 73: {
                    break;
                }
                default: {
                    this.jj_la1[6] = this.jj_gen;
                    break block19;
                }
            }
            this.importDeclaration();
            while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 8: 
                    case 9: 
                    case 97: {
                        break;
                    }
                    default: {
                        this.jj_la1[7] = this.jj_gen;
                        continue block19;
                    }
                }
                this.ignoreStatement();
            }
            break;
        }
        block21: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 95: {
                    break;
                }
                default: {
                    this.jj_la1[8] = this.jj_gen;
                    break block21;
                }
            }
            this.namespaceDeclaration();
            while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 8: 
                    case 9: 
                    case 97: {
                        break;
                    }
                    default: {
                        this.jj_la1[9] = this.jj_gen;
                        continue block21;
                    }
                }
                this.ignoreStatement();
            }
            break;
        }
        this.afterImportDeclaration();
        Token tw = this.jj_consume_token(0);
        this.write(tw);
    }

    public final boolean charset() throws ParseException {
        boolean charsetConsumed = false;
        try {
            Token tw = this.jj_consume_token(75);
            this.write(tw);
            charsetConsumed = true;
            this.write(" ");
            this.wsOrComment_ZOM(WSPosition.WS_AFTER, false, "");
            tw = this.jj_consume_token(47);
            this.write(tw);
            this.wsOrComment_ZOM(WSPosition.WS_BEFORE, false, "");
            tw = this.jj_consume_token(18);
            this.write(tw);
        }
        catch (Exception e) {
            this.reportError(new ParseException(e.getMessage()));
            this.skipStatement();
        }
        return charsetConsumed;
    }

    public final void afterImportDeclaration() throws ParseException {
        block9: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 24: 
                case 26: 
                case 27: 
                case 33: 
                case 48: 
                case 53: 
                case 72: {
                    this.styleRule("", false);
                    break;
                }
                case 74: {
                    this.media("");
                    break;
                }
                case 76: {
                    this.page("");
                    break;
                }
                case 96: {
                    this.fontFace();
                    break;
                }
                default: {
                    this.jj_la1[10] = this.jj_gen;
                    String ret = this.skipStatement();
                    if (ret == null || ret.length() == 0) {
                        return;
                    }
                    this.reportWarningSkipText(ret);
                }
            }
            while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 8: 
                    case 9: 
                    case 97: {
                        break;
                    }
                    default: {
                        this.jj_la1[11] = this.jj_gen;
                        continue block9;
                    }
                }
                this.ignoreStatement();
            }
            break;
        }
    }

    public final void ignoreStatement() throws ParseException {
        WSCommentReport report = this.emptyReport;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 8: {
                Token tw = this.jj_consume_token(8);
                this.write(tw);
                break;
            }
            case 9: {
                Token tw = this.jj_consume_token(9);
                this.write(tw);
                break;
            }
            case 97: {
                this.atRuleDeclaration();
                break;
            }
            default: {
                this.jj_la1[12] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        report = this.wsOrComment_ZOM(WSPosition.WS_BEFORE, true, "");
        if (!report.isCommentConsumed()) {
            this.newLine(!report.isLfConsumed());
        }
    }

    public final void importDeclaration() throws ParseException {
        WSCommentReport report = this.emptyReport;
        Token tw = this.jj_consume_token(73);
        this.write(tw);
        this.write(" ");
        this.wsOrComment_ZOM(WSPosition.WS_AFTER, false, "");
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 47: {
                tw = this.jj_consume_token(47);
                this.write(tw);
                break;
            }
            case 52: {
                tw = this.jj_consume_token(52);
                this.write(tw);
                break;
            }
            default: {
                this.jj_la1[13] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.wsOrComment_ZOM(WSPosition.WS_BEFORE, false, "");
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 28: 
            case 44: 
            case 45: 
            case 48: {
                this.media_query_list();
                break;
            }
            default: {
                this.jj_la1[14] = this.jj_gen;
            }
        }
        tw = this.jj_consume_token(18);
        this.write(tw);
        report = this.wsOrComment_ZOM(WSPosition.WS_BEFORE, true, "");
        if (!report.isCommentConsumed()) {
            this.newLine(!report.isLfConsumed());
        }
    }

    public final void namespaceDeclaration() throws ParseException {
        WSCommentReport report = this.emptyReport;
        try {
            Token tw = this.jj_consume_token(95);
            this.write(tw);
            this.write(" ");
            this.wsOrComment_ZOM(WSPosition.WS_AFTER, false, "");
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 48: {
                    tw = this.jj_consume_token(48);
                    this.write(tw);
                    this.write(" ");
                    this.wsOrComment_ZOM(WSPosition.WS_AFTER, false, "");
                    break;
                }
                default: {
                    this.jj_la1[15] = this.jj_gen;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 52: {
                    tw = this.jj_consume_token(52);
                    this.write(tw);
                    break;
                }
                case 47: {
                    tw = this.jj_consume_token(47);
                    this.write(tw);
                    break;
                }
                default: {
                    this.jj_la1[16] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            this.wsOrComment_ZOM(WSPosition.WS_BEFORE, false, "");
            tw = this.jj_consume_token(18);
            this.write(tw);
            report = this.wsOrComment_ZOM(WSPosition.WS_BEFORE, true, "");
            if (!report.isCommentConsumed()) {
                this.newLine(!report.isLfConsumed());
            }
        }
        catch (ParseException e) {
            this.reportError(e);
            this.skipStatement();
        }
    }

    public final void media(String indent) throws ParseException {
        Token tw;
        WSCommentReport report;
        block25: {
            report = this.emptyReport;
            boolean isFirstStyleRule = true;
            boolean styleRuleConsumed = false;
            tw = this.jj_consume_token(74);
            this.outputHandler.setIndent(indent);
            this.write(indent);
            this.write(tw);
            this.wsOrComment_ZOM(WSPosition.WS_BEFORE, false, "");
            this.media_query_list();
            tw = this.jj_consume_token(10);
            if (this.curlyBracketsOnNewLine) {
                if (this.preserveEmptyLines) {
                    this.newLine(!this.outputHandler.isLastNewLine());
                } else {
                    this.newLine();
                }
            } else if (!this.outputHandler.isLastNewLine()) {
                this.write(" ");
            }
            this.write(tw);
            this.outputHandler.setIndent(indent + this.blockIndent);
            report = this.wsOrComment_ZOM(WSPosition.WS_BEFORE, true, "");
            if (!report.isCommentConsumed()) {
                this.newLine(!report.isLfConsumed());
            }
            block9: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 5: 
                    case 8: 
                    case 10: 
                    case 12: 
                    case 13: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 20: 
                    case 21: 
                    case 24: 
                    case 26: 
                    case 27: 
                    case 33: 
                    case 34: 
                    case 47: 
                    case 48: 
                    case 49: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 72: 
                    case 73: 
                    case 74: 
                    case 75: 
                    case 76: 
                    case 96: 
                    case 97: 
                    case 98: 
                    case 108: 
                    case 110: 
                    case 111: {
                        break;
                    }
                    default: {
                        this.jj_la1[17] = this.jj_gen;
                        break block25;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 5: 
                    case 24: 
                    case 26: 
                    case 27: 
                    case 33: 
                    case 48: 
                    case 53: 
                    case 72: {
                        if (!isFirstStyleRule && this.addExtraLineBetweenBlocks) {
                            if (this.preserveEmptyLines) {
                                this.newLine(this.outputHandler.getNewLineBeforeCount() == 1);
                            } else {
                                this.newLine();
                            }
                        }
                        if (!(styleRuleConsumed = this.styleRule(this.blockIndent, true))) continue block9;
                        isFirstStyleRule = false;
                        continue block9;
                    }
                }
                this.jj_la1[18] = this.jj_gen;
                if (this.jj_2_2(2)) {
                    this.page(indent + this.blockIndent);
                    continue;
                }
                if (this.jj_2_3(2)) {
                    this.media(indent + this.blockIndent);
                    continue;
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 8: 
                    case 10: 
                    case 12: 
                    case 13: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 20: 
                    case 21: 
                    case 34: 
                    case 47: 
                    case 49: 
                    case 52: 
                    case 54: 
                    case 73: 
                    case 74: 
                    case 75: 
                    case 76: 
                    case 96: 
                    case 97: 
                    case 98: 
                    case 108: 
                    case 110: 
                    case 111: {
                        this.skipUnknownRule();
                        continue block9;
                    }
                }
                break;
            }
            this.jj_la1[19] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        tw = this.jj_consume_token(11);
        this.outputHandler.setIndent(indent);
        this.write(indent);
        this.write(tw);
        report = this.wsOrComment_ZOM(WSPosition.WS_BEFORE, true, "");
        if (!report.isCommentConsumed()) {
            this.newLine(!report.isLfConsumed());
        }
        if (this.addExtraLineBetweenBlocks) {
            if (this.preserveEmptyLines) {
                this.newLine(this.outputHandler.getNewLineBeforeCount() == 1);
            } else {
                this.newLine();
            }
        }
    }

    public final void media_query_list() throws ParseException {
        this.media_query();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 17: {
                    break;
                }
                default: {
                    this.jj_la1[20] = this.jj_gen;
                    break block3;
                }
            }
            Token tw = this.jj_consume_token(17);
            this.write(tw);
            this.wsOrComment_ZOM(WSPosition.WS_BEFORE, false, "");
            this.media_query();
        }
    }

    public final void media_query() throws ParseException {
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 44: 
            case 45: 
            case 48: {
                Token tw;
                block4 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 44: 
                    case 45: {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 45: {
                                tw = this.jj_consume_token(45);
                                this.write(" ");
                                this.write(tw);
                                break block4;
                            }
                            case 44: {
                                tw = this.jj_consume_token(44);
                                this.write(" ");
                                this.write(tw);
                                break block4;
                            }
                        }
                        this.jj_la1[21] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                    default: {
                        this.jj_la1[22] = this.jj_gen;
                    }
                }
                this.wsOrComment_ZOM(WSPosition.WS_BEFORE, false, "");
                tw = this.jj_consume_token(48);
                this.write(" ");
                this.write(tw);
                this.wsOrComment_ZOM(WSPosition.WS_BEFORE, false, "");
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 46: {
                            break;
                        }
                        default: {
                            this.jj_la1[23] = this.jj_gen;
                            break block0;
                        }
                    }
                    tw = this.jj_consume_token(46);
                    this.write(" ");
                    this.write(tw);
                    this.wsOrComment_ZOM(WSPosition.WS_BEFORE, false, "");
                    this.expression();
                }
            }
            case 28: {
                this.expression();
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 46: {
                            break;
                        }
                        default: {
                            this.jj_la1[24] = this.jj_gen;
                            break block0;
                        }
                    }
                    Token tw = this.jj_consume_token(46);
                    this.write(" ");
                    this.write(tw);
                    this.wsOrComment_ZOM(WSPosition.WS_BEFORE, false, "");
                    this.expression();
                }
            }
            default: {
                this.jj_la1[25] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void expression() throws ParseException {
        Token tw = this.jj_consume_token(28);
        this.write(" ");
        this.write(tw);
        this.wsOrComment_ZOM(WSPosition.WS_AFTER, false, "");
        tw = this.jj_consume_token(48);
        this.write(tw);
        this.wsOrComment_ZOM(WSPosition.WS_BEFORE, false, "");
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 33: {
                tw = this.jj_consume_token(33);
                this.write(" ");
                this.write(tw);
                this.wsOrComment_ZOM(WSPosition.WS_BEFORE, false, "");
                this.write(" ");
                this.expr();
                break;
            }
            default: {
                this.jj_la1[26] = this.jj_gen;
            }
        }
        tw = this.jj_consume_token(29);
        this.write(tw);
        this.wsOrComment_ZOM(WSPosition.WS_BEFORE, false, "");
    }

    public final void page(String indent) throws ParseException {
        WSCommentReport report = this.emptyReport;
        boolean declarationConsumed = false;
        boolean semicolonConsumed = false;
        boolean indentSemicolon = true;
        boolean addSpaceBeforeLeftCurlyBrace = false;
        Token tw = this.jj_consume_token(76);
        this.outputHandler.setIndent(indent);
        this.write(indent);
        this.write(tw);
        this.write(" ");
        this.wsOrComment_ZOM(WSPosition.WS_AFTER, false, "");
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 48: {
                tw = this.jj_consume_token(48);
                this.write(tw);
                addSpaceBeforeLeftCurlyBrace = true;
                this.wsOrComment_ZOM(WSPosition.NONE, false, "");
                break;
            }
            default: {
                this.jj_la1[27] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 33: {
                this.pseudo_page();
                addSpaceBeforeLeftCurlyBrace = true;
                break;
            }
            default: {
                this.jj_la1[28] = this.jj_gen;
            }
        }
        tw = this.jj_consume_token(10);
        if (this.curlyBracketsOnNewLine) {
            if (this.preserveEmptyLines) {
                this.newLine(!this.outputHandler.isLastNewLine());
            } else {
                this.newLine();
            }
        }
        if (addSpaceBeforeLeftCurlyBrace) {
            this.write(" ");
        }
        this.write(tw);
        this.outputHandler.setIndent(indent + this.blockIndent);
        report = this.wsOrComment_ZOM(WSPosition.WS_BEFORE, true, this.blockIndent);
        if (!report.isCommentConsumed()) {
            this.newLine(!report.isLfConsumed());
        }
        this.pageBody(indent);
        tw = this.jj_consume_token(11);
        this.outputHandler.setIndent(indent);
        this.write(indent);
        this.write(tw);
        report = this.wsOrComment_ZOM(WSPosition.WS_BEFORE, true, "");
        if (!report.isCommentConsumed()) {
            this.newLine(!report.isLfConsumed());
        }
        if (this.addExtraLineBetweenBlocks) {
            if (this.preserveEmptyLines) {
                this.newLine(this.outputHandler.getNewLineBeforeCount() == 1);
            } else {
                this.newLine();
            }
        }
    }

    public final void pageBody(String indent) throws ParseException {
        WSCommentReport report = this.emptyReport;
        boolean declarationConsumed = false;
        boolean semicolonConsumed = false;
        boolean indentSemicolon = true;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: {
                this.pageMarginBox();
                this.pageBody(indent);
                break;
            }
            default: {
                this.jj_la1[31] = this.jj_gen;
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 48: {
                        declarationConsumed = this.declaration(indent + this.blockIndent);
                        if (!declarationConsumed) break;
                        indentSemicolon = false;
                        break;
                    }
                    default: {
                        this.jj_la1[29] = this.jj_gen;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 18: {
                        Token tw = this.jj_consume_token(18);
                        if (indentSemicolon || this.preserveEmptyLines && this.outputHandler.isLastNewLine()) {
                            this.write(indent + this.blockIndent);
                        }
                        this.write(tw);
                        indentSemicolon = true;
                        semicolonConsumed = true;
                        report = this.wsOrComment_ZOM(WSPosition.WS_BEFORE, true, this.blockIndent);
                        if (!report.isCommentConsumed()) {
                            this.newLine(!report.isLfConsumed());
                        }
                        this.pageBody(indent);
                        break;
                    }
                    default: {
                        this.jj_la1[30] = this.jj_gen;
                    }
                }
                if (!declarationConsumed || semicolonConsumed) break;
                this.newLine(!report.isLfConsumed());
            }
        }
    }

    public final String pageMarginSymbol() throws ParseException {
        Token n;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 77: {
                n = this.jj_consume_token(77);
                break;
            }
            case 78: {
                n = this.jj_consume_token(78);
                break;
            }
            case 79: {
                n = this.jj_consume_token(79);
                break;
            }
            case 80: {
                n = this.jj_consume_token(80);
                break;
            }
            case 81: {
                n = this.jj_consume_token(81);
                break;
            }
            case 82: {
                n = this.jj_consume_token(82);
                break;
            }
            case 83: {
                n = this.jj_consume_token(83);
                break;
            }
            case 84: {
                n = this.jj_consume_token(84);
                break;
            }
            case 85: {
                n = this.jj_consume_token(85);
                break;
            }
            case 86: {
                n = this.jj_consume_token(86);
                break;
            }
            case 87: {
                n = this.jj_consume_token(87);
                break;
            }
            case 88: {
                n = this.jj_consume_token(88);
                break;
            }
            case 89: {
                n = this.jj_consume_token(89);
                break;
            }
            case 90: {
                n = this.jj_consume_token(90);
                break;
            }
            case 91: {
                n = this.jj_consume_token(91);
                break;
            }
            case 92: {
                n = this.jj_consume_token(92);
                break;
            }
            case 93: {
                n = this.jj_consume_token(93);
                break;
            }
            case 94: {
                n = this.jj_consume_token(94);
                break;
            }
            default: {
                this.jj_la1[32] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return n.image;
    }

    public final void pageMarginBox() throws ParseException {
        WSCommentReport report = this.emptyReport;
        boolean declarationConsumed = false;
        boolean semicolonConsumed = false;
        boolean indentSemicolon = true;
        String pms = null;
        pms = this.pageMarginSymbol();
        this.write(this.blockIndent);
        this.write(pms);
        this.write(" ");
        this.wsOrComment_ZOM(WSPosition.WS_AFTER, false, "");
        Token tw = this.jj_consume_token(10);
        if (this.curlyBracketsOnNewLine) {
            if (this.preserveEmptyLines) {
                this.newLine(!this.outputHandler.isLastNewLine());
            } else {
                this.newLine();
            }
        }
        this.write(tw);
        this.outputHandler.setIndent(this.blockIndent + this.blockIndent);
        report = this.wsOrComment_ZOM(WSPosition.WS_BEFORE, true, this.blockIndent);
        if (!report.isCommentConsumed()) {
            this.newLine(!report.isLfConsumed());
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 48: {
                declarationConsumed = this.declaration(this.blockIndent + this.blockIndent);
                if (!declarationConsumed) break;
                indentSemicolon = false;
                break;
            }
            default: {
                this.jj_la1[33] = this.jj_gen;
            }
        }
        block9: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 18: {
                    break;
                }
                default: {
                    this.jj_la1[34] = this.jj_gen;
                    break block9;
                }
            }
            report = this.emptyReport;
            tw = this.jj_consume_token(18);
            if (indentSemicolon || this.preserveEmptyLines && this.outputHandler.isLastNewLine()) {
                this.write(this.blockIndent + this.blockIndent);
            }
            this.write(tw);
            indentSemicolon = true;
            semicolonConsumed = true;
            report = this.wsOrComment_ZOM(WSPosition.WS_BEFORE, true, this.blockIndent);
            if (!report.isCommentConsumed()) {
                this.newLine(!report.isLfConsumed());
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 48: {
                    declarationConsumed = this.declaration(this.blockIndent + this.blockIndent);
                    if (!declarationConsumed) continue block9;
                    indentSemicolon = false;
                    semicolonConsumed = false;
                    continue block9;
                }
            }
            this.jj_la1[35] = this.jj_gen;
        }
        if (declarationConsumed && !semicolonConsumed) {
            this.newLine(!report.isLfConsumed());
        }
        tw = this.jj_consume_token(11);
        this.write(this.blockIndent);
        this.write(tw);
        report = this.wsOrComment_ZOM(WSPosition.WS_BEFORE, true, "");
        if (!report.isCommentConsumed()) {
            this.newLine(!report.isLfConsumed());
        }
        if (this.addExtraLineBetweenBlocks) {
            if (this.preserveEmptyLines) {
                this.newLine(this.outputHandler.getNewLineBeforeCount() == 1);
            } else {
                this.newLine();
            }
        }
    }

    public final void pseudo_page() throws ParseException {
        Token tw = this.jj_consume_token(33);
        this.write(tw);
        tw = this.jj_consume_token(48);
        this.write(tw);
        this.wsOrComment_ZOM(WSPosition.WS_AFTER, false, "");
    }

    public final void fontFace() throws ParseException {
        WSCommentReport report = this.emptyReport;
        boolean declarationConsumed = false;
        boolean semicolonConsumed = false;
        boolean indentSemicolon = true;
        try {
            Token tw = this.jj_consume_token(96);
            this.write(tw);
            this.wsOrComment_ZOM(WSPosition.WS_BEFORE, false, "");
            tw = this.jj_consume_token(10);
            if (this.curlyBracketsOnNewLine) {
                if (this.preserveEmptyLines) {
                    this.newLine(!this.outputHandler.isLastNewLine());
                } else {
                    this.newLine();
                }
            }
            if (!this.outputHandler.isLastNewLine()) {
                this.write(" ");
            }
            this.write(tw);
            this.outputHandler.setIndent(this.blockIndent);
            report = this.wsOrComment_ZOM(WSPosition.WS_BEFORE, true, this.blockIndent);
            if (!report.isCommentConsumed()) {
                this.newLine(!report.isLfConsumed());
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 48: {
                    declarationConsumed = this.declaration(this.blockIndent);
                    if (!declarationConsumed) break;
                    indentSemicolon = false;
                    break;
                }
                default: {
                    this.jj_la1[36] = this.jj_gen;
                }
            }
            block11: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 18: {
                        break;
                    }
                    default: {
                        this.jj_la1[37] = this.jj_gen;
                        break block11;
                    }
                }
                report = this.emptyReport;
                tw = this.jj_consume_token(18);
                if (indentSemicolon || this.preserveEmptyLines && this.outputHandler.isLastNewLine()) {
                    this.write(this.blockIndent);
                }
                this.write(tw);
                indentSemicolon = true;
                semicolonConsumed = true;
                report = this.wsOrComment_ZOM(WSPosition.WS_BEFORE, true, this.blockIndent);
                if (!report.isCommentConsumed()) {
                    this.newLine(!report.isLfConsumed());
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 48: {
                        declarationConsumed = this.declaration(this.blockIndent);
                        if (!declarationConsumed) continue block11;
                        indentSemicolon = false;
                        semicolonConsumed = false;
                        continue block11;
                    }
                }
                this.jj_la1[38] = this.jj_gen;
            }
            if (declarationConsumed && !semicolonConsumed) {
                this.newLine(!report.isLfConsumed());
            }
            tw = this.jj_consume_token(11);
            this.outputHandler.setIndent("");
            this.write(tw);
            report = this.wsOrComment_ZOM(WSPosition.WS_BEFORE, true, "");
            if (!report.isCommentConsumed()) {
                this.newLine(!report.isLfConsumed());
            }
            if (this.addExtraLineBetweenBlocks) {
                if (this.preserveEmptyLines) {
                    this.newLine(this.outputHandler.getNewLineBeforeCount() == 1);
                } else {
                    this.newLine();
                }
            }
        }
        catch (ParseException e) {
            this.reportError(e);
            this.skipStatement();
        }
    }

    public final void atRuleDeclaration() throws ParseException {
        Token n = this.jj_consume_token(97);
        this.write(n);
        System.out.println("1. AtRuleDecl: " + n);
        String ret = this.skipStatementNoSemicolon();
        System.out.println("2. AtRuleDecl: " + ret);
        this.reportWarningSkipText(ret);
    }

    public final void skipUnknownRule() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 97: {
                Token n = this.jj_consume_token(97);
                this.write(n);
                break;
            }
            case 8: {
                Token n = this.jj_consume_token(8);
                this.write(n);
                break;
            }
            case 75: {
                Token n = this.jj_consume_token(75);
                this.write(n);
                break;
            }
            case 17: {
                Token n = this.jj_consume_token(17);
                this.write(n);
                break;
            }
            case 12: {
                Token n = this.jj_consume_token(12);
                this.write(n);
                break;
            }
            case 96: {
                Token n = this.jj_consume_token(96);
                this.write(n);
                break;
            }
            case 110: {
                Token n = this.jj_consume_token(110);
                this.write(n);
                break;
            }
            case 98: {
                Token n = this.jj_consume_token(98);
                this.write(n);
                break;
            }
            case 73: {
                Token n = this.jj_consume_token(73);
                this.write(n);
                break;
            }
            case 13: {
                Token n = this.jj_consume_token(13);
                this.write(n);
                break;
            }
            case 10: {
                Token n = this.jj_consume_token(10);
                this.write(n);
                break;
            }
            case 74: {
                Token n = this.jj_consume_token(74);
                this.write(n);
                break;
            }
            case 34: {
                Token n = this.jj_consume_token(34);
                this.write(n);
                break;
            }
            case 49: {
                Token n = this.jj_consume_token(49);
                this.write(n);
                break;
            }
            case 76: {
                Token n = this.jj_consume_token(76);
                this.write(n);
                break;
            }
            case 54: {
                Token n = this.jj_consume_token(54);
                this.write(n);
                break;
            }
            case 47: {
                Token n = this.jj_consume_token(47);
                this.write(n);
                break;
            }
            case 108: {
                Token n = this.jj_consume_token(108);
                this.write(n);
                break;
            }
            case 52: {
                Token n = this.jj_consume_token(52);
                this.write(n);
                break;
            }
            case 18: {
                Token n = this.jj_consume_token(18);
                this.write(n);
                break;
            }
            case 15: {
                Token n = this.jj_consume_token(15);
                this.write(n);
                break;
            }
            case 19: {
                Token n = this.jj_consume_token(19);
                this.write(n);
                break;
            }
            case 20: {
                Token n = this.jj_consume_token(20);
                this.write(n);
                break;
            }
            case 21: {
                Token n = this.jj_consume_token(21);
                this.write(n);
                break;
            }
            case 16: {
                Token n = this.jj_consume_token(16);
                this.write(n);
                break;
            }
            case 111: {
                Token n = this.jj_consume_token(111);
                this.write(n);
                break;
            }
            default: {
                this.jj_la1[39] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        String ret = this.skipStatement();
        this.reportWarningSkipText(ret);
    }

    public final void combinator() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 15: {
                Token tw = this.jj_consume_token(15);
                if (this.preserveEmptyLines) {
                    if (!this.outputHandler.isLastNewLine()) {
                        this.write(" ");
                    } else {
                        this.write(this.outputHandler.getIndent());
                    }
                } else {
                    this.write(" ");
                }
                this.write(tw);
                this.write(" ");
                this.wsOrComment_ZOM(WSPosition.NONE, false, "");
                break;
            }
            case 19: {
                Token tw = this.jj_consume_token(19);
                if (this.preserveEmptyLines) {
                    if (!this.outputHandler.isLastNewLine()) {
                        this.write(" ");
                    } else {
                        this.write(this.outputHandler.getIndent());
                    }
                } else {
                    this.write(" ");
                }
                this.write(tw);
                this.write(" ");
                this.wsOrComment_ZOM(WSPosition.NONE, false, "");
                break;
            }
            case 20: {
                Token tw = this.jj_consume_token(20);
                if (this.preserveEmptyLines) {
                    if (!this.outputHandler.isLastNewLine()) {
                        this.write(" ");
                    } else {
                        this.write(this.outputHandler.getIndent());
                    }
                } else {
                    this.write(" ");
                }
                this.write(tw);
                this.write(" ");
                this.wsOrComment_ZOM(WSPosition.NONE, false, "");
                break;
            }
            case 21: {
                Token tw = this.jj_consume_token(21);
                if (this.preserveEmptyLines) {
                    if (!this.outputHandler.isLastNewLine()) {
                        this.write(" ");
                    } else {
                        this.write(this.outputHandler.getIndent());
                    }
                } else {
                    this.write(" ");
                }
                this.write(tw);
                this.write(" ");
                this.wsOrComment_ZOM(WSPosition.NONE, false, "");
                break;
            }
            default: {
                this.jj_la1[40] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void property() throws ParseException {
        Token n = this.jj_consume_token(48);
        this.write(n);
        this.wsOrComment_ZOM(WSPosition.NONE, false, "");
    }

    public final boolean styleRule(String additionalIndent, boolean inMedia) throws ParseException {
        WSCommentReport report = this.emptyReport;
        boolean declarationConsumed = false;
        boolean semicolonConsumed = false;
        boolean indentSemicolon = true;
        boolean styleRuleConsumed = false;
        String indent = this.blockIndent + additionalIndent;
        try {
            this.wsOrComment_ZOM(WSPosition.NONE, true, additionalIndent);
            this.write(additionalIndent);
            this.selectorList(additionalIndent);
            Token tw = this.jj_consume_token(10);
            if (this.curlyBracketsOnNewLine) {
                if (this.preserveEmptyLines) {
                    this.newLine(!this.outputHandler.isLastNewLine());
                    if (this.outputHandler.isLastNewLine()) {
                        this.write(additionalIndent);
                    }
                } else {
                    this.newLine();
                    this.write(additionalIndent);
                }
            } else if (!this.outputHandler.isLastNewLine()) {
                this.write(" ");
            } else if (this.preserveEmptyLines && this.outputHandler.isLastNewLine()) {
                this.write(additionalIndent);
            }
            this.write(tw);
            this.outputHandler.setIndent(additionalIndent + this.blockIndent);
            styleRuleConsumed = true;
            report = this.wsOrComment_ZOM(WSPosition.WS_BEFORE, true, indent);
            if (!report.isCommentConsumed()) {
                this.newLine(!report.isLfConsumed());
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 48: {
                    declarationConsumed = this.declaration(indent);
                    if (!declarationConsumed) break;
                    indentSemicolon = false;
                    break;
                }
                default: {
                    this.jj_la1[41] = this.jj_gen;
                }
            }
            block11: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 18: {
                        break;
                    }
                    default: {
                        this.jj_la1[42] = this.jj_gen;
                        break block11;
                    }
                }
                report = this.emptyReport;
                tw = this.jj_consume_token(18);
                if (indentSemicolon || this.preserveEmptyLines && this.outputHandler.isLastNewLine()) {
                    this.write(indent);
                }
                this.write(tw);
                indentSemicolon = true;
                semicolonConsumed = true;
                report = this.wsOrComment_ZOM(WSPosition.WS_BEFORE, true, indent);
                if (!report.isCommentConsumed()) {
                    this.newLine(!report.isLfConsumed());
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 48: {
                        declarationConsumed = this.declaration(indent);
                        if (!declarationConsumed) continue block11;
                        indentSemicolon = false;
                        semicolonConsumed = false;
                        continue block11;
                    }
                }
                this.jj_la1[43] = this.jj_gen;
            }
            if (declarationConsumed && !semicolonConsumed) {
                this.newLine(!report.isLfConsumed());
            }
            tw = this.jj_consume_token(11);
            this.outputHandler.setIndent(additionalIndent);
            this.write(additionalIndent);
            this.write(tw);
            report = this.wsOrComment_ZOM(WSPosition.WS_BEFORE, true, additionalIndent);
            if (!report.isCommentConsumed()) {
                this.newLine(!report.isLfConsumed());
            }
            if (this.addExtraLineBetweenBlocks && !inMedia) {
                if (this.preserveEmptyLines) {
                    this.newLine(this.outputHandler.getNewLineBeforeCount() == 1);
                } else {
                    this.newLine();
                }
            }
        }
        catch (TokenMgrError e) {
            this.reportWarningSkipText(this.skipStatement());
        }
        return styleRuleConsumed;
    }

    public final void selectorList(String indent) throws ParseException {
        WSCommentReport report = this.emptyReport;
        this.selector();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 17: {
                    break;
                }
                default: {
                    this.jj_la1[44] = this.jj_gen;
                    break block3;
                }
            }
            Token tw = this.jj_consume_token(17);
            this.write(tw);
            report = this.wsOrComment_ZOM(WSPosition.WS_BEFORE, true, indent);
            if (!report.isCommentConsumed()) {
                this.newLine(!report.isLfConsumed());
                this.write(indent);
            }
            this.selector();
        }
    }

    public final void selector() throws ParseException {
        block11: {
            this.simple_selector(false);
            block10: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 5: 
                    case 15: 
                    case 19: 
                    case 20: 
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[45] = this.jj_gen;
                        break block11;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 15: 
                    case 19: 
                    case 20: 
                    case 21: {
                        this.combinator();
                        this.simple_selector(false);
                        continue block10;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 5: {
                        this.wsAndOptionalComment_OOM();
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 24: 
                            case 26: 
                            case 27: 
                            case 33: 
                            case 48: 
                            case 53: 
                            case 72: {
                                this.simple_selector(true);
                                continue block10;
                            }
                        }
                        this.jj_la1[46] = this.jj_gen;
                        continue block10;
                    }
                }
                break;
            }
            this.jj_la1[47] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
    }

    public final void simple_selector(boolean precededBySpace) throws ParseException {
        boolean writeSpaceBefore = this.preserveEmptyLines ? precededBySpace && !this.outputHandler.isLastNewLine() : precededBySpace;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 26: 
            case 48: 
            case 53: {
                this.element_name(writeSpaceBefore);
                block64: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 24: 
                        case 27: 
                        case 33: 
                        case 72: {
                            break;
                        }
                        default: {
                            this.jj_la1[48] = this.jj_gen;
                            break block0;
                        }
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 72: {
                            this.hash(false);
                            continue block64;
                        }
                        case 27: {
                            this._class(false);
                            continue block64;
                        }
                        case 24: {
                            this.attrib(false);
                            continue block64;
                        }
                        case 33: {
                            if (this.jj_2_4(2)) {
                                this.negation(false);
                                continue block64;
                            }
                            if (this.jj_2_5(2)) {
                                this.pseudo(false);
                                continue block64;
                            }
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    break;
                }
                this.jj_la1[49] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            case 72: {
                this.hash(writeSpaceBefore);
                block65: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 24: 
                        case 27: 
                        case 33: {
                            break;
                        }
                        default: {
                            this.jj_la1[50] = this.jj_gen;
                            break block0;
                        }
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 27: {
                            this._class(false);
                            continue block65;
                        }
                        case 24: {
                            this.attrib(false);
                            continue block65;
                        }
                        case 33: {
                            if (this.jj_2_6(2)) {
                                this.negation(false);
                                continue block65;
                            }
                            if (this.jj_2_7(2)) {
                                this.pseudo(false);
                                continue block65;
                            }
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    break;
                }
                this.jj_la1[51] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            case 27: {
                this._class(writeSpaceBefore);
                block66: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 24: 
                        case 27: 
                        case 33: 
                        case 72: {
                            break;
                        }
                        default: {
                            this.jj_la1[52] = this.jj_gen;
                            break block0;
                        }
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 72: {
                            this.hash(false);
                            continue block66;
                        }
                        case 27: {
                            this._class(false);
                            continue block66;
                        }
                        case 24: {
                            this.attrib(false);
                            continue block66;
                        }
                        case 33: {
                            if (this.jj_2_8(2)) {
                                this.negation(false);
                                continue block66;
                            }
                            if (this.jj_2_9(2)) {
                                this.pseudo(false);
                                continue block66;
                            }
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    break;
                }
                this.jj_la1[53] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[60] = this.jj_gen;
                if (this.jj_2_16(2)) {
                    this.pseudo(writeSpaceBefore);
                    block67: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 24: 
                            case 27: 
                            case 33: 
                            case 72: {
                                break;
                            }
                            default: {
                                this.jj_la1[54] = this.jj_gen;
                                break block0;
                            }
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 72: {
                                this.hash(false);
                                continue block67;
                            }
                            case 27: {
                                this._class(false);
                                continue block67;
                            }
                            case 24: {
                                this.attrib(false);
                                continue block67;
                            }
                            case 33: {
                                if (this.jj_2_10(2)) {
                                    this.negation(false);
                                    continue block67;
                                }
                                if (this.jj_2_11(2)) {
                                    this.pseudo(false);
                                    continue block67;
                                }
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        break;
                    }
                    this.jj_la1[55] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                if (this.jj_2_17(2)) {
                    this.negation(writeSpaceBefore);
                    block68: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 24: 
                            case 27: 
                            case 33: 
                            case 72: {
                                break;
                            }
                            default: {
                                this.jj_la1[56] = this.jj_gen;
                                break block0;
                            }
                        }
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 72: {
                                this.hash(false);
                                continue block68;
                            }
                            case 27: {
                                this._class(false);
                                continue block68;
                            }
                            case 24: {
                                this.attrib(false);
                                continue block68;
                            }
                            case 33: {
                                if (this.jj_2_12(2)) {
                                    this.negation(false);
                                    continue block68;
                                }
                                if (this.jj_2_13(2)) {
                                    this.pseudo(false);
                                    continue block68;
                                }
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        break;
                    }
                    this.jj_la1[57] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 24: {
                        this.attrib(writeSpaceBefore);
                        block69: while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                case 24: 
                                case 27: 
                                case 33: 
                                case 72: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[58] = this.jj_gen;
                                    break block0;
                                }
                            }
                            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                                case 72: {
                                    this.hash(false);
                                    continue block69;
                                }
                                case 27: {
                                    this._class(false);
                                    continue block69;
                                }
                                case 24: {
                                    this.attrib(false);
                                    continue block69;
                                }
                                case 33: {
                                    if (this.jj_2_14(2)) {
                                        this.negation(false);
                                        continue block69;
                                    }
                                    if (this.jj_2_15(2)) {
                                        this.pseudo(false);
                                        continue block69;
                                    }
                                    this.jj_consume_token(-1);
                                    throw new ParseException();
                                }
                            }
                            break;
                        }
                        this.jj_la1[59] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.jj_la1[61] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 22: {
                Token tw = this.jj_consume_token(22);
                this.write(tw);
                break;
            }
            default: {
                this.jj_la1[62] = this.jj_gen;
            }
        }
    }

    public final void negation(boolean precededBySpace) throws ParseException {
        Token tw = this.jj_consume_token(33);
        this.write(tw);
        tw = this.jj_consume_token(109);
        this.write(tw);
        this.wsOrComment_ZOM(WSPosition.WS_AFTER, false, "");
        this.simple_selector(false);
        this.wsOrComment_ZOM(WSPosition.WS_AFTER, false, "");
        tw = this.jj_consume_token(29);
        this.write(tw);
    }

    public final void _class(boolean precededBySpace) throws ParseException {
        Token tw = this.jj_consume_token(27);
        if (precededBySpace) {
            this.write(" ");
        }
        this.write(tw);
        tw = this.jj_consume_token(48);
        this.write(tw);
    }

    public final void element_name(boolean precededBySpace) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 48: {
                Token tw = this.jj_consume_token(48);
                if (precededBySpace) {
                    this.write(" ");
                }
                this.write(tw);
                break;
            }
            case 53: {
                Token tw = this.jj_consume_token(53);
                if (precededBySpace) {
                    this.write(" ");
                }
                this.write(tw);
                break;
            }
            case 26: {
                Token tw = this.jj_consume_token(26);
                if (precededBySpace) {
                    this.write(" ");
                }
                this.write(tw);
                break;
            }
            default: {
                this.jj_la1[63] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void attrib(boolean precededBySpace) throws ParseException {
        Token tw = this.jj_consume_token(24);
        if (precededBySpace) {
            this.write(" ");
        }
        this.write(tw);
        this.wsOrComment_ZOM(WSPosition.WS_AFTER, false, "");
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 48: {
                tw = this.jj_consume_token(48);
                this.write(tw);
                break;
            }
            case 53: {
                tw = this.jj_consume_token(53);
                this.write(tw);
                break;
            }
            default: {
                this.jj_la1[64] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.wsOrComment_ZOM(WSPosition.WS_BEFORE, false, "");
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 12: 
            case 13: 
            case 14: 
            case 30: 
            case 31: 
            case 32: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 14: {
                        tw = this.jj_consume_token(14);
                        this.write(" ");
                        this.write(tw);
                        break;
                    }
                    case 13: {
                        tw = this.jj_consume_token(13);
                        this.write(" ");
                        this.write(tw);
                        break;
                    }
                    case 12: {
                        tw = this.jj_consume_token(12);
                        this.write(" ");
                        this.write(tw);
                        break;
                    }
                    case 30: {
                        tw = this.jj_consume_token(30);
                        this.write(" ");
                        this.write(tw);
                        break;
                    }
                    case 31: {
                        tw = this.jj_consume_token(31);
                        this.write(" ");
                        this.write(tw);
                        break;
                    }
                    case 32: {
                        tw = this.jj_consume_token(32);
                        this.write(" ");
                        this.write(tw);
                        break;
                    }
                    default: {
                        this.jj_la1[65] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.wsOrComment_ZOM(WSPosition.WS_BEFORE, false, "");
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 48: {
                        tw = this.jj_consume_token(48);
                        this.write(" ");
                        this.write(tw);
                        break;
                    }
                    case 47: {
                        tw = this.jj_consume_token(47);
                        this.write(" ");
                        this.write(tw);
                        break;
                    }
                    default: {
                        this.jj_la1[66] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.wsOrComment_ZOM(WSPosition.WS_BEFORE, false, "");
                break;
            }
            default: {
                this.jj_la1[67] = this.jj_gen;
            }
        }
        tw = this.jj_consume_token(25);
        this.write(tw);
    }

    public final void pseudo(boolean precededBySpace) throws ParseException {
        Token tw = this.jj_consume_token(33);
        if (precededBySpace) {
            this.write(" ");
        }
        this.write(tw);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 33: {
                tw = this.jj_consume_token(33);
                this.write(tw);
                break;
            }
            default: {
                this.jj_la1[68] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 48: {
                tw = this.jj_consume_token(48);
                this.write(tw);
                break;
            }
            case 110: {
                this.functional_pseudo();
                break;
            }
            default: {
                this.jj_la1[69] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void functional_pseudo() throws ParseException {
        Token tw = this.jj_consume_token(110);
        this.write(tw);
        this.wsOrComment_ZOM(WSPosition.WS_AFTER, false, "");
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 50: {
                tw = this.jj_consume_token(50);
                this.write(tw);
                break;
            }
            case 49: {
                tw = this.jj_consume_token(49);
                this.write(tw);
                break;
            }
            case 48: {
                tw = this.jj_consume_token(48);
                this.write(tw);
                break;
            }
            default: {
                this.jj_la1[70] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.wsOrComment_ZOM(WSPosition.WS_BEFORE, false, "");
        tw = this.jj_consume_token(29);
        this.write(tw);
    }

    public final void hash(boolean precededBySpace) throws ParseException {
        Token tw = this.jj_consume_token(72);
        if (precededBySpace) {
            this.write(" ");
        }
        this.write(tw);
    }

    public final boolean declaration(String indent) throws ParseException {
        boolean declarationConsumed = false;
        WSCommentReport report = this.emptyReport;
        this.write(indent);
        this.property();
        declarationConsumed = true;
        Token tw = this.jj_consume_token(33);
        if (this.preserveEmptyLines && this.outputHandler.isLastNewLine()) {
            this.write(indent);
        }
        this.write(tw);
        if (this.addSpaceBeforePropertyValue) {
            this.write(" ");
        }
        try {
            report = this.wsOrComment_ZOM(this.addSpaceBeforePropertyValue ? WSPosition.WS_AFTER : WSPosition.NONE, false, this.preserveEmptyLines ? indent : "");
            if (this.preserveEmptyLines && !report.isCommentConsumed() && this.outputHandler.isLastNewLine()) {
                this.write(indent);
            }
            this.expr();
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 98: {
                    this.prio();
                    break;
                }
                default: {
                    this.jj_la1[71] = this.jj_gen;
                    break;
                }
            }
        }
        catch (ParseException e) {
            if (this.errorHandler != null) {
                this.reportError(e);
            }
            this.skipAfterExpression();
        }
        return declarationConsumed;
    }

    public final void prio() throws ParseException {
        Token tw = this.jj_consume_token(98);
        this.write(" ");
        this.write(tw);
        this.wsOrComment_ZOM(WSPosition.WS_BEFORE, false, "");
    }

    public final boolean operator() throws ParseException {
        boolean operatorConsumed = false;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 23: {
                Token tw = this.jj_consume_token(23);
                this.write(tw);
                operatorConsumed = true;
                this.wsOrComment_ZOM(WSPosition.WS_AFTER, false, "");
                break;
            }
            case 17: {
                Token tw = this.jj_consume_token(17);
                this.write(tw);
                this.write(" ");
                operatorConsumed = true;
                this.wsOrComment_ZOM(WSPosition.WS_AFTER, false, "");
                break;
            }
            default: {
                this.jj_la1[72] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return operatorConsumed;
    }

    public final void expr() throws ParseException {
        boolean operatorConsumed = false;
        this.term();
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 15: 
                case 16: 
                case 17: 
                case 23: 
                case 47: 
                case 48: 
                case 49: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 108: 
                case 110: {
                    break;
                }
                default: {
                    this.jj_la1[73] = this.jj_gen;
                    break block6;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 17: 
                case 23: {
                    operatorConsumed = this.operator();
                    break;
                }
                default: {
                    this.jj_la1[74] = this.jj_gen;
                }
            }
            if (!operatorConsumed) {
                this.write(" ");
            } else {
                operatorConsumed = false;
            }
            this.term();
        }
    }

    public final void unaryOperator() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 16: {
                Token tw = this.jj_consume_token(16);
                this.write(tw);
                break;
            }
            case 15: {
                Token tw = this.jj_consume_token(15);
                this.write(tw);
                break;
            }
            default: {
                this.jj_la1[75] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void term() throws ParseException {
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 15: 
            case 16: 
            case 49: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 110: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 49: {
                        Token tw = this.jj_consume_token(49);
                        this.write(tw);
                        break block0;
                    }
                    case 54: {
                        Token tw = this.jj_consume_token(54);
                        this.write(tw);
                        break block0;
                    }
                    case 55: {
                        Token tw = this.jj_consume_token(55);
                        this.write(tw);
                        break block0;
                    }
                    case 56: {
                        Token tw = this.jj_consume_token(56);
                        this.write(tw);
                        break block0;
                    }
                    case 58: {
                        Token tw = this.jj_consume_token(58);
                        this.write(tw);
                        break block0;
                    }
                    case 57: {
                        Token tw = this.jj_consume_token(57);
                        this.write(tw);
                        break block0;
                    }
                    case 59: {
                        Token tw = this.jj_consume_token(59);
                        this.write(tw);
                        break block0;
                    }
                    case 60: {
                        Token tw = this.jj_consume_token(60);
                        this.write(tw);
                        break block0;
                    }
                    case 61: {
                        Token tw = this.jj_consume_token(61);
                        this.write(tw);
                        break block0;
                    }
                    case 62: {
                        Token tw = this.jj_consume_token(62);
                        this.write(tw);
                        break block0;
                    }
                    case 63: {
                        Token tw = this.jj_consume_token(63);
                        this.write(tw);
                        break block0;
                    }
                    case 64: {
                        Token tw = this.jj_consume_token(64);
                        this.write(tw);
                        break block0;
                    }
                    case 65: {
                        Token tw = this.jj_consume_token(65);
                        this.write(tw);
                        break block0;
                    }
                    case 66: {
                        Token tw = this.jj_consume_token(66);
                        this.write(tw);
                        break block0;
                    }
                    case 68: {
                        Token tw = this.jj_consume_token(68);
                        this.write(tw);
                        break block0;
                    }
                    case 67: {
                        Token tw = this.jj_consume_token(67);
                        this.write(tw);
                        break block0;
                    }
                    case 69: {
                        Token tw = this.jj_consume_token(69);
                        this.write(tw);
                        break block0;
                    }
                    case 70: {
                        Token tw = this.jj_consume_token(70);
                        this.write(tw);
                        break block0;
                    }
                    case 71: {
                        Token tw = this.jj_consume_token(71);
                        this.write(tw);
                        break block0;
                    }
                    case 15: 
                    case 16: 
                    case 110: {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 15: 
                            case 16: {
                                this.unaryOperator();
                                break;
                            }
                            default: {
                                this.jj_la1[76] = this.jj_gen;
                            }
                        }
                        this.function();
                        break block0;
                    }
                }
                this.jj_la1[77] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            case 47: 
            case 48: 
            case 52: 
            case 53: 
            case 72: 
            case 108: {
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 47: {
                        Token tw = this.jj_consume_token(47);
                        this.write(tw);
                        break block0;
                    }
                    case 53: {
                        Token tw = this.jj_consume_token(53);
                        this.write(tw);
                        break block0;
                    }
                    case 48: {
                        Token tw = this.jj_consume_token(48);
                        this.write(tw);
                        break block0;
                    }
                    case 72: {
                        this.hexcolor();
                        break block0;
                    }
                    case 52: {
                        this.url();
                        break block0;
                    }
                    case 108: {
                        this.unicode();
                        break block0;
                    }
                }
                this.jj_la1[78] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[79] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.wsOrComment_ZOM(WSPosition.WS_BEFORE, false, this.preserveEmptyLines ? this.outputHandler.getIndent() : "");
    }

    public final void function() throws ParseException {
        WSCommentReport report = this.emptyReport;
        Token tw = this.jj_consume_token(110);
        this.write(tw);
        report = this.wsOrComment_ZOM(WSPosition.NONE, false, "");
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 15: 
            case 16: 
            case 47: 
            case 48: 
            case 49: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 108: 
            case 110: {
                if (report.isCommentConsumed()) {
                    this.write(" ");
                }
                this.expr();
                break;
            }
            default: {
                this.jj_la1[80] = this.jj_gen;
            }
        }
        tw = this.jj_consume_token(29);
        this.write(tw);
    }

    public final void unicode() throws ParseException {
        Token tw = this.jj_consume_token(108);
        this.write(tw);
    }

    public final void url() throws ParseException {
        Token tw = this.jj_consume_token(52);
        this.write(tw);
    }

    public final void hexcolor() throws ParseException {
        Token tw = this.jj_consume_token(72);
        this.write(tw);
    }

    String skipStatementNoSemicolon() throws ParseException {
        if (this.debug) {
            this.write(" <Skip statement no semicolon|");
        }
        StringBuffer s = new StringBuffer();
        Token tok = this.getToken(0);
        if (tok.image != null) {
            s.append(tok.image);
            this.write(tok);
        }
        while (true) {
            tok = this.getToken(1);
            if (tok.kind == 0) {
                return null;
            }
            s.append(tok.image);
            this.write(tok);
            if (tok.kind == 10) {
                this.getNextToken();
                s.append(this.skip_to_matching_brace());
                this.getNextToken();
                tok = this.getToken(1);
                break;
            }
            this.getNextToken();
        }
        while (tok.kind == 1 && tok.kind == 2 && tok.kind == 3) {
            tok = this.getNextToken();
            tok = this.getToken(1);
        }
        if (this.debug) {
            this.write("|>");
        }
        this.newLine();
        return s.toString().trim();
    }

    String skipStatement() throws ParseException {
        StringBuffer s = new StringBuffer();
        if (this.debug) {
            this.write(" <Skip statement|");
        }
        Token tok = this.getToken(0);
        if (tok.image != null) {
            s.append(tok.image);
            this.write(tok);
        }
        while (true) {
            tok = this.getToken(1);
            if (tok.kind == 0) {
                return null;
            }
            s.append(tok.image);
            this.write(tok);
            if (tok.kind == 10) {
                this.getNextToken();
                s.append(this.skip_to_matching_brace());
                this.getNextToken();
                tok = this.getToken(1);
                break;
            }
            if (tok.kind == 11) {
                this.getNextToken();
                tok = this.getToken(1);
                break;
            }
            if (tok.kind == 18) {
                this.getNextToken();
                tok = this.getToken(1);
                break;
            }
            this.getNextToken();
        }
        while (tok.kind == 1 && tok.kind == 2 && tok.kind == 3) {
            tok = this.getNextToken();
            tok = this.getToken(1);
            if (tok.image == null) continue;
            s.append(tok.image);
            this.write(tok);
        }
        if (this.debug) {
            this.write("|>");
        }
        this.newLine();
        return s.toString().trim();
    }

    String skip_to_matching_brace() throws ParseException {
        StringBuffer s = new StringBuffer();
        int nesting = 1;
        while (true) {
            Token tok = this.getToken(1);
            if (tok.kind == 0) break;
            s.append(tok.image);
            this.write(tok);
            if (tok.kind == 10) {
                ++nesting;
            } else if (tok.kind == 11 && --nesting == 0) break;
            this.getNextToken();
        }
        return s.toString();
    }

    void rejectToken(Token t) throws ParseException {
        Token fakeToken = new Token();
        t.next = this.token;
        fakeToken.next = t;
        this.token = fakeToken;
    }

    String skipAfterExpression() throws ParseException {
        if (this.debug) {
            this.write(" <Skip after expression|");
        }
        Token t = this.getToken(1);
        StringBuffer s = new StringBuffer();
        Token tok = this.getToken(0);
        s.append(tok.image);
        this.write(tok);
        while (t.kind != 11 && t.kind != 18 && t.kind != 0) {
            s.append(t.image);
            this.write(t);
            this.getNextToken();
            t = this.getToken(1);
        }
        if (this.debug) {
            this.write("|>");
        }
        this.newLine();
        return s.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_3(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_3();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(2, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_4(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_4();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(3, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_5(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_5();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(4, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_6(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_6();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(5, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_7(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_7();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(6, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_8(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_8();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(7, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_9(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_9();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(8, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_10(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_10();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(9, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_11(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_11();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(10, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_12(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_12();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(11, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_13(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_13();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(12, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_14(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_14();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(13, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_15(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_15();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(14, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_16(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_16();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(15, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_17(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_17();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(16, xla);
        }
    }

    private boolean jj_3_15() {
        return this.jj_3R_31();
    }

    private boolean jj_3R_43() {
        return this.jj_scan_token(2);
    }

    private boolean jj_3R_40() {
        return this.jj_3R_47();
    }

    private boolean jj_3R_39() {
        return this.jj_scan_token(48);
    }

    private boolean jj_3_13() {
        return this.jj_3R_31();
    }

    private boolean jj_3R_38() {
        return this.jj_scan_token(33);
    }

    private boolean jj_3R_42() {
        return this.jj_scan_token(1);
    }

    private boolean jj_3R_27() {
        return this.jj_3R_33();
    }

    private boolean jj_3R_36() {
        return this.jj_3R_45();
    }

    private boolean jj_3R_49() {
        return this.jj_3R_51();
    }

    private boolean jj_3R_35() {
        return this.jj_scan_token(48);
    }

    private boolean jj_3_11() {
        return this.jj_3R_31();
    }

    private boolean jj_3R_33() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_42()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_43()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_44()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_31() {
        if (this.jj_scan_token(33)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_38()) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_39()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_40()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_53() {
        return this.jj_scan_token(44);
    }

    private boolean jj_3_3() {
        return this.jj_3R_29();
    }

    private boolean jj_3_9() {
        return this.jj_3R_31();
    }

    private boolean jj_3_14() {
        return this.jj_3R_30();
    }

    private boolean jj_3R_29() {
        if (this.jj_scan_token(74)) {
            return true;
        }
        if (this.jj_3R_34()) {
            return true;
        }
        return this.jj_3R_37();
    }

    private boolean jj_3R_52() {
        return this.jj_scan_token(45);
    }

    private boolean jj_3R_50() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_52()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_53()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_28() {
        if (this.jj_scan_token(76)) {
            return true;
        }
        if (this.jj_3R_34()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_35()) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_36()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(10);
    }

    private boolean jj_3R_45() {
        return this.jj_scan_token(33);
    }

    private boolean jj_3R_41() {
        return this.jj_scan_token(7);
    }

    private boolean jj_3_7() {
        return this.jj_3R_31();
    }

    private boolean jj_3_12() {
        return this.jj_3R_30();
    }

    private boolean jj_3R_48() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_50()) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_3R_34()) {
            return true;
        }
        return this.jj_scan_token(48);
    }

    private boolean jj_3R_46() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_48()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_49()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_5() {
        return this.jj_3R_31();
    }

    private boolean jj_3_10() {
        return this.jj_3R_30();
    }

    private boolean jj_3R_26() {
        return this.jj_3R_32();
    }

    private boolean jj_3R_32() {
        Token xsp;
        if (this.jj_scan_token(5)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_41());
        this.jj_scanpos = xsp;
        return this.jj_scan_token(6);
    }

    private boolean jj_3_8() {
        return this.jj_3R_30();
    }

    private boolean jj_3R_37() {
        return this.jj_3R_46();
    }

    private boolean jj_3_1() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_26()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_27()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_2() {
        return this.jj_3R_28();
    }

    private boolean jj_3_6() {
        return this.jj_3R_30();
    }

    private boolean jj_3R_30() {
        if (this.jj_scan_token(33)) {
            return true;
        }
        return this.jj_scan_token(109);
    }

    private boolean jj_3R_34() {
        Token xsp;
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_1());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3_17() {
        return this.jj_3R_30();
    }

    private boolean jj_3_4() {
        return this.jj_3R_30();
    }

    private boolean jj_3R_44() {
        return this.jj_scan_token(3);
    }

    private boolean jj_3_16() {
        return this.jj_3R_31();
    }

    private boolean jj_3R_47() {
        return this.jj_scan_token(110);
    }

    private boolean jj_3R_51() {
        return this.jj_scan_token(28);
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{128, 14, 46, 32, 0, 768, 0, 768, 0, 768, 218103854, 768, 768, 0, 268435502, 0, 0, 222278958, 218103854, 4175104, 131072, 0, 0, 0, 0, 268435502, 0, 0, 0, 0, 262144, 0, 0, 0, 262144, 0, 0, 262144, 0, 4175104, 0x388000, 0, 262144, 0, 131072, 3702830, 0xD000000, 3702830, 0x9000000, 0x9000000, 0x9000000, 0x9000000, 0x9000000, 0x9000000, 0x9000000, 0x9000000, 0x9000000, 0x9000000, 0x9000000, 0x9000000, 0xC000000, 0x1000000, 0x400000, 0x4000000, 0, -1073713152, 0, -1073713152, 0, 0, 0, 0, 0x820000, 0x838000, 0x820000, 98304, 98304, 98304, 0, 98304, 98304};
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x210002, 0, 0, 0x108000, 77824, 65536, 0x108000, 7569414, 0x210002, 5406724, 0, 12288, 12288, 16384, 16384, 77824, 2, 65536, 2, 65536, 0, 0, 0, 65536, 0, 65536, 65536, 0, 65536, 5406724, 0, 65536, 0, 65536, 0, 0, 0x210002, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0x210000, 0, 0, 0x210000, 0x210000, 1, 98304, 1, 2, 65536, 458752, 0, 0, -819200, 0, 0, 0, -4063232, 3244032, -819200, -819200};
    }

    private static void jj_la1_init_2() {
        jj_la1_2 = new int[]{0, 0, 0, 0, 2048, 0, 512, 0, Integer.MIN_VALUE, 0, 5376, 0, 0, 0, 0, 0, 0, 7936, 256, 7680, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2147475456, 2147475456, 0, 0, 0, 0, 0, 0, 7680, 0, 0, 0, 0, 0, 0, 256, 0, 256, 256, 0, 0, 256, 256, 256, 256, 256, 256, 256, 256, 256, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 511, 0, 0, 0, 255, 256, 511, 511};
    }

    private static void jj_la1_init_3() {
        jj_la1_3 = new int[]{0, 0, 0, 0, 0, 2, 0, 2, 0, 2, 1, 2, 2, 0, 0, 0, 0, 53255, 0, 53255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 53255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16384, 0, 4, 0, 20480, 0, 0, 0, 16384, 4096, 20480, 20480};
    }

    public CSSPrettyPrinter(CharStream stream) {
        int i;
        this.token_source = new CSSPrettyPrinterTokenManager(stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 81; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(CharStream stream) {
        int i;
        this.token_source.ReInit(stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 81; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public CSSPrettyPrinter(CSSPrettyPrinterTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 81; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(CSSPrettyPrinterTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 81; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk_f() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            for (int[] oldentry : this.jj_expentries) {
                if (oldentry.length != this.jj_expentry.length) continue;
                boolean isMatched = true;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] == this.jj_expentry[i]) continue;
                    isMatched = false;
                    break;
                }
                if (!isMatched) continue;
                this.jj_expentries.add(this.jj_expentry);
                break;
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[112];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 81; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) != 0) {
                    la1tokens[32 + j] = true;
                }
                if ((jj_la1_2[i] & 1 << j) != 0) {
                    la1tokens[64 + j] = true;
                }
                if ((jj_la1_3[i] & 1 << j) == 0) continue;
                la1tokens[96 + j] = true;
            }
        }
        for (i = 0; i < 112; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 17; ++i) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                            break;
                        }
                        case 2: {
                            this.jj_3_3();
                            break;
                        }
                        case 3: {
                            this.jj_3_4();
                            break;
                        }
                        case 4: {
                            this.jj_3_5();
                            break;
                        }
                        case 5: {
                            this.jj_3_6();
                            break;
                        }
                        case 6: {
                            this.jj_3_7();
                            break;
                        }
                        case 7: {
                            this.jj_3_8();
                            break;
                        }
                        case 8: {
                            this.jj_3_9();
                            break;
                        }
                        case 9: {
                            this.jj_3_10();
                            break;
                        }
                        case 10: {
                            this.jj_3_11();
                            break;
                        }
                        case 11: {
                            this.jj_3_12();
                            break;
                        }
                        case 12: {
                            this.jj_3_13();
                            break;
                        }
                        case 13: {
                            this.jj_3_14();
                            break;
                        }
                        case 14: {
                            this.jj_3_15();
                            break;
                        }
                        case 15: {
                            this.jj_3_16();
                            break;
                        }
                        case 16: {
                            this.jj_3_17();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        CSSPrettyPrinter.jj_la1_init_0();
        CSSPrettyPrinter.jj_la1_init_1();
        CSSPrettyPrinter.jj_la1_init_2();
        CSSPrettyPrinter.jj_la1_init_3();
    }

    private class ReaderWithCounter
    extends Reader {
        private final Reader reader;
        private boolean closed = false;
        private int charCounter = 0;

        public ReaderWithCounter(Reader reader) {
            this.reader = reader;
        }

        @Override
        public int read(char[] cbuf, int off, int len) throws IOException {
            if (this.closed) {
                throw new IOException("Reader closed!");
            }
            int charRead = this.reader.read(cbuf, off, len);
            if (charRead != -1) {
                for (int i = off; i < off + charRead; ++i) {
                    char ch = cbuf[i];
                    if (Character.isWhitespace(ch)) continue;
                    ++this.charCounter;
                }
            }
            return charRead;
        }

        @Override
        public void close() throws IOException {
            this.reader.close();
            this.closed = true;
        }

        public int getNonWhitespaceCharsCount() {
            return this.charCounter;
        }
    }

    private static enum WSPosition {
        NONE,
        WS_BEFORE,
        WS_AFTER;

    }

    private class WSCommentReport {
        boolean lfConsumed = false;
        boolean commentConsumed = false;

        public WSCommentReport(boolean lfConsumed, boolean commentConsumed) {
            this.lfConsumed = lfConsumed;
            this.commentConsumed = commentConsumed;
        }

        public boolean isLfConsumed() {
            return this.lfConsumed;
        }

        public boolean isCommentConsumed() {
            return this.commentConsumed;
        }

        public String toString() {
            return "[LF = " + this.lfConsumed + " - COM = " + this.commentConsumed + "]";
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }
}

