/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.security.permissions;

import java.net.URLPermission;
import java.security.Permission;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.basic.statics.StaticComponentsRegistry;
import ro.sync.basic.util.java.JavaVersion;

public final class URLPermissionFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)URLPermissionFactory.class.getName());

    private URLPermissionFactory() {
        throw new UnsupportedOperationException("Instantiation of this utility class is not allowed!");
    }

    public static Permission newURLPermission(String url, String actions) {
        Permission perm = null;
        if (!JavaVersion.V_12.isCurrentVersionOrNewer() || URLPermissionFactory.isWebAuthor()) {
            perm = URLPermissionFactory.newURLPermissionFromJava18OrGreater(url, actions);
        }
        if (perm == null) {
            try {
                perm = new ro.sync.security.manager.URLPermission(url, actions);
            }
            catch (RuntimeException e) {
                LOGGER.debug(String.valueOf(e), (Throwable)e);
            }
        }
        return perm;
    }

    public static boolean isWebAuthor() {
        Boolean webappComp = (Boolean)StaticComponentsRegistry.get((String)"IS_WEBAUTHOR_COMPONENT");
        return webappComp == null ? false : webappComp;
    }

    static Permission newURLPermissionFromJava18OrGreater(String url, String actions) {
        URLPermission perm = null;
        try {
            perm = new URLPermission(url, actions);
        }
        catch (RuntimeException e) {
            LOGGER.debug(String.valueOf(e), (Throwable)e);
        }
        return perm;
    }
}

