/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.textsearch.xml;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexableField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.Locator2;
import ro.sync.textsearch.io.TextSearchURIUtil;
import ro.sync.textsearch.shredder.AbstractShredderBase;
import ro.sync.textsearch.xml.ContentAccumulator;
import ro.sync.textsearch.xml.IgnorableChunksUtil;
import ro.sync.textsearch.xml.QName;
import ro.sync.textsearch.xml.XMLAttributeFilter;
import ro.sync.textsearch.xml.XMLElementStorageProvider;
import ro.sync.textsearch.xml.XMLShredderConfiguration;
import ro.sync.textsearch.xml.XMLShredderConfigurationProvider;

public class XMLShredder
extends AbstractShredderBase {
    private boolean isSkimmingMode;
    private HashMap<QName, StringBuilder> attributesAccumulators = new HashMap();
    private ContentAccumulator piAccumulator;
    private ContentAccumulator commentsAccumulator;
    private boolean generatesCompletionFields;
    private static final Logger logger = LoggerFactory.getLogger((String)XMLShredder.class.getName());
    private XMLAttributeFilter attributeFilter;
    private boolean collectDescriptionFromComments = false;
    private int maxDescLengthForTests = -1;
    private boolean inDtd = false;
    private String encoding = null;
    private boolean allElementsToFields;

    public XMLShredder(XMLShredderConfigurationProvider configurationProvider, String systemId, boolean isSkimmingMode) {
        this.shredderConfigurationProvider = configurationProvider;
        this.systemId = systemId;
        this.isSkimmingMode = isSkimmingMode;
        this.commentsAccumulator = new ContentAccumulator(this.rawContent);
        this.piAccumulator = new ContentAccumulator(this.rawContent);
    }

    @Override
    protected void setConfiguration(XMLShredderConfiguration config) {
        this.attributeFilter = config.getAttributeFilter();
        this.storageTypeProvider = config.getStorageTypeProvider();
        this.maxDescLength = this.maxDescLengthForTests != -1 ? this.maxDescLengthForTests : config.getMaxDescLength();
        this.collectDescriptionFromComments = config.isCollectDescriptionFromComments();
        this.collectDescriptionFromText = config.isCollectDescriptionFromText();
    }

    public Document getLuceneDocument() {
        Document luceneDocument = new Document();
        if (!this.commentsAccumulator.isEmpty()) {
            luceneDocument.add((IndexableField)new TextField("__xml_comment__", this.commentsAccumulator.createReader()));
        }
        if (!this.piAccumulator.isEmpty()) {
            luceneDocument.add((IndexableField)new TextField("__xml_processing_instruction__", this.piAccumulator.createReader()));
        }
        String titleStr = null;
        String descStr = null;
        Set elems = this.elementsAccumulators.keySet();
        block5: for (QName qName : elems) {
            ContentAccumulator acc;
            if (logger.isDebugEnabled()) {
                logger.debug("Creating field for " + qName);
            }
            if ((acc = (ContentAccumulator)this.elementsAccumulators.get(qName)).isEmpty()) continue;
            switch (acc.getStorageType()) {
                case INDEX: 
                case BOOST_RELEVANT: {
                    luceneDocument.add((IndexableField)new TextField(qName.getLocalName(), acc.createReader()));
                    continue block5;
                }
                case STORE_AS_TITLE: {
                    String title;
                    if (!this.isSkimmingMode) {
                        luceneDocument.add((IndexableField)new TextField(qName.getLocalName(), acc.createReader()));
                    }
                    if ((title = acc.getFirstRangeContent()) == null) continue block5;
                    titleStr = IgnorableChunksUtil.removeAttrsPIsAndCommentsAndNormalize(title);
                    List<Field> titleFields = this.getTextAndTermsFieldsForTitle(titleStr, true);
                    titleFields.forEach(arg_0 -> ((Document)luceneDocument).add(arg_0));
                    continue block5;
                }
                case STORE_AS_DESCRIPTION: {
                    String description;
                    if (!this.isSkimmingMode) {
                        luceneDocument.add((IndexableField)new TextField(qName.getLocalName(), acc.createReader()));
                    }
                    if ((description = acc.getFirstRangeContent()) == null) continue block5;
                    descStr = IgnorableChunksUtil.removeAttrsPIsAndCommentsAndNormalize(description);
                    luceneDocument.add((IndexableField)new StringField("__desc__", this.trimToWordBoundary(descStr, 256, true), Field.Store.YES));
                    continue block5;
                }
            }
            logger.error("Should not get here. This is a programming error.");
        }
        Set<QName> attrs = this.attributesAccumulators.keySet();
        for (QName qName : attrs) {
            StringBuilder value = this.attributesAccumulators.get(qName);
            luceneDocument.add((IndexableField)new TextField("@" + qName.getLocalName(), value.toString(), Field.Store.NO));
        }
        if (descStr == null) {
            Optional.ofNullable(this.computeDescriptionField(titleStr)).ifPresent(arg_0 -> ((Document)luceneDocument).add(arg_0));
        }
        if (this.detectedRootLocalName != null) {
            luceneDocument.add((IndexableField)new StringField("__xml_root__", this.detectedRootLocalName, Field.Store.NO));
        }
        this.getTextAndTermsFields("__text__").forEach(arg_0 -> ((Document)luceneDocument).add(arg_0));
        return luceneDocument;
    }

    @Override
    protected boolean generatesCompletionFields() {
        return this.generatesCompletionFields;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        boolean isRoot = false;
        if (this.detectedRootLocalName == null) {
            this.detectedRootLocalName = localName;
            isRoot = true;
        }
        if (this.detectedRootNamespace == null) {
            this.detectedRootNamespace = uri;
        }
        if (isRoot) {
            this.setConfiguration(this.shredderConfigurationProvider.getConfiguration(atts, this.detectedRootLocalName, this.detectedRootNamespace, this.detectedDTDPublicId, this.detectedDTDSystemId, this.systemId));
        }
        this.addSpaceBreak();
        if (logger.isDebugEnabled()) {
            logger.debug("Starting element " + localName + " # " + TextSearchURIUtil.maskPasswords(uri) + " " + qName);
        }
        this.qNameStack.push(new QName(localName, uri));
        this.stIndexStack.push(this.rawContent.length());
        int length = atts.getLength();
        if (length > 0 && !this.isSkimmingMode) {
            StringBuilder attrsContent = null;
            for (int i = 0; i < length; ++i) {
                boolean accepted = this.attributeFilter != null ? this.attributeFilter.accepts(uri, localName, qName, atts, i) : true;
                if (!accepted) continue;
                if (attrsContent == null) {
                    attrsContent = new StringBuilder();
                }
                String av = atts.getValue(i);
                attrsContent.append(atts.getQName(i));
                attrsContent.append(' ');
                attrsContent.append(av);
                attrsContent.append(' ');
                QName aqn = new QName(atts.getLocalName(i), atts.getURI(i));
                StringBuilder attrBuilder = this.attributesAccumulators.get(aqn);
                if (attrBuilder == null) {
                    attrBuilder = new StringBuilder();
                    this.attributesAccumulators.put(aqn, attrBuilder);
                } else {
                    attrBuilder.append(' ');
                }
                attrBuilder.append(av);
            }
            if (attrsContent != null) {
                this.rawContent.append('\u0000');
                this.rawContent.append((CharSequence)attrsContent);
                this.rawContent.append('\u0000');
            }
        }
        XMLElementStorageProvider.StorageType storageType = XMLElementStorageProvider.StorageType.INDEX;
        if (this.storageTypeProvider != null) {
            storageType = this.storageTypeProvider.getStorageType(uri, localName, qName, atts);
            if (this.isSkimmingMode && storageType != XMLElementStorageProvider.StorageType.STORE_AS_DESCRIPTION && storageType != XMLElementStorageProvider.StorageType.STORE_AS_TITLE) {
                storageType = XMLElementStorageProvider.StorageType.DISCARD;
            }
            if (!this.isSkimmingMode && this.allElementsToFields && storageType == XMLElementStorageProvider.StorageType.DISCARD) {
                storageType = XMLElementStorageProvider.StorageType.INDEX;
            }
        }
        this.storageStack.push(storageType);
    }

    private void addSpaceBreak() {
        this.addSpaceBreak(this.rawContent);
        if ((this.collectDescriptionFromComments || this.collectDescriptionFromText) && !this.isCollectedDescription()) {
            this.addSpaceBreak(this.longDesc);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.addSpaceBreak();
        int stIndex = (Integer)this.stIndexStack.pop();
        int enIndex = this.rawContent.length();
        QName q = (QName)this.qNameStack.pop();
        if (logger.isDebugEnabled()) {
            logger.debug("Ending element " + qName);
        }
        if (stIndex < enIndex) {
            if (logger.isDebugEnabled()) {
                logger.debug("There is text content.");
            }
            XMLElementStorageProvider.StorageType storageType = (XMLElementStorageProvider.StorageType)((Object)this.storageStack.pop());
            if (!this.qNameStack.contains(q) && storageType != XMLElementStorageProvider.StorageType.DISCARD) {
                ContentAccumulator acc = this.elementsAccumulators.computeIfAbsent(q, k -> {
                    ContentAccumulator a = new ContentAccumulator(this.rawContent);
                    a.setStorageType(storageType);
                    return a;
                });
                acc.add(stIndex, enIndex);
            }
            if (this.isSkimmingMode && this.hasCollectedTitleAndDescription()) {
                throw new SkimmingEndedException();
            }
        }
    }

    private boolean hasCollectedTitleAndDescription() {
        boolean collected = false;
        if (this.elementsAccumulators.size() == 2) {
            Collection accs = this.elementsAccumulators.values();
            int s = 0;
            for (ContentAccumulator acc : accs) {
                if (acc.getStorageType() == XMLElementStorageProvider.StorageType.STORE_AS_DESCRIPTION) {
                    ++s;
                    continue;
                }
                if (acc.getStorageType() != XMLElementStorageProvider.StorageType.STORE_AS_TITLE) continue;
                s += 2;
            }
            collected = s > 2;
        }
        return collected;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.rawContent.append(ch, start, length);
        if (this.collectDescriptionFromText) {
            this.appendDescription(ch, start, length);
        }
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        boolean isReviewPI = false;
        if (target.startsWith("oxy_") && (!target.startsWith("oxy_custom_start") || data.indexOf("type=\"oxy_content_highlight\"") != -1)) {
            isReviewPI = true;
        }
        if (!isReviewPI) {
            int stIndex = this.rawContent.length();
            this.rawContent.append('\u0000');
            this.rawContent.append(' ');
            this.rawContent.append(target);
            this.rawContent.append(' ');
            this.rawContent.append(data);
            this.rawContent.append(' ');
            this.rawContent.append('\u0000');
            int enIndex = this.rawContent.length();
            this.piAccumulator.add(stIndex, enIndex);
        }
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        this.detectedDTDPublicId = publicId;
        this.detectedDTDSystemId = systemId;
        this.inDtd = true;
    }

    @Override
    public void endDTD() throws SAXException {
        this.inDtd = false;
    }

    @Override
    public void comment(char[] ch, int start, int length) throws SAXException {
        if (!this.inDtd) {
            int stIndex = this.rawContent.length();
            this.rawContent.append('\u0000');
            this.rawContent.append(' ');
            this.rawContent.append(ch, start, length);
            this.rawContent.append(' ');
            this.rawContent.append('\u0000');
            int enIndex = stIndex + length;
            this.commentsAccumulator.add(stIndex, enIndex);
            if (this.collectDescriptionFromComments) {
                this.appendDescription(ch, start, length);
            }
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.rawContent.append('\u0000');
        this.rawContent.append(uri);
        this.rawContent.append('\u0000');
        this.addSpaceBreak(this.rawContent);
    }

    public void setMaxDescLengthForTests(int maxDescLengthForTests) {
        this.maxDescLengthForTests = maxDescLengthForTests;
    }

    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        if (this.encoding == null && locator instanceof Locator2) {
            this.encoding = ((Locator2)locator).getEncoding();
        }
    }

    public void setAllElementsToFields(boolean allElementsToFields) {
        this.allElementsToFields = allElementsToFields;
    }

    public void setGeneratesCompletionFields(boolean generatesCompletionFields) {
        this.generatesCompletionFields = generatesCompletionFields;
    }

    static class SkimmingEndedException
    extends SAXException {
        SkimmingEndedException() {
        }
    }
}

