/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.textsearch.webhelp;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.facet.FacetQuery;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import ro.sync.textsearch.HTMLSearchQueryBuilder;
import ro.sync.textsearch.SearchOptions;
import ro.sync.textsearch.SemanticSearchQueryBuilder;
import ro.sync.textsearch.webhelp.AdvancedQueryChecker;
import ro.sync.textsearch.webhelp.embeddings.IEmbeddingProvider;

public class WebHelpQueryBuilder {
    private static final float KEYWORDS_QUERY_BOOST = 0.55f;
    private static final float SEMANTIC_QUERY_BOOST = 0.45f;
    private String searchText;
    private Analyzer analyzer;
    private SearchOptions searchOptions;
    private boolean activateWildcardScoring;
    private String termMatchingPattern;
    private IEmbeddingProvider embeddingsProvider;

    public WebHelpQueryBuilder(String searchText, Analyzer analyzer, SearchOptions searchOptions, boolean activateWildcardScoring, IEmbeddingProvider embeddingsProvider) {
        this.searchText = searchText;
        this.analyzer = analyzer;
        this.searchOptions = searchOptions;
        this.activateWildcardScoring = activateWildcardScoring;
        this.embeddingsProvider = embeddingsProvider;
    }

    public Query build() throws IndexSearcher.TooManyClauses, ParseException {
        Query q = null;
        SearchOptions.SearchScope searchScope = this.searchOptions.getSearchScope();
        q = searchScope == SearchOptions.SearchScope.IN_LABEL ? this.buildInLabelQuery(this.searchText) : this.buildSemanticAndKeywordQuery(true);
        return q;
    }

    public Query buildHighlightQuery() throws IndexSearcher.TooManyClauses, ParseException {
        Query q = null;
        SearchOptions.SearchScope searchScope = this.searchOptions.getSearchScope();
        q = searchScope == SearchOptions.SearchScope.IN_LABEL ? this.buildInLabelQuery(this.searchText) : this.buildSemanticAndKeywordQuery(false);
        return q;
    }

    public Query addFacets(Query query) {
        List<String> facets = this.getFacetsFrom(this.searchOptions);
        return this.addFacets(query, facets);
    }

    public Query addFacets(Query query, List<String> facets) {
        BooleanQuery.Builder compoundBuilder = new BooleanQuery.Builder();
        if (!facets.isEmpty()) {
            Query facetsQuery = this.createFacetsQuery(facets);
            compoundBuilder.add(facetsQuery, BooleanClause.Occur.MUST);
            compoundBuilder.add(query, BooleanClause.Occur.MUST);
        } else {
            compoundBuilder.add(query, BooleanClause.Occur.MUST);
        }
        return compoundBuilder.build();
    }

    public String getTermMatchingPattern() {
        return this.termMatchingPattern;
    }

    private Query buildInLabelQuery(String text) {
        TermQuery termQuery = new TermQuery(new Term("label", text));
        return new BooleanQuery.Builder().add((Query)termQuery, BooleanClause.Occur.MUST).build();
    }

    private Query buildSemanticAndKeywordQuery(boolean includeSemanticQuery) throws ParseException {
        BooleanQuery.Builder compoundBuilder = new BooleanQuery.Builder();
        if (AdvancedQueryChecker.isAdvancedQuery(this.searchText, this.analyzer)) {
            includeSemanticQuery = false;
        }
        HTMLSearchQueryBuilder htmlSearchQueryBuilder = new HTMLSearchQueryBuilder(this.analyzer, this.searchText, this.searchOptions, this.activateWildcardScoring);
        this.termMatchingPattern = htmlSearchQueryBuilder.getTermMatchingPattern();
        Query keywordsQuery = htmlSearchQueryBuilder.getQuery();
        compoundBuilder.add((Query)new BoostQuery(keywordsQuery, 0.55f), BooleanClause.Occur.SHOULD);
        if (includeSemanticQuery) {
            Query semanticQuery = new SemanticSearchQueryBuilder(this.searchText, this.embeddingsProvider).build();
            compoundBuilder.add((Query)new BoostQuery(semanticQuery, 0.45f), BooleanClause.Occur.SHOULD);
        }
        return compoundBuilder.build();
    }

    private List<String> getFacetsFrom(SearchOptions searchOptions) {
        List<String> facetsList = null;
        String facets = searchOptions.getFacets();
        facetsList = facets.isEmpty() ? Collections.emptyList() : Arrays.asList(facets.split(";"));
        return facetsList;
    }

    protected Query createFacetsQuery(List<String> facetsCollection) {
        BooleanQuery.Builder bq = new BooleanQuery.Builder();
        boolean[] isFacetCollectionUsed = new boolean[facetsCollection.size()];
        for (int i = 0; i < facetsCollection.size(); ++i) {
            if (isFacetCollectionUsed[i]) continue;
            BooleanQuery.Builder tempBq = new BooleanQuery.Builder();
            String facetName = facetsCollection.get(i).split("/")[0];
            for (int j = 0; j < facetsCollection.size(); ++j) {
                if (!facetsCollection.get(j).startsWith(facetName)) continue;
                isFacetCollectionUsed[j] = Boolean.TRUE;
                String facet = facetsCollection.get(j);
                String[] parsedFacet = facet.split("/");
                String currentFacetName = parsedFacet[0];
                String[] facetPath = Arrays.copyOfRange(parsedFacet, 1, parsedFacet.length);
                FacetQuery q = new FacetQuery(currentFacetName, facetPath);
                tempBq.add((Query)q, BooleanClause.Occur.SHOULD);
            }
            bq.add((Query)tempBq.build(), BooleanClause.Occur.MUST);
        }
        return bq.build();
    }
}

