/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.textsearch.util;

import ro.sync.textsearch.util.Normalizer;

public class TrimUtil {
    private TrimUtil() {
    }

    public static int trimToWordBoundary(char[] buffer, int maxLen, int bufferLen) {
        if (bufferLen > maxLen) {
            for (bufferLen = maxLen; bufferLen > 0 && !Character.isWhitespace(buffer[bufferLen - 1]); --bufferLen) {
            }
            if (bufferLen > 0 && Character.isWhitespace(buffer[bufferLen - 1])) {
                --bufferLen;
            }
            if (bufferLen < 0) {
                bufferLen = 0;
            }
        }
        return bufferLen;
    }

    public static String extractDescription(Normalizer normalizer, String text, int descriptionMaxLength) {
        char[] charArray = text.toCharArray();
        int l = normalizer.normalizeArray(charArray, 0, charArray.length, true);
        char[] buff = normalizer.getBuffer();
        l = TrimUtil.trimToWordBoundary(buff, descriptionMaxLength, l);
        return new String(buff, 0, l);
    }
}

