/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.textsearch.completion.trie;

import java.util.HashMap;
import java.util.Map;

public class SimilarityTrieNode {
    private HashMap<String, SimilarityTrieNode> children = new HashMap();
    SimilarityTrieNode parent;
    private String content;
    private boolean isMarked;
    private int score;

    SimilarityTrieNode(String content, SimilarityTrieNode parent) {
        this.content = content;
        this.score = 1;
        this.isMarked = false;
        this.parent = parent;
    }

    SimilarityTrieNode(String content) {
        this(content, null);
    }

    public void setMarked(boolean value) {
        this.isMarked = value;
    }

    public void setMarked() {
        this.isMarked = true;
    }

    public void resetMarked() {
        this.isMarked = false;
    }

    public boolean getMarked() {
        return this.isMarked;
    }

    public Map<String, SimilarityTrieNode> getChildren() {
        return this.children;
    }

    public SimilarityTrieNode getParent() {
        return this.parent;
    }

    public void addChild(String key, SimilarityTrieNode child) {
        this.children.put(key, child);
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public int getScore() {
        return this.score;
    }

    public void setScore(int score) {
        this.score = score;
    }

    public void incrementScore(int increment) {
        this.score += increment;
    }

    public void printPretty(String indent, Boolean last, StringBuilder result) {
        indent = last != false ? (String)indent + "  " : (String)indent + "| ";
        result.append((String)indent + this.content + " " + this.score + "\n");
        int i = 0;
        for (SimilarityTrieNode child : this.children.values()) {
            child.printPretty((String)indent, i == this.children.size() - 1, result);
            ++i;
        }
    }
}

