/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.textsearch.completion.trie;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.textsearch.completion.Completion;
import ro.sync.textsearch.completion.CompletionOptions;
import ro.sync.textsearch.completion.ScoredCompletion;
import ro.sync.textsearch.completion.trie.EndCompletionsNodes;
import ro.sync.textsearch.completion.trie.SimilarityTrieNode;

public class SimilarityTrie {
    private static final Logger logger = LoggerFactory.getLogger((String)SimilarityTrie.class.getName());
    private SimilarityTrieNode similarityTrieRoot;
    private CompletionOptions completionOptions;
    private EndCompletionsNodes endCompletionsNodes;
    private static final int MINIMUM_NUMBER_OF_CHARS_FROM_COMPLETIONS = 2;

    SimilarityTrie() {
        this.similarityTrieRoot = new SimilarityTrieNode("");
    }

    public SimilarityTrie(List<Completion> completionList, CompletionOptions completionOptions) {
        this.completionOptions = completionOptions;
        this.similarityTrieRoot = new SimilarityTrieNode("");
        this.endCompletionsNodes = new EndCompletionsNodes(completionOptions.getMaximumNumberOfCompletionsWithSameLength());
        for (Completion completion : completionList) {
            this.insert(completion);
        }
    }

    void insert(Completion completion) {
        SimilarityTrieNode currentNode = this.similarityTrieRoot;
        this.similarityTrieRoot.incrementScore(1);
        for (String token : completion.getTokens()) {
            if (currentNode.getChildren().containsKey(token)) {
                currentNode.getChildren().get(token).incrementScore(1);
            } else {
                currentNode.addChild(token, new SimilarityTrieNode(token, currentNode));
            }
            currentNode = currentNode.getChildren().get(token);
        }
    }

    public SimilarityTrieNode getRoot() {
        return this.similarityTrieRoot;
    }

    void computeBestScoreAndEndNodeByLength(SimilarityTrieNode node, int depth, int maximumCompletionSize) {
        if (depth > maximumCompletionSize) {
            return;
        }
        for (SimilarityTrieNode child : node.getChildren().values()) {
            this.computeBestScoreAndEndNodeByLength(child, depth + 1, maximumCompletionSize);
        }
        if (node != this.getRoot()) {
            this.endCompletionsNodes.addNode(node, depth);
        }
    }

    public List<ScoredCompletion> computeBestCompletions() {
        this.computeBestScoreAndEndNodeByLength(this.getRoot(), 0, this.completionOptions.getMaximumCompletionSize());
        ArrayList<ScoredCompletion> result = new ArrayList<ScoredCompletion>();
        List<SimilarityTrieNode> endNodes = this.endCompletionsNodes.getAllNodes();
        for (SimilarityTrieNode node : endNodes) {
            SimilarityTrieNode aux = node;
            if (aux.getScore() < this.completionOptions.getMinimumScoreForValidCompletion()) continue;
            ArrayList<String> path = new ArrayList<String>();
            ScoredCompletion completion = null;
            while (aux.getParent() != null) {
                path.add(aux.getContent());
                aux = aux.getParent();
            }
            String[] completionTokens = new String[path.size()];
            int i = 0;
            for (int j = path.size() - 1; j >= 0; --j) {
                completionTokens[j] = (String)path.get(i);
                ++i;
            }
            completion = new ScoredCompletion((float)node.getScore(), completionTokens);
            this.mergeCompletionIntoList(completion, result);
        }
        result.sort((o1, o2) -> o1.getScore() != o2.getScore() ? (int)(o2.getScore() - o1.getScore()) : o2.getTokens().length - o1.getTokens().length);
        return result;
    }

    private void mergeCompletionIntoList(ScoredCompletion completion, List<ScoredCompletion> list) {
        boolean shouldAdd = this.isSignficantContent(completion);
        int position = 0;
        for (ScoredCompletion it : list) {
            if (completion.getScore() <= it.getScore() && this.isPrefix(completion, it)) {
                shouldAdd = false;
            } else if (it.getScore() <= completion.getScore() && this.isPrefix(it, completion)) {
                list.remove(position);
                list.add(position, completion);
                shouldAdd = false;
            }
            if (!shouldAdd) break;
            ++position;
        }
        if (shouldAdd) {
            list.add(completion);
        }
    }

    private boolean isSignficantContent(ScoredCompletion completion) {
        boolean result = false;
        String[] tokens = completion.getTokens();
        int sum = 0;
        for (String token : tokens) {
            if ((sum += token.length()) < 2) continue;
            result = true;
            break;
        }
        return result;
    }

    private boolean isPrefix(ScoredCompletion prefix, ScoredCompletion completion) {
        boolean result = false;
        if (prefix.getTokens().length < completion.getTokens().length) {
            result = true;
            int prefixNumberOfTokens = prefix.getTokens().length;
            for (int i = 0; i < prefixNumberOfTokens; ++i) {
                if (prefix.getTokens()[i].equals(completion.getTokens()[i])) continue;
                result = false;
            }
        }
        return result;
    }

    void dump(List<ScoredCompletion> result) {
        logger.info("Number of completions {}", (Object)result.size());
        for (ScoredCompletion completion : result) {
            StringBuilder sb = new StringBuilder();
            String[] tokens = completion.getTokens();
            for (int i = 0; i < tokens.length; ++i) {
                sb.append(tokens[i] + " ");
            }
            sb.append(completion.getScore());
            logger.info("Completion: {}", (Object)sb);
        }
    }
}

