/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.textsearch.completion;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.index.StoredFields;
import org.apache.lucene.search.IndexSearcher;
import ro.sync.textsearch.completion.Completion;
import ro.sync.textsearch.completion.RawCompletion;

public abstract class CompletionExtractor {
    private static final RawCompletion EMPTY_COMPLETION = new RawCompletion(new String[0]);
    protected static final char[] SPECIAL_END_STOP_TOKEN_CHARS = new char[]{'.', '?', '!', ';', ':', ',', '\u0003'};
    protected int maximumCompletionSize;
    protected IndexSearcher searcher;

    public CompletionExtractor(IndexSearcher searcher, int maximumCompletionSize) {
        this.searcher = searcher;
        this.maximumCompletionSize = maximumCompletionSize;
    }

    public List<Completion> getCompletionsFromDocument(int docId, List<Integer> endsOfSpans) throws IOException {
        List<Completion> completions = this.getCompletionsFromDocumentInternal(docId, endsOfSpans);
        return this.truncateCompletionsAtSpecialChars(completions);
    }

    protected abstract List<Completion> getCompletionsFromDocumentInternal(int var1, List<Integer> var2) throws IOException;

    protected int getCompletionEndIndex(int docSize, Integer endIndex) {
        int endCompletionIndex = endIndex + this.maximumCompletionSize;
        if (endCompletionIndex > docSize) {
            endCompletionIndex = docSize;
        }
        return endCompletionIndex;
    }

    protected String getURI(int docId) throws IOException {
        StoredFields storedFields = this.searcher.getIndexReader().storedFields();
        return storedFields.document(docId).get("__uri__");
    }

    protected List<Completion> truncateCompletionsAtSpecialChars(List<Completion> completions) {
        ArrayList<Completion> result = new ArrayList<Completion>(completions.size());
        for (Completion completion : completions) {
            Completion truncatedCompletion = this.truncateTokensFromCompletionAtSpecialChars(completion);
            if (truncatedCompletion.isEmpty()) continue;
            result.add(truncatedCompletion);
        }
        return result;
    }

    private Completion truncateTokensFromCompletionAtSpecialChars(Completion completion) {
        Completion truncatedCompletion = completion;
        String[] tokens = completion.tokens;
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (!CompletionExtractor.endsWithSpecialChar(token, SPECIAL_END_STOP_TOKEN_CHARS)) continue;
            if (token.length() == 1 && i == 0) {
                truncatedCompletion = EMPTY_COMPLETION;
                break;
            }
            int positionToRemoveTokens = token.length() == 1 ? i : i + 1;
            truncatedCompletion = this.keepFirstTokens(tokens, positionToRemoveTokens);
            break;
        }
        return truncatedCompletion;
    }

    private Completion keepFirstTokens(String[] tokens, int len) {
        String[] array = new String[len];
        System.arraycopy(tokens, 0, array, 0, len);
        return new RawCompletion(array);
    }

    public static boolean endsWithSpecialChar(String token, char[] specialChars) {
        char endChar;
        boolean result = false;
        if (token.length() > 0 && !Character.isAlphabetic(endChar = token.charAt(token.length() - 1))) {
            for (int i = 0; i < specialChars.length; ++i) {
                if (endChar != specialChars[i]) continue;
                result = true;
                break;
            }
        }
        return result;
    }
}

