/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.textsearch.completion;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.core.StopFilter;
import org.apache.lucene.analysis.en.EnglishAnalyzer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;

public class CompletionEngineUtil {
    private CompletionEngineUtil() {
    }

    public static List<String> tokenizeString(String toTokenize, Analyzer analyzer) throws IOException {
        return CompletionEngineUtil.tokenizeString(toTokenize, analyzer, "__completion_terms__", false, null);
    }

    public static List<String> tokenizeString(String toTokenize, Analyzer analyzer, String fieldName, boolean removeStopWords, List<String> stopWords) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        try (TokenStream tokenStream = CompletionEngineUtil.createTokenStream(analyzer, fieldName, toTokenize, removeStopWords, stopWords);){
            CharTermAttribute attr = (CharTermAttribute)tokenStream.addAttribute(CharTermAttribute.class);
            tokenStream.reset();
            while (tokenStream.incrementToken()) {
                result.add(attr.toString());
            }
            tokenStream.end();
        }
        return result;
    }

    private static TokenStream createTokenStream(Analyzer analyzer, String fieldName, String text, boolean removeStopWords, List<String> stopWords) {
        TokenStream tokenStream = analyzer.tokenStream(fieldName, text);
        if (removeStopWords) {
            CharArraySet stopWordsSet = stopWords != null ? StopFilter.makeStopSet(stopWords, (boolean)true) : EnglishAnalyzer.getDefaultStopSet();
            tokenStream = new StopFilter(tokenStream, stopWordsSet);
        }
        return tokenStream;
    }
}

