/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.textsearch.analyzer;

import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.StopwordAnalyzerBase;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.en.EnglishAnalyzer;
import org.apache.lucene.analysis.standard.StandardTokenizer;

public class OriginalStandardAnalyzer
extends StopwordAnalyzerBase {
    public static final CharArraySet STOP_WORDS_SET = EnglishAnalyzer.ENGLISH_STOP_WORDS_SET;
    public static final int DEFAULT_MAX_TOKEN_LENGTH = 255;
    private int maxTokenLength = 255;

    public OriginalStandardAnalyzer(CharArraySet stopWords) {
        super(stopWords);
    }

    public OriginalStandardAnalyzer() {
        this(STOP_WORDS_SET);
    }

    public OriginalStandardAnalyzer(Reader stopwords) throws IOException {
        this(OriginalStandardAnalyzer.loadStopwordSet((Reader)stopwords));
    }

    public void setMaxTokenLength(int length) {
        this.maxTokenLength = length;
    }

    public int getMaxTokenLength() {
        return this.maxTokenLength;
    }

    protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
        StandardTokenizer src = new StandardTokenizer();
        src.setMaxTokenLength(this.maxTokenLength);
        LowerCaseFilter tok = new LowerCaseFilter((TokenStream)src);
        tok = new StopFilter((TokenStream)tok, this.stopwords);
        return new Analyzer.TokenStreamComponents(r -> {
            src.setMaxTokenLength(this.maxTokenLength);
            src.setReader(r);
        }, (TokenStream)tok);
    }

    protected TokenStream normalize(String fieldName, TokenStream in) {
        return new LowerCaseFilter(in);
    }
}

